/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.config.amqpBrokerConnectivity;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.activemq.artemis.core.config.TransformerConfiguration;

public final class AMQPBridgeAddressPolicyElement
implements Serializable {
    private static final long serialVersionUID = 6515270736587053708L;
    private final Set<AddressMatch> includes = new HashSet<AddressMatch>();
    private final Set<AddressMatch> excludes = new HashSet<AddressMatch>();
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private String name;
    private String remoteAddress;
    private String remoteAddressPrefix;
    private String remoteAddressSuffix;
    private String[] remoteTerminusCapabilities;
    private boolean includeDivertBindings;
    private Integer priority;
    private String filter;
    private TransformerConfiguration transformerConfig;

    public String getName() {
        return this.name;
    }

    public AMQPBridgeAddressPolicyElement setName(String name) {
        this.name = name;
        return this;
    }

    public Set<AddressMatch> getIncludes() {
        return this.includes;
    }

    public AMQPBridgeAddressPolicyElement addToIncludes(String include) {
        this.includes.add(new AddressMatch().setAddressMatch(include));
        return this;
    }

    public AMQPBridgeAddressPolicyElement addInclude(AddressMatch include) {
        this.includes.add(include);
        return this;
    }

    public AMQPBridgeAddressPolicyElement setIncludes(Set<AddressMatch> includes) {
        this.includes.clear();
        if (includes != null) {
            this.includes.addAll(includes);
        }
        return this;
    }

    public Set<AddressMatch> getExcludes() {
        return this.excludes;
    }

    public AMQPBridgeAddressPolicyElement addToExcludes(String exclude) {
        this.excludes.add(new AddressMatch().setAddressMatch(exclude));
        return this;
    }

    public AMQPBridgeAddressPolicyElement addExclude(AddressMatch exclude) {
        this.excludes.add(exclude);
        return this;
    }

    public AMQPBridgeAddressPolicyElement setExcludes(Set<AddressMatch> excludes) {
        this.excludes.clear();
        if (excludes != null) {
            this.excludes.addAll(excludes);
        }
        return this;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public AMQPBridgeAddressPolicyElement addProperty(String key, String value) {
        this.properties.put(key, value);
        return this;
    }

    public AMQPBridgeAddressPolicyElement addProperty(String key, Number value) {
        this.properties.put(key, value);
        return this;
    }

    public AMQPBridgeAddressPolicyElement setProperties(Map<String, Object> properties) {
        this.properties.clear();
        if (properties != null) {
            this.properties.putAll(properties);
        }
        return this;
    }

    public boolean isIncludeDivertBindings() {
        return this.includeDivertBindings;
    }

    public AMQPBridgeAddressPolicyElement setIncludeDivertBindings(boolean includeDivertBindings) {
        this.includeDivertBindings = includeDivertBindings;
        return this;
    }

    public AMQPBridgeAddressPolicyElement setTransformerConfiguration(TransformerConfiguration transformerConfig) {
        this.transformerConfig = transformerConfig;
        return this;
    }

    public TransformerConfiguration getTransformerConfiguration() {
        return this.transformerConfig;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public AMQPBridgeAddressPolicyElement setRemoteAddress(String remoteAddress) {
        this.remoteAddress = remoteAddress;
        return this;
    }

    public String getRemoteAddressPrefix() {
        return this.remoteAddressPrefix;
    }

    public AMQPBridgeAddressPolicyElement setRemoteAddressPrefix(String remoteAddressPrefix) {
        this.remoteAddressPrefix = remoteAddressPrefix;
        return this;
    }

    public String getRemoteAddressSuffix() {
        return this.remoteAddressSuffix;
    }

    public AMQPBridgeAddressPolicyElement setRemoteAddressSuffix(String remoteAddressSuffix) {
        this.remoteAddressSuffix = remoteAddressSuffix;
        return this;
    }

    public String[] getRemoteTerminusCapabilities() {
        if (this.remoteTerminusCapabilities != null) {
            return Arrays.copyOf(this.remoteTerminusCapabilities, this.remoteTerminusCapabilities.length);
        }
        return null;
    }

    public AMQPBridgeAddressPolicyElement setRemoteTerminusCapabilities(String[] remoteTerminusCapabilities) {
        this.remoteTerminusCapabilities = remoteTerminusCapabilities;
        return this;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public AMQPBridgeAddressPolicyElement setPriority(Integer priority) {
        this.priority = priority;
        return this;
    }

    public String getFilter() {
        return this.filter;
    }

    public AMQPBridgeAddressPolicyElement setFilter(String filter) {
        this.filter = filter;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AMQPBridgeAddressPolicyElement)) {
            return false;
        }
        AMQPBridgeAddressPolicyElement that = (AMQPBridgeAddressPolicyElement)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.includes, that.includes) && Objects.equals(this.excludes, that.excludes) && Objects.equals(this.priority, that.priority) && Objects.equals(this.filter, that.filter) && Objects.equals(this.remoteAddress, that.remoteAddress) && Objects.equals(this.remoteAddressPrefix, that.remoteAddressPrefix) && Objects.equals(this.remoteAddressSuffix, that.remoteAddressSuffix) && Arrays.equals(this.remoteTerminusCapabilities, that.remoteTerminusCapabilities);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.includes, this.excludes, this.filter, this.priority, this.remoteAddress, this.remoteAddressPrefix, this.remoteAddressSuffix) + Arrays.hashCode(this.remoteTerminusCapabilities);
    }

    public static class AddressMatch
    implements Serializable {
        private static final long serialVersionUID = 8517154638045698017L;
        private String name;
        private String addressMatch;

        public String getName() {
            return this.name;
        }

        public AddressMatch setName(String name) {
            this.name = name;
            return this;
        }

        public String getAddressMatch() {
            return this.addressMatch;
        }

        public AddressMatch setAddressMatch(String addressMatch) {
            this.addressMatch = addressMatch;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AddressMatch)) {
                return false;
            }
            AddressMatch matcher = (AddressMatch)o;
            return Objects.equals(this.addressMatch, matcher.addressMatch);
        }

        public int hashCode() {
            return Objects.hash(this.addressMatch, this.addressMatch);
        }
    }
}

