/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.stream.Collectors;
import org.apache.flink.runtime.taskexecutor.SlotStatus;
import org.apache.flink.util.Preconditions;

public class SlotReport
implements Serializable,
Iterable<SlotStatus> {
    private static final long serialVersionUID = -3150175198722481689L;
    private final Collection<SlotStatus> slotsStatus;

    public SlotReport() {
        this(Collections.emptyList());
    }

    public SlotReport(SlotStatus slotStatus) {
        this(Collections.singletonList(slotStatus));
    }

    public SlotReport(Collection<SlotStatus> slotsStatus) {
        this.slotsStatus = (Collection)Preconditions.checkNotNull(slotsStatus);
    }

    public int getNumSlotStatus() {
        return this.slotsStatus.size();
    }

    public boolean hasAllocatedSlot() {
        for (SlotStatus status : this.slotsStatus) {
            if (status.getAllocationID() == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<SlotStatus> iterator() {
        return this.slotsStatus.iterator();
    }

    public String toString() {
        String lineSeparator = this.slotsStatus.size() == 1 || this.slotsStatus.size() > 10 ? "" : System.lineSeparator() + "\t";
        return this.slotsStatus.stream().map(SlotStatus::toString).collect(Collectors.joining(lineSeparator, "SlotReport{" + lineSeparator, "}"));
    }
}

