/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.oauth;

import com.dropbox.core.DbxAuthFinish;
import com.dropbox.core.json.JsonReadException;
import com.dropbox.core.json.JsonReader;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;

public class DbxRefreshResult {
    private final String accessToken;
    private final long expiresIn;
    private long issueTime;
    private String scope;
    public static final JsonReader<DbxRefreshResult> Reader = new JsonReader<DbxRefreshResult>(){

        @Override
        public DbxRefreshResult read(JsonParser parser) throws IOException, JsonReadException {
            JsonLocation top = JsonReader.expectObjectStart(parser);
            String tokenType = null;
            String accessToken = null;
            Long expiresIn = null;
            String scope = null;
            while (parser.getCurrentToken() == JsonToken.FIELD_NAME) {
                String fieldName = parser.getCurrentName();
                JsonReader.nextToken(parser);
                try {
                    if (fieldName.equals("token_type")) {
                        tokenType = DbxAuthFinish.BearerTokenTypeReader.readField(parser, fieldName, tokenType);
                        continue;
                    }
                    if (fieldName.equals("access_token")) {
                        accessToken = DbxAuthFinish.AccessTokenReader.readField(parser, fieldName, accessToken);
                        continue;
                    }
                    if (fieldName.equals("expires_in")) {
                        expiresIn = JsonReader.UInt64Reader.readField(parser, fieldName, expiresIn);
                        continue;
                    }
                    if (fieldName.equals("scope")) {
                        scope = JsonReader.StringReader.readField(parser, fieldName, scope);
                        continue;
                    }
                    JsonReader.skipValue(parser);
                }
                catch (JsonReadException ex) {
                    throw ex.addFieldContext(fieldName);
                }
            }
            JsonReader.expectObjectEnd(parser);
            if (tokenType == null) {
                throw new JsonReadException("missing field \"token_type\"", top);
            }
            if (accessToken == null) {
                throw new JsonReadException("missing field \"access_token\"", top);
            }
            if (expiresIn == null) {
                throw new JsonReadException("missing field \"expires_in\"", top);
            }
            return new DbxRefreshResult(accessToken, expiresIn, scope);
        }
    };

    public DbxRefreshResult(String accessToken, long expiresIn) {
        this(accessToken, expiresIn, null);
    }

    public DbxRefreshResult(String accessToken, long expiresIn, String scope) {
        if (accessToken == null) {
            throw new IllegalArgumentException("access token can't be null.");
        }
        this.accessToken = accessToken;
        this.expiresIn = expiresIn;
        this.issueTime = System.currentTimeMillis();
        this.scope = scope;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public Long getExpiresAt() {
        return this.issueTime + this.expiresIn * 1000L;
    }

    public String getScope() {
        return this.scope;
    }

    void setIssueTime(long issueTime) {
        this.issueTime = issueTime;
    }
}

