/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transform;

import java.util.List;
import org.apache.commons.lang.BooleanUtils;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.util.StringUtil;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.transform.TransformMeta;

public class TransformOption {
    private static final Class<?> PKG = TransformOption.class;
    private final String key;
    private final String text;
    private String value;

    public TransformOption(String key, String text, String value) {
        this.key = key;
        this.text = text;
        this.value = value;
    }

    public String getKey() {
        return this.key;
    }

    public String getText() {
        return this.text;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public static void checkInteger(List<ICheckResult> remarks, TransformMeta transformMeta, IVariables variables, String identifier, String value) {
        try {
            if (!StringUtil.isEmpty((String)variables.resolve(value))) {
                Integer.parseInt(variables.resolve(value));
            }
        }
        catch (NumberFormatException e) {
            remarks.add((ICheckResult)new CheckResult(4, BaseMessages.getString(PKG, (String)"TransformOption.CheckResult.NotAInteger", (String[])new String[]{identifier}), (ICheckResultSource)transformMeta));
        }
    }

    public static void checkLong(List<ICheckResult> remarks, TransformMeta transformMeta, IVariables variables, String identifier, String value) {
        try {
            if (!StringUtil.isEmpty((String)variables.resolve(value))) {
                Long.parseLong(variables.resolve(value));
            }
        }
        catch (NumberFormatException e) {
            remarks.add((ICheckResult)new CheckResult(4, BaseMessages.getString(PKG, (String)"TransformOption.CheckResult.NotAInteger", (String[])new String[]{identifier}), (ICheckResultSource)transformMeta));
        }
    }

    public static void checkBoolean(List<ICheckResult> remarks, TransformMeta transformMeta, IVariables variables, String identifier, String value) {
        if (!StringUtil.isEmpty((String)variables.resolve(value)) && null == BooleanUtils.toBooleanObject((String)variables.resolve(value))) {
            remarks.add((ICheckResult)new CheckResult(4, BaseMessages.getString(PKG, (String)"TransformOption.CheckResult.NotABoolean", (String[])new String[]{identifier}), (ICheckResultSource)transformMeta));
        }
    }
}

