/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import org.apache.beam.sdk.transforms.Combine;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;

public class Sum {
    private Sum() {
    }

    public static @UnknownKeyFor @NonNull @Initialized Combine.Globally<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized Integer> integersGlobally() {
        return Combine.globally(Sum.ofIntegers());
    }

    public static <K> @UnknownKeyFor @NonNull @Initialized Combine.PerKey<K, @UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized Integer> integersPerKey() {
        return Combine.perKey(Sum.ofIntegers());
    }

    public static @UnknownKeyFor @NonNull @Initialized Combine.Globally<@UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized Long> longsGlobally() {
        return Combine.globally(Sum.ofLongs());
    }

    public static <K> @UnknownKeyFor @NonNull @Initialized Combine.PerKey<K, @UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized Long> longsPerKey() {
        return Combine.perKey(Sum.ofLongs());
    }

    public static @UnknownKeyFor @NonNull @Initialized Combine.Globally<@UnknownKeyFor @NonNull @Initialized Double, @UnknownKeyFor @NonNull @Initialized Double> doublesGlobally() {
        return Combine.globally(Sum.ofDoubles());
    }

    public static <K> @UnknownKeyFor @NonNull @Initialized Combine.PerKey<K, @UnknownKeyFor @NonNull @Initialized Double, @UnknownKeyFor @NonNull @Initialized Double> doublesPerKey() {
        return Combine.perKey(Sum.ofDoubles());
    }

    public static @UnknownKeyFor @NonNull @Initialized Combine.BinaryCombineIntegerFn ofIntegers() {
        return new SumIntegerFn();
    }

    public static @UnknownKeyFor @NonNull @Initialized Combine.BinaryCombineDoubleFn ofDoubles() {
        return new SumDoubleFn();
    }

    public static @UnknownKeyFor @NonNull @Initialized Combine.BinaryCombineLongFn ofLongs() {
        return new SumLongFn();
    }

    private static class SumDoubleFn
    extends Combine.BinaryCombineDoubleFn {
        private SumDoubleFn() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized double apply(@UnknownKeyFor @NonNull @Initialized double a, @UnknownKeyFor @NonNull @Initialized double b) {
            return a + b;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized double identity() {
            return 0.0;
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object other) {
            return other != null && other.getClass().equals(this.getClass());
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return this.getClass().hashCode();
        }
    }

    private static class SumLongFn
    extends Combine.BinaryCombineLongFn {
        private SumLongFn() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized long apply(@UnknownKeyFor @NonNull @Initialized long a, @UnknownKeyFor @NonNull @Initialized long b) {
            return a + b;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized long identity() {
            return 0L;
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object other) {
            return other != null && other.getClass().equals(this.getClass());
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return this.getClass().hashCode();
        }
    }

    private static class SumIntegerFn
    extends Combine.BinaryCombineIntegerFn {
        private SumIntegerFn() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized int apply(@UnknownKeyFor @NonNull @Initialized int a, @UnknownKeyFor @NonNull @Initialized int b) {
            return a + b;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized int identity() {
            return 0;
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object other) {
            return other != null && other.getClass().equals(this.getClass());
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return this.getClass().hashCode();
        }
    }
}

