/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.util.AbstractInvocationHandler;
import org.jetbrains.annotations.NotNull;

public enum Mocker {

    private static final Class[] NO_CLASSES = new Class[0];

    @NotNull
    public static <T> T logging(@NotNull Class<T> tClass, String description, @NotNull PrintStream out) {
        return Mocker.intercepting(tClass, description, out::println);
    }

    @NotNull
    public static <T> T logging(@NotNull Class<T> tClass, String description, @NotNull PrintWriter out) {
        return Mocker.intercepting(tClass, description, out::println);
    }

    @NotNull
    public static <T> T logging(@NotNull Class<T> tClass, String description, @NotNull StringWriter out) {
        return Mocker.logging(tClass, description, new PrintWriter(out));
    }

    @NotNull
    public static <T> T queuing(@NotNull Class<T> tClass, String description, @NotNull BlockingQueue<String> queue) {
        return Mocker.intercepting(tClass, description, queue::add);
    }

    @NotNull
    public static <T> T intercepting(@NotNull Class<T> tClass, String description, @NotNull Consumer<String> consumer) {
        return Mocker.intercepting(tClass, description, consumer, null);
    }

    @NotNull
    public static <T> T intercepting(@NotNull Class<T> tClass, @NotNull String description, @NotNull Consumer<String> consumer, T t) {
        return Mocker.intercepting(tClass, (String name, Object[] args) -> consumer.accept(description + name + (args == null ? "()" : Arrays.toString(args))), t);
    }

    @NotNull
    public static <T> T intercepting(@NotNull Class<T> tClass, final @NotNull BiConsumer<String, Object[]> consumer, final T t) {
        LinkedHashSet<Class> classes = new LinkedHashSet<Class>();
        Mocker.addInterface(classes, tClass);
        return (T)Proxy.newProxyInstance(tClass.getClassLoader(), classes.toArray(NO_CLASSES), (InvocationHandler)new AbstractInvocationHandler(ConcurrentHashMap::new){

            @Override
            protected Object doInvoke(Object proxy, Method method, Object[] args) throws InvocationTargetException, IllegalAccessException {
                consumer.accept(method.getName(), args);
                if (t != null) {
                    return method.invoke(t, args);
                }
                return null;
            }
        });
    }

    private static <T> void addInterface(Set<Class> classes, Class<T> tClass) {
        if (Jvm.dontChain(tClass)) {
            return;
        }
        if (classes.contains(tClass)) {
            return;
        }
        classes.add(tClass);
        for (Method method : tClass.getMethods()) {
            Class<?> returnType = method.getReturnType();
            if (!returnType.isInterface()) continue;
            Mocker.addInterface(classes, returnType);
        }
    }

    @NotNull
    public static <T> T ignored(@NotNull Class<T> tClass, Class ... additional) {
        LinkedHashSet<Class> classes = new LinkedHashSet<Class>();
        Mocker.addInterface(classes, tClass);
        for (Class aClass : additional) {
            Mocker.addInterface(classes, aClass);
        }
        return (T)Proxy.newProxyInstance(tClass.getClassLoader(), classes.toArray(NO_CLASSES), (InvocationHandler)new AbstractInvocationHandler(ConcurrentHashMap::new){

            @Override
            protected Object doInvoke(Object proxy, Method method, Object[] args) throws InvocationTargetException, IllegalAccessException {
                return null;
            }
        });
    }
}

