/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider;

import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.AbstractFileNameParser;
import org.apache.commons.vfs2.provider.LayeredFileName;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.provider.VfsComponentContext;

public class LayeredFileNameParser
extends AbstractFileNameParser {
    private static final LayeredFileNameParser INSTANCE = new LayeredFileNameParser();

    public static LayeredFileNameParser getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean encodeCharacter(char ch) {
        return super.encodeCharacter(ch) || ch == '!';
    }

    protected String extractRootName(StringBuilder uri) {
        int pos;
        int maxlen = uri.length();
        for (pos = maxlen - 1; pos > 0 && uri.charAt(pos) != '!'; --pos) {
        }
        if (pos == 0 && uri.charAt(pos) != '!') {
            pos = maxlen;
        }
        String prefix = uri.substring(0, pos);
        if (pos < maxlen) {
            uri.delete(0, pos + 1);
        } else {
            uri.setLength(0);
        }
        return prefix;
    }

    @Override
    public FileName parseUri(VfsComponentContext context, FileName baseFileName, String fileName) throws FileSystemException {
        StringBuilder name = new StringBuilder();
        String scheme = UriParser.extractScheme(context.getFileSystemManager().getSchemes(), fileName, name);
        String rootUriName = this.extractRootName(name);
        FileName rootUri = null;
        if (rootUriName != null) {
            rootUri = context.parseURI(rootUriName);
        }
        UriParser.canonicalizePath(name, 0, name.length(), this);
        UriParser.fixSeparators(name);
        FileType fileType = UriParser.normalisePath(name);
        String path = name.toString();
        return new LayeredFileName(scheme, rootUri, path, fileType);
    }
}

