/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.drools.core.base.ValueType;
import org.drools.core.spi.WriteAccessor;

public class ClassFieldWriter
implements WriteAccessor {
    private static final long serialVersionUID = 510L;
    private String className;
    private String fieldName;
    private transient WriteAccessor writer;

    public ClassFieldWriter() {
    }

    public ClassFieldWriter(String className, String fieldName) {
        this.className = className;
        this.fieldName = fieldName;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.className);
        out.writeObject(this.fieldName);
    }

    @Override
    public void readExternal(ObjectInput is) throws ClassNotFoundException, IOException {
        this.className = (String)is.readObject();
        this.fieldName = (String)is.readObject();
    }

    public void setWriteAccessor(WriteAccessor writer) {
        this.writer = writer;
    }

    @Override
    public int getIndex() {
        return this.writer.getIndex();
    }

    public String getClassName() {
        return this.className;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String toString() {
        return "[ClassFieldWriter class=" + this.className + " field=" + this.fieldName + "]";
    }

    public int hashCode() {
        return this.getValueType().hashCode() * 17 + this.getIndex();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof ClassFieldWriter)) {
            return false;
        }
        ClassFieldWriter other = (ClassFieldWriter)object;
        return this.writer.getValueType() == other.getValueType() && this.writer.getIndex() == other.getIndex();
    }

    @Override
    public Class<?> getFieldType() {
        return this.writer.getFieldType();
    }

    @Override
    public Method getNativeWriteMethod() {
        return this.writer.getNativeWriteMethod();
    }

    @Override
    public ValueType getValueType() {
        return this.writer.getValueType();
    }

    @Override
    public void setBooleanValue(Object bean, boolean value) {
        this.writer.setBooleanValue(bean, value);
    }

    @Override
    public void setByteValue(Object bean, byte value) {
        this.writer.setByteValue(bean, value);
    }

    @Override
    public void setCharValue(Object bean, char value) {
        this.writer.setCharValue(bean, value);
    }

    @Override
    public void setDoubleValue(Object bean, double value) {
        this.writer.setDoubleValue(bean, value);
    }

    @Override
    public void setFloatValue(Object bean, float value) {
        this.writer.setFloatValue(bean, value);
    }

    @Override
    public void setIntValue(Object bean, int value) {
        this.writer.setIntValue(bean, value);
    }

    @Override
    public void setLongValue(Object bean, long value) {
        this.writer.setLongValue(bean, value);
    }

    @Override
    public void setShortValue(Object bean, short value) {
        this.writer.setShortValue(bean, value);
    }

    @Override
    public void setValue(Object bean, Object value) {
        this.writer.setValue(bean, value);
    }

    @Override
    public void setBigDecimalValue(Object bean, BigDecimal value) {
        this.writer.setBigDecimalValue(bean, value);
    }

    @Override
    public void setBigIntegerValue(Object bean, BigInteger value) {
        this.writer.setBigIntegerValue(bean, value);
    }
}

