/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.ArabicOption;
import com.ibm.as400.access.ArabicOptionSet;
import com.ibm.as400.access.BidiFlag;
import com.ibm.as400.access.BidiTransform;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.Trace;
import java.io.Serializable;

public class BidiConversionProperties
implements Serializable {
    static final long serialVersionUID = 4L;
    private int bidiStringType_ = 0;
    private boolean removeMarksOnImplicitToVisual_ = false;
    private boolean impToImp_ = true;
    private boolean roundTrip_;
    private boolean winCompatible_;
    private boolean insertMarkers_;
    private boolean removeMarkers_;
    private int options_;
    private boolean wordBreak_;
    private boolean destinationRequired_ = true;
    private boolean srcToDstMapRequired_;
    private boolean dstToSrcMapRequired_;
    private boolean propertyMapRequired_;
    private boolean continuation_;
    private int numeralShaping_ = 0;
    private int inpCount_;
    private int outCount_;
    private int[] srcToDstMap_;
    private int[] dstToSrcMap_;
    private byte[] propertyMap_;
    private boolean expandLamAlef = false;
    private transient int lastBidiStringType = -1;
    private transient boolean oldBidiNumericOrderingRoundTrip = false;
    private transient boolean oldBidiImplicitReordering = true;
    public static final int NUMERALS_DEFAULT = 0;
    public static final int NUMERALS_NOMINAL = 1;
    public static final int NUMERALS_NATIONAL = 2;
    public static final int NUMERALS_CONTEXTUAL = 3;
    public static final int NUMERALS_ANY = 4;

    public BidiConversionProperties() {
        if (Trace.traceConversion_) {
            this.traceLog(1, "Constructing BidiConversionProperties.");
        }
    }

    BidiConversionProperties(int bidiStringType) {
        this.setBidiStringType(bidiStringType);
    }

    BidiConversionProperties(int bidiStringType, BidiTransform transform, boolean removeMarkersOnImplicitToVisual) {
        this.setBidiStringType(bidiStringType);
        this.impToImp_ = transform.impToImp;
        this.roundTrip_ = transform.roundTrip;
        this.winCompatible_ = transform.winCompatible;
        this.insertMarkers_ = transform.insertMarkers;
        this.removeMarkers_ = transform.removeMarkers;
        if (transform.options != null) {
            this.options_ = transform.options.value;
        }
        this.wordBreak_ = transform.wordBreak;
        this.destinationRequired_ = transform.destinationRequired;
        this.srcToDstMapRequired_ = transform.srcToDstMapRequired;
        this.dstToSrcMapRequired_ = transform.dstToSrcMapRequired;
        this.propertyMapRequired_ = transform.propertyMapRequired;
        this.continuation_ = transform.continuation;
        this.removeMarksOnImplicitToVisual_ = removeMarkersOnImplicitToVisual;
        if (removeMarkersOnImplicitToVisual) {
            this.removeMarkers_ = false;
        }
        this.dstToSrcMap_ = transform.dstToSrcMap;
        this.srcToDstMap_ = transform.srcToDstMap;
        this.propertyMap_ = transform.propertyMap;
        this.inpCount_ = transform.inpCount;
        this.outCount_ = transform.outCount;
        this.getNumeralShapingFromTransform(transform);
        this.expandLamAlef = transform.options != null ? transform.options.getLamAlefMode() == ArabicOption.LAMALEF_RESIZE_BUFFER : false;
    }

    public void setBidiStringType(int bidiStringType) {
        if (Trace.traceConversion_ && bidiStringType != this.lastBidiStringType) {
            this.traceLog(1, "Setting bidi string type:" + bidiStringType);
            this.lastBidiStringType = bidiStringType;
        }
        if (bidiStringType != -1 && bidiStringType != 0 && (bidiStringType < 4 || bidiStringType > 11)) {
            this.traceLog(2, "Value of parameter 'bidiStringType' is not valid:" + bidiStringType);
            throw new ExtendedIllegalArgumentException("bidiStringType (" + bidiStringType + ")", 2);
        }
        this.bidiStringType_ = bidiStringType;
    }

    public int getBidiStringType() {
        if (Trace.traceConversion_) {
            this.traceLog(1, "Getting bidi string type:" + this.bidiStringType_);
        }
        return this.bidiStringType_;
    }

    public void setBidiRemoveMarksOnImplicitToVisual(boolean removeMarks) {
        if (Trace.traceConversion_) {
            this.traceLog(1, "Setting bidi remove the directional marks only when transforming from logical to visual property:" + removeMarks);
        }
        this.removeMarksOnImplicitToVisual_ = removeMarks;
    }

    public boolean isBidiRemoveMarksOnImplicitToVisual() {
        if (Trace.traceConversion_) {
            this.traceLog(1, "Checking if remove the directional marks only when transforming from logical to visual property is set:" + this.removeMarksOnImplicitToVisual_);
        }
        return this.removeMarksOnImplicitToVisual_;
    }

    void copyOptionsTo(BidiTransform destination) {
        destination.impToImp = this.impToImp_;
        destination.roundTrip = this.roundTrip_;
        destination.winCompatible = this.winCompatible_;
        destination.insertMarkers = this.insertMarkers_;
        destination.removeMarkers = this.removeMarkers_;
        if (this.options_ == 0) {
            destination.options = null;
        } else {
            destination.options.value = this.options_;
        }
        ArabicOptionSet aos = new ArabicOptionSet();
        int n = aos.value = destination.options == null ? 0 : destination.options.value;
        if (this.expandLamAlef) {
            aos.setOneOption(ArabicOption.LAMALEF_RESIZE_BUFFER);
            destination.options = new ArabicOptionSet(aos);
        }
        destination.wordBreak = this.wordBreak_;
        destination.destinationRequired = this.destinationRequired_;
        destination.srcToDstMapRequired = this.srcToDstMapRequired_;
        destination.dstToSrcMapRequired = this.dstToSrcMapRequired_;
        destination.propertyMapRequired = this.propertyMapRequired_;
        destination.continuation = this.continuation_;
        this.setNumeralShapingOnTransform(destination);
    }

    void setNumeralShapingOnTransform(BidiTransform destination) {
        switch (this.numeralShaping_) {
            case 1: {
                destination.flags.setOneFlag(BidiFlag.NUMERALS_NOMINAL);
                break;
            }
            case 2: {
                destination.flags.setOneFlag(BidiFlag.NUMERALS_NATIONAL);
                break;
            }
            case 3: {
                destination.flags.setOneFlag(BidiFlag.NUMERALS_CONTEXTUAL);
                break;
            }
            case 4: {
                destination.flags.setOneFlag(BidiFlag.NUMERALS_ANY);
                break;
            }
        }
    }

    void getNumeralShapingFromTransform(BidiTransform source) {
        BidiFlag flag = source.flags.getNumerals();
        if (flag == BidiFlag.NUMERALS_NOMINAL) {
            this.numeralShaping_ = 1;
        } else if (flag == BidiFlag.NUMERALS_NATIONAL) {
            this.numeralShaping_ = 2;
        } else if (flag == BidiFlag.NUMERALS_CONTEXTUAL) {
            this.numeralShaping_ = 3;
        } else if (flag == BidiFlag.NUMERALS_ANY) {
            this.numeralShaping_ = 4;
        }
    }

    public void setBidiImplicitReordering(boolean bidiImplicitReordering) {
        if (Trace.traceConversion_ && bidiImplicitReordering != this.oldBidiImplicitReordering) {
            this.traceLog(1, "Setting bidi implicit LTR-RTL reordering:" + bidiImplicitReordering);
            this.oldBidiImplicitReordering = bidiImplicitReordering;
        }
        this.impToImp_ = bidiImplicitReordering;
    }

    public boolean isBidiImplicitReordering() {
        if (Trace.traceConversion_) {
            this.traceLog(1, "Checking if bidi implicit LTR-RTL reordering:" + this.impToImp_);
        }
        return this.impToImp_;
    }

    public void setBidiNumericOrderingRoundTrip(boolean bidiNumericOrderingRoundTrip) {
        if (Trace.traceConversion_ && this.oldBidiNumericOrderingRoundTrip != bidiNumericOrderingRoundTrip) {
            this.traceLog(1, "Setting bidi numeric ordering round trip:" + bidiNumericOrderingRoundTrip);
            this.oldBidiNumericOrderingRoundTrip = bidiNumericOrderingRoundTrip;
        }
        this.roundTrip_ = bidiNumericOrderingRoundTrip;
    }

    public boolean isBidiNumericOrderingRoundTrip() {
        if (Trace.traceConversion_) {
            this.traceLog(1, "Checking if bidi numeric ordering round trip:" + this.roundTrip_);
        }
        return this.roundTrip_;
    }

    public void setBidiWindowCompatibility(boolean bidiWindowCompatibility) {
        if (Trace.traceConversion_) {
            this.traceLog(1, "Setting bidi window compatibility:" + bidiWindowCompatibility);
        }
        this.winCompatible_ = bidiWindowCompatibility;
    }

    public boolean isBidiWindowCompatibility() {
        if (Trace.traceConversion_) {
            this.traceLog(1, "Checking if bidi window compatibility:" + this.winCompatible_);
        }
        return this.winCompatible_;
    }

    public void setBidiInsertDirectionalMarks(boolean bidiInsertDirectionalMarks) {
        if (Trace.traceConversion_) {
            this.traceLog(1, "Setting bidi insert directional marks:" + bidiInsertDirectionalMarks);
        }
        this.insertMarkers_ = bidiInsertDirectionalMarks;
    }

    public boolean isBidiInsertDirectionalMarks() {
        if (Trace.traceConversion_) {
            this.traceLog(1, "Checking if bidi insert directional marks:" + this.insertMarkers_);
        }
        return this.insertMarkers_;
    }

    public void setBidiRemoveDirectionalMarks(boolean bidiRemoveDirectionalMarks) {
        if (Trace.traceConversion_) {
            this.traceLog(1, "Setting bidi remove directional marks:" + bidiRemoveDirectionalMarks);
        }
        this.removeMarkers_ = bidiRemoveDirectionalMarks;
    }

    public boolean isBidiRemoveDirectionalMarks() {
        if (Trace.traceConversion_) {
            this.traceLog(1, "Checking if bidi remove directional marks:" + this.removeMarkers_);
        }
        return this.removeMarkers_;
    }

    public void setBidiWordBreak(boolean wordBreak) {
        if (Trace.traceConversion_) {
            this.traceLog(1, "Setting bidi word break:" + wordBreak);
        }
        this.wordBreak_ = wordBreak;
    }

    public boolean isBidiWordBreak() {
        if (Trace.traceConversion_) {
            this.traceLog(1, "Checking if bidi consider white space to always follow base orientation:" + this.wordBreak_);
        }
        return this.wordBreak_;
    }

    public void setBidiNumeralShaping(int numeralShaping) {
        if (Trace.traceConversion_) {
            this.traceLog(1, "Setting numeral shaping:" + numeralShaping);
        }
        if (numeralShaping < 0 || numeralShaping > 4) {
            throw new ExtendedIllegalArgumentException("numeralShaping (" + numeralShaping + ")", 2);
        }
        this.numeralShaping_ = numeralShaping;
    }

    public int getBidiNumeralShaping() {
        if (Trace.traceConversion_) {
            this.traceLog(1, "Checking numeral shaping:" + this.numeralShaping_);
        }
        return this.numeralShaping_;
    }

    public void setBidiDestinationRequired(boolean destinationRequired) {
        if (Trace.traceConversion_) {
            this.traceLog(1, "Setting bidi destination required:" + destinationRequired);
        }
        this.destinationRequired_ = destinationRequired;
    }

    public boolean isBidiDestinationRequired() {
        if (Trace.traceConversion_) {
            this.traceLog(1, "Checking if bidi destination required:" + this.destinationRequired_);
        }
        return this.destinationRequired_;
    }

    public void setBidiCreateSourceToDestinationMapping(boolean srcToDstMapRequired) {
        if (Trace.traceConversion_) {
            this.traceLog(1, "Setting bidi create a source to destination mapping property:" + srcToDstMapRequired);
        }
        this.srcToDstMapRequired_ = srcToDstMapRequired;
    }

    public boolean isBidiCreateSourceToDestinationMapping() {
        if (Trace.traceConversion_) {
            this.traceLog(1, "Checking if create a source to destination mapping property is set:" + this.srcToDstMapRequired_);
        }
        return this.srcToDstMapRequired_;
    }

    public void setBidiCreateDestinationToSourceMapping(boolean dstToSrcMapRequired) {
        if (Trace.traceConversion_) {
            this.traceLog(1, "Setting bidi create a destination to source mapping property:" + dstToSrcMapRequired);
        }
        this.dstToSrcMapRequired_ = dstToSrcMapRequired;
    }

    public boolean isBidiCreateDestinationToSourceMapping() {
        if (Trace.traceConversion_) {
            this.traceLog(1, "Checking if create a destination to source mapping property is set:" + this.dstToSrcMapRequired_);
        }
        return this.dstToSrcMapRequired_;
    }

    public void setBidiCreatePropertyMap(boolean propertyMapRequired) {
        if (Trace.traceConversion_) {
            this.traceLog(1, "Setting bidi create property map property:" + propertyMapRequired);
        }
        this.propertyMapRequired_ = propertyMapRequired;
    }

    public boolean isBidiCreatePropertyMap() {
        if (Trace.traceConversion_) {
            this.traceLog(1, "Checking if bidi create property map property is set:" + this.propertyMapRequired_);
        }
        return this.propertyMapRequired_;
    }

    public int getInputCount() {
        return this.inpCount_;
    }

    public int getOutputCount() {
        return this.outCount_;
    }

    public int[] getSourceToDestinationMap() {
        return this.srcToDstMap_;
    }

    public int[] getDestinationToSourceMap() {
        return this.dstToSrcMap_;
    }

    public byte[] getPropertyMap() {
        return this.propertyMap_;
    }

    public boolean isBidiExpandLamAlef() {
        return this.expandLamAlef;
    }

    public void setBidiExpandLamAlef(boolean expandLamAlef) {
        this.expandLamAlef = expandLamAlef;
    }

    public void traceLog(int category, String message) {
        Trace.log(category, this.toString() + ":" + message);
    }
}

