/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.Trace;
import java.io.Serializable;

public class SocketProperties
implements Serializable {
    static final long serialVersionUID = 6818790247993750518L;
    boolean keepAliveSet_ = false;
    boolean keepAlive_ = false;
    boolean receiveBufferSizeSet_ = false;
    int receiveBufferSize_ = 0;
    boolean sendBufferSizeSet_ = false;
    int sendBufferSize_ = 0;
    boolean soLingerSet_ = false;
    int soLinger_ = 0;
    boolean soTimeoutSet_ = false;
    int soTimeout_ = 0;
    boolean tcpNoDelaySet_ = false;
    boolean tcpNoDelay_ = false;
    boolean loginTimeoutSet_ = false;
    int loginTimeout_ = 0;

    void copyValues(SocketProperties properties) {
        this.keepAliveSet_ = properties.keepAliveSet_;
        this.keepAlive_ = properties.keepAlive_;
        this.receiveBufferSizeSet_ = properties.receiveBufferSizeSet_;
        this.receiveBufferSize_ = properties.receiveBufferSize_;
        this.sendBufferSizeSet_ = properties.sendBufferSizeSet_;
        this.sendBufferSize_ = properties.sendBufferSize_;
        this.soLingerSet_ = properties.soLingerSet_;
        this.soLinger_ = properties.soLinger_;
        this.soTimeoutSet_ = properties.soTimeoutSet_;
        this.soTimeout_ = properties.soTimeout_;
        this.loginTimeoutSet_ = properties.loginTimeoutSet_;
        this.loginTimeout_ = properties.loginTimeout_;
        this.tcpNoDelaySet_ = properties.tcpNoDelaySet_;
        this.tcpNoDelay_ = properties.tcpNoDelay_;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        try {
            SocketProperties props = (SocketProperties)other;
            return this.keepAliveSet_ == props.keepAliveSet_ && this.keepAlive_ == props.keepAlive_ && this.receiveBufferSizeSet_ == props.receiveBufferSizeSet_ && this.receiveBufferSize_ == props.receiveBufferSize_ && this.sendBufferSizeSet_ == props.sendBufferSizeSet_ && this.sendBufferSize_ == props.sendBufferSize_ && this.soLingerSet_ == props.soLingerSet_ && this.soLinger_ == props.soLinger_ && this.soTimeoutSet_ == props.soTimeoutSet_ && this.soTimeout_ == props.soTimeout_ && this.tcpNoDelaySet_ == props.tcpNoDelaySet_ && this.tcpNoDelay_ == props.tcpNoDelay_;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public int hashCode() {
        return 99;
    }

    public int getReceiveBufferSize() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting receive buffer size:", this.receiveBufferSize_);
        }
        return this.receiveBufferSize_;
    }

    public int getSendBufferSize() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting send buffer size:", this.sendBufferSize_);
        }
        return this.sendBufferSize_;
    }

    public int getSoLinger() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting so linger:", this.soLinger_);
        }
        return this.soLinger_;
    }

    public int getLoginTimeout() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting so socket login timeout:", this.loginTimeout_);
        }
        return this.loginTimeout_;
    }

    public int getSoTimeout() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting so timeout:", this.soTimeout_);
        }
        return this.soTimeout_;
    }

    public boolean isKeepAlive() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if keep alive:", this.keepAlive_);
        }
        return this.keepAlive_;
    }

    boolean isAnyOptionSet() {
        boolean result;
        boolean bl = result = this.keepAliveSet_ || this.receiveBufferSizeSet_ || this.sendBufferSizeSet_ || this.soLingerSet_ || this.soTimeoutSet_ || this.tcpNoDelaySet_;
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if any option is set:", result);
        }
        return result;
    }

    public boolean isKeepAliveSet() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if keep alive is set:", this.keepAliveSet_);
        }
        return this.keepAliveSet_;
    }

    public boolean isReceiveBufferSizeSet() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting receive buffer size is set:", this.receiveBufferSizeSet_);
        }
        return this.receiveBufferSizeSet_;
    }

    public boolean isSendBufferSizeSet() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting send buffer size is set:", this.sendBufferSizeSet_);
        }
        return this.sendBufferSizeSet_;
    }

    public boolean isSoLingerSet() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting so linger is set:", this.soLingerSet_);
        }
        return this.soLingerSet_;
    }

    public boolean isLoginTimeoutSet() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting socket login timeout is set:", this.loginTimeoutSet_);
        }
        return this.loginTimeoutSet_;
    }

    public boolean isSoTimeoutSet() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting so timeout is set:", this.soTimeoutSet_);
        }
        return this.soTimeoutSet_;
    }

    public boolean isTcpNoDelay() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if TCP no delay:", this.tcpNoDelay_);
        }
        return this.tcpNoDelay_;
    }

    public boolean isTcpNoDelaySet() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if TCP no delay is set:", this.tcpNoDelaySet_);
        }
        return this.tcpNoDelaySet_;
    }

    public void setKeepAlive(boolean keepAlive) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting keep alive:", keepAlive);
        }
        this.keepAliveSet_ = true;
        this.keepAlive_ = keepAlive;
    }

    public void setLoginTimeout(int loginTimeout) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting socket login timeout:", loginTimeout);
        }
        this.loginTimeoutSet_ = true;
        this.loginTimeout_ = loginTimeout;
    }

    public void setReceiveBufferSize(int receiveBufferSize) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting receive buffer size:", receiveBufferSize);
        }
        this.receiveBufferSizeSet_ = true;
        this.receiveBufferSize_ = receiveBufferSize;
    }

    public void setSendBufferSize(int sendBufferSize) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting send buffer size:", sendBufferSize);
        }
        this.sendBufferSizeSet_ = true;
        this.sendBufferSize_ = sendBufferSize;
    }

    public void setSoLinger(int soLinger) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting so linger:", soLinger);
        }
        this.soLingerSet_ = true;
        this.soLinger_ = soLinger;
    }

    public void setSoTimeout(int soTimeout) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting so timeout:", soTimeout);
        }
        this.soTimeoutSet_ = true;
        this.soTimeout_ = soTimeout;
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting TCP no delay:", tcpNoDelay);
        }
        this.tcpNoDelaySet_ = true;
        this.tcpNoDelay_ = tcpNoDelay;
    }

    public void unsetKeepAlive() {
        if (Trace.traceOn_) {
            Trace.log(1, "Unsetting keep alive.");
        }
        this.keepAliveSet_ = false;
    }

    public void unsetReceiveBufferSize() {
        if (Trace.traceOn_) {
            Trace.log(1, "Unsetting receive buffer size.");
        }
        this.receiveBufferSizeSet_ = false;
    }

    public void unsetSendBufferSize() {
        if (Trace.traceOn_) {
            Trace.log(1, "Unsetting send buffer size.");
        }
        this.sendBufferSizeSet_ = false;
    }

    public void unsetSoLinger() {
        if (Trace.traceOn_) {
            Trace.log(1, "Unsetting so linger.");
        }
        this.soLingerSet_ = false;
    }

    public void unsetSoTimeout() {
        if (Trace.traceOn_) {
            Trace.log(1, "Unsetting so timeout.");
        }
        this.soTimeoutSet_ = false;
    }

    public void unsetTcpNoDelay() {
        if (Trace.traceOn_) {
            Trace.log(1, "Unsetting TCP no delay.");
        }
        this.tcpNoDelaySet_ = false;
    }
}

