/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.micro;

import com.ibm.as400.access.Trace;
import com.ibm.as400.micro.JdbcMeService;
import com.ibm.as400.micro.MicroDataInputStream;
import com.ibm.as400.micro.MicroDataOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;

class ConnectionHandler {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private JdbcMeService service_;
    private MicroDataInputStream in_;
    private MicroDataOutputStream out_;

    public ConnectionHandler(JdbcMeService jdbcme, MicroDataInputStream in, MicroDataOutputStream out) {
        this.service_ = jdbcme;
        this.in_ = in;
        this.out_ = out;
    }

    public void process(Connection connection, int funcId) throws IOException {
        switch (funcId) {
            case 4689: {
                this.close(connection);
                break;
            }
            case 4690: {
                this.createStatement(connection);
                break;
            }
            case 4691: {
                this.createStatement2(connection);
                break;
            }
            case 4692: {
                this.prepareStatement(connection);
                break;
            }
            case 4693: {
                this.setAutoCommit(connection);
                break;
            }
            case 4694: {
                this.setTransactionIsolation(connection);
                break;
            }
            case 4695: {
                this.commit(connection);
                break;
            }
            case 4696: {
                this.rollback(connection);
                break;
            }
            default: {
                if (!Trace.isTraceOn()) break;
                Trace.log(2, "Connection Function ID not recognized - function code: " + funcId);
            }
        }
    }

    public void close(Connection connection) throws IOException {
        block2: {
            try {
                connection.close();
            }
            catch (SQLException e) {
                if (!Trace.isTraceOn()) break block2;
                Trace.log(2, "Exception caught trying to close connection object " + connection, (Throwable)e);
            }
        }
        this.service_.removeConnection(connection);
    }

    public void createStatement(Connection connection) throws IOException {
        try {
            Statement s = connection.createStatement();
            this.service_.addStatement(s);
            int objectId = this.service_.mapObject(s);
            this.out_.writeInt(objectId);
            this.out_.flush();
        }
        catch (SQLException e) {
            this.service_.handleException(e);
        }
    }

    public void createStatement2(Connection connection) throws IOException {
        try {
            int type = this.in_.readInt();
            int concurrency = this.in_.readInt();
            Statement s = connection.createStatement(type, concurrency);
            this.service_.addStatement(s);
            int objectId = this.service_.mapObject(s);
            this.out_.writeInt(objectId);
            this.out_.flush();
        }
        catch (SQLException e) {
            this.service_.handleException(e);
        }
    }

    public void prepareStatement(Connection connection) throws IOException {
        try {
            String sql = this.in_.readUTF();
            PreparedStatement ps = connection.prepareStatement(sql);
            this.service_.addStatement(ps);
            int objectId = this.service_.mapObject(ps);
            this.out_.writeInt(objectId);
            this.out_.flush();
            ResultSetMetaData rsmd = ps.getMetaData();
            if (rsmd == null) {
                this.out_.writeInt(0);
            } else {
                this.out_.writeInt(1);
                int count = rsmd.getColumnCount();
                this.out_.writeInt(count);
                for (int i = 0; i < count; ++i) {
                    this.out_.writeInt(rsmd.getColumnType(i + 1));
                }
            }
            this.out_.flush();
        }
        catch (SQLException e) {
            this.service_.handleException(e);
        }
    }

    public void prepareStatement2(Connection connection) throws IOException {
        try {
            String sql = this.in_.readUTF();
            PreparedStatement ps = connection.prepareStatement(sql, 1005, 1008);
            this.service_.addStatement(ps);
            int objectId = this.service_.mapObject(ps);
            this.out_.writeInt(objectId);
            this.out_.flush();
            ResultSetMetaData rsmd = ps.getMetaData();
            if (rsmd == null) {
                this.out_.writeInt(0);
            } else {
                this.out_.writeInt(1);
                int count = rsmd.getColumnCount();
                this.out_.writeInt(count);
                for (int i = 0; i < count; ++i) {
                    this.out_.writeInt(rsmd.getColumnType(i + 1));
                }
            }
            this.out_.flush();
        }
        catch (SQLException e) {
            this.service_.handleException(e);
        }
    }

    public void setAutoCommit(Connection connection) throws IOException {
        try {
            boolean b = this.in_.readBoolean();
            connection.setAutoCommit(b);
            this.out_.writeInt(1);
            this.out_.flush();
        }
        catch (SQLException e) {
            this.service_.handleException(e);
        }
    }

    public void setTransactionIsolation(Connection connection) throws IOException {
        try {
            int level = this.in_.readInt();
            connection.setTransactionIsolation(level);
            this.out_.writeInt(1);
            this.out_.flush();
        }
        catch (SQLException e) {
            this.service_.handleException(e);
        }
    }

    public void commit(Connection connection) throws IOException {
        try {
            connection.commit();
            this.out_.writeInt(1);
            this.out_.flush();
        }
        catch (SQLException e) {
            this.service_.handleException(e);
        }
    }

    public void rollback(Connection connection) throws IOException {
        try {
            connection.rollback();
            this.out_.writeInt(1);
            this.out_.flush();
        }
        catch (SQLException e) {
            this.service_.handleException(e);
        }
    }
}

