/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.SystemPool;
import com.ibm.as400.access.Trace;
import com.ibm.as400.vaccess.ChangeEventSupport;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.VObjectEventSupport;
import com.ibm.as400.vaccess.VObjectListener;
import com.ibm.as400.vaccess.VPropertiesPane;
import com.ibm.as400.vaccess.VSystemPool;
import com.ibm.as400.vaccess.VUtilities;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeListener;

class SystemPoolPropertiesPane
implements VPropertiesPane {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final String otherTabText_ = ResourceLoader.getText("TAB_OTHER");
    private static final String generalTabText_ = ResourceLoader.getText("TAB_GENERAL");
    private static final String maximumActiveThreadsText_ = ResourceLoader.getText("SYSTEM_POOL_MAXIMUM_ACTIVE_THREADS") + ":   ";
    private static final String databaseFaultsText_ = ResourceLoader.getText("SYSTEM_POOL_DATABASE_FAULTS") + ": ";
    private static final String databasePagesText_ = ResourceLoader.getText("SYSTEM_POOL_DATABASE_PAGES") + ": ";
    private static final String nondatabaseFaultsText_ = ResourceLoader.getText("SYSTEM_POOL_NONDATABASE_FAULTS") + ": ";
    private static final String nondatabasePagesText_ = ResourceLoader.getText("SYSTEM_POOL_NONDATABASE_PAGES") + ": ";
    private static final String activeToWaitText_ = ResourceLoader.getText("SYSTEM_POOL_ACTIVE_TO_WAIT") + ": ";
    private static final String waitToIneligibleText_ = ResourceLoader.getText("SYSTEM_POOL_WAIT_TO_INELIGIBLE") + ": ";
    private static final String activeToIneligibleText_ = ResourceLoader.getText("SYSTEM_POOL_ACTIVE_TO_INELIGIBLE") + ": ";
    private static final String poolNameText_ = ResourceLoader.getText("SYSTEM_POOL_POOL_NAME") + ":   ";
    private static final String subsystemNameText_ = ResourceLoader.getText("SYSTEM_POOL_SUBSYSTEM_NAME") + ":   ";
    private static final String subsystemLibraryNameText_ = ResourceLoader.getText("SYSTEM_POOL_SUBSYSTEM__LIBRARY_NAME") + ": ";
    private static final String pagingOptionText_ = ResourceLoader.getText("SYSTEM_POOL_PAGING_OPTION") + ":   ";
    private String[] names_;
    private Object[] values_;
    private VSystemPool object_;
    private SystemPool systemPool_;
    private ChangeEventSupport changeEventSupport_ = new ChangeEventSupport(this);
    private ErrorEventSupport errorEventSupport_ = new ErrorEventSupport(this);
    private VObjectEventSupport objectEventSupport_ = new VObjectEventSupport(this);
    private WorkingEventSupport workingEventSupport_ = new WorkingEventSupport(this);

    public SystemPoolPropertiesPane(VSystemPool object, SystemPool systemPool) {
        this.object_ = object;
        this.systemPool_ = systemPool;
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.changeEventSupport_.addChangeListener(listener);
    }

    @Override
    public void addErrorListener(ErrorListener listener) {
        this.errorEventSupport_.addErrorListener(listener);
    }

    @Override
    public void addVObjectListener(VObjectListener listener) {
        this.objectEventSupport_.addVObjectListener(listener);
    }

    @Override
    public void addWorkingListener(WorkingListener listener) {
        this.workingEventSupport_.addWorkingListener(listener);
    }

    @Override
    public void applyChanges() throws Exception {
    }

    private Component getGeneralTab() {
        JPanel generalTab = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        generalTab.setLayout(layout);
        generalTab.setBorder(new EmptyBorder(10, 10, 10, 10));
        int row = 0;
        try {
            VUtilities.constrain(poolNameText_, this.systemPool_.getPoolName(), generalTab, layout, row++);
            VUtilities.constrain(maximumActiveThreadsText_, Integer.toString(this.systemPool_.getMaximumActiveThreads()), generalTab, layout, row++);
            VUtilities.constrain(subsystemNameText_, this.systemPool_.getSubsystemName(), generalTab, layout, row++);
            VUtilities.constrain(pagingOptionText_, this.systemPool_.getPagingOption(), generalTab, layout, row++);
        }
        catch (Exception e) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Unable to properly create general tab for system pool properties pane.", (Throwable)e);
            }
            this.errorEventSupport_.fireError(e);
        }
        return generalTab;
    }

    private Component getOtherTab() {
        JPanel otherTab = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        otherTab.setLayout(layout);
        otherTab.setBorder(new EmptyBorder(10, 10, 10, 10));
        int row = 0;
        try {
            VUtilities.constrain(databaseFaultsText_, Float.toString(this.systemPool_.getDatabaseFaults()), otherTab, layout, row++);
            VUtilities.constrain(databasePagesText_, Float.toString(this.systemPool_.getDatabasePages()), otherTab, layout, row++);
            VUtilities.constrain(nondatabaseFaultsText_, Float.toString(this.systemPool_.getNonDatabaseFaults()), otherTab, layout, row++);
            VUtilities.constrain(nondatabasePagesText_, Float.toString(this.systemPool_.getNonDatabasePages()), otherTab, layout, row++);
            VUtilities.constrain(activeToWaitText_, Float.toString(this.systemPool_.getActiveToWait()), otherTab, layout, row++);
            VUtilities.constrain(waitToIneligibleText_, Float.toString(this.systemPool_.getWaitToIneligible()), otherTab, layout, row++);
            VUtilities.constrain(activeToIneligibleText_, Float.toString(this.systemPool_.getActiveToIneligible()), otherTab, layout, row++);
        }
        catch (Exception e) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Unable to properly create other tab for system pool properties pane.", (Throwable)e);
            }
            this.errorEventSupport_.fireError(e);
        }
        return otherTab;
    }

    @Override
    public Component getComponent() {
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab(generalTabText_, null, this.getGeneralTab());
        tabbedPane.addTab(otherTabText_, null, this.getOtherTab());
        tabbedPane.setSelectedIndex(0);
        return tabbedPane;
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.changeEventSupport_.removeChangeListener(listener);
    }

    @Override
    public void removeErrorListener(ErrorListener listener) {
        this.errorEventSupport_.removeErrorListener(listener);
    }

    @Override
    public void removeVObjectListener(VObjectListener listener) {
        this.objectEventSupport_.removeVObjectListener(listener);
    }

    @Override
    public void removeWorkingListener(WorkingListener listener) {
        this.workingEventSupport_.removeWorkingListener(listener);
    }
}

