/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.workflowexecutor;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.Result;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.HopLogStore;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.logging.LoggingRegistry;
import org.apache.hop.core.parameters.INamedParameterDefinitions;
import org.apache.hop.core.parameters.UnknownParamException;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.workflowexecutor.WorkflowExecutorData;
import org.apache.hop.pipeline.transforms.workflowexecutor.WorkflowExecutorMeta;
import org.apache.hop.pipeline.transforms.workflowexecutor.WorkflowExecutorParameters;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.engine.IWorkflowEngine;
import org.apache.hop.workflow.engine.WorkflowEngineFactory;

public class WorkflowExecutor
extends BaseTransform<WorkflowExecutorMeta, WorkflowExecutorData> {
    private static final Class<?> PKG = WorkflowExecutorMeta.class;

    public WorkflowExecutor(TransformMeta transformMeta, WorkflowExecutorMeta meta, WorkflowExecutorData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        try {
            Object[] row = this.getRow();
            if (row == null) {
                if (!((WorkflowExecutorData)this.data).groupBuffer.isEmpty()) {
                    this.executeWorkflow();
                }
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                this.first = false;
                ((WorkflowExecutorData)this.data).inputRowMeta = this.getInputRowMeta();
                ((WorkflowExecutorData)this.data).executionResultsOutputRowMeta = ((WorkflowExecutorData)this.data).inputRowMeta.clone();
                ((WorkflowExecutorData)this.data).resultRowsOutputRowMeta = ((WorkflowExecutorData)this.data).inputRowMeta.clone();
                ((WorkflowExecutorData)this.data).resultFilesOutputRowMeta = ((WorkflowExecutorData)this.data).inputRowMeta.clone();
                if (((WorkflowExecutorMeta)this.meta).getExecutionResultTargetTransformMeta() != null) {
                    ((WorkflowExecutorMeta)this.meta).getFields(((WorkflowExecutorData)this.data).executionResultsOutputRowMeta, this.getTransformName(), null, ((WorkflowExecutorMeta)this.meta).getExecutionResultTargetTransformMeta(), (IVariables)this, this.metadataProvider);
                    ((WorkflowExecutorData)this.data).executionResultRowSet = this.findOutputRowSet(((WorkflowExecutorMeta)this.meta).getExecutionResultTargetTransformMeta().getName());
                }
                if (((WorkflowExecutorMeta)this.meta).getResultRowsTargetTransformMeta() != null) {
                    ((WorkflowExecutorMeta)this.meta).getFields(((WorkflowExecutorData)this.data).resultRowsOutputRowMeta, this.getTransformName(), null, ((WorkflowExecutorMeta)this.meta).getResultRowsTargetTransformMeta(), (IVariables)this, this.metadataProvider);
                    ((WorkflowExecutorData)this.data).resultRowsRowSet = this.findOutputRowSet(((WorkflowExecutorMeta)this.meta).getResultRowsTargetTransformMeta().getName());
                }
                if (((WorkflowExecutorMeta)this.meta).getResultFilesTargetTransformMeta() != null) {
                    ((WorkflowExecutorMeta)this.meta).getFields(((WorkflowExecutorData)this.data).resultFilesOutputRowMeta, this.getTransformName(), null, ((WorkflowExecutorMeta)this.meta).getResultFilesTargetTransformMeta(), (IVariables)this, this.metadataProvider);
                    ((WorkflowExecutorData)this.data).resultFilesRowSet = this.findOutputRowSet(((WorkflowExecutorMeta)this.meta).getResultFilesTargetTransformMeta().getName());
                }
                ((WorkflowExecutorData)this.data).groupFieldIndex = -1;
                if (!Utils.isEmpty((CharSequence)((WorkflowExecutorData)this.data).groupField)) {
                    ((WorkflowExecutorData)this.data).groupFieldIndex = this.getInputRowMeta().indexOfValue(((WorkflowExecutorData)this.data).groupField);
                    if (((WorkflowExecutorData)this.data).groupFieldIndex < 0) {
                        throw new HopException(BaseMessages.getString(PKG, (String)"WorkflowExecutor.Exception.GroupFieldNotFound", (String[])new String[]{((WorkflowExecutorData)this.data).groupField}));
                    }
                    ((WorkflowExecutorData)this.data).groupFieldMeta = this.getInputRowMeta().getValueMeta(((WorkflowExecutorData)this.data).groupFieldIndex);
                }
                if (((WorkflowExecutorData)this.data).groupSize < 0 && ((WorkflowExecutorData)this.data).groupFieldIndex < 0 && ((WorkflowExecutorData)this.data).groupTime <= 0) {
                    ((WorkflowExecutorData)this.data).groupSize = 1;
                }
            }
            if (((WorkflowExecutorData)this.data).groupSize < 0) {
                long now;
                if (((WorkflowExecutorData)this.data).groupFieldIndex >= 0) {
                    Object groupFieldData = row[((WorkflowExecutorData)this.data).groupFieldIndex];
                    if (((WorkflowExecutorData)this.data).prevGroupFieldData != null && ((WorkflowExecutorData)this.data).groupFieldMeta.compare(((WorkflowExecutorData)this.data).prevGroupFieldData, groupFieldData) != 0) {
                        this.executeWorkflow();
                    }
                    ((WorkflowExecutorData)this.data).prevGroupFieldData = groupFieldData;
                } else if (((WorkflowExecutorData)this.data).groupTime > 0 && (now = System.currentTimeMillis()) - ((WorkflowExecutorData)this.data).groupTimeStart >= (long)((WorkflowExecutorData)this.data).groupTime) {
                    this.executeWorkflow();
                }
            }
            ((WorkflowExecutorData)this.data).groupBuffer.add(new RowMetaAndData(this.getInputRowMeta(), row));
            if (((WorkflowExecutorData)this.data).groupSize > 0 && ((WorkflowExecutorData)this.data).groupBuffer.size() >= ((WorkflowExecutorData)this.data).groupSize) {
                this.executeWorkflow();
            }
            return true;
        }
        catch (Exception e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"WorkflowExecutor.UnexpectedError", (String[])new String[0]), (Throwable)e);
        }
    }

    private void executeWorkflow() throws HopException {
        Object[] targetRow;
        int idx;
        if (((WorkflowExecutorData)this.data).groupBuffer.isEmpty()) {
            return;
        }
        ((WorkflowExecutorData)this.data).groupTimeStart = System.currentTimeMillis();
        if (this.first) {
            this.discardLogLines((WorkflowExecutorData)this.data);
        }
        ((WorkflowExecutorData)this.data).executorWorkflow = this.createWorkflow(((WorkflowExecutorData)this.data).executorWorkflowMeta, (ILoggingObject)this);
        ((WorkflowExecutorData)this.data).executorWorkflow.initializeFrom((IVariables)this);
        ((WorkflowExecutorData)this.data).executorWorkflow.setParentPipeline(this.getPipeline());
        ((WorkflowExecutorData)this.data).executorWorkflow.setLogLevel(this.getLogLevel());
        ((WorkflowExecutorData)this.data).executorWorkflow.setInternalHopVariables();
        ((WorkflowExecutorData)this.data).executorWorkflow.copyParametersFromDefinitions((INamedParameterDefinitions)((WorkflowExecutorData)this.data).executorWorkflowMeta);
        ((WorkflowExecutorData)this.data).executorWorkflow.setSourceRows(((WorkflowExecutorData)this.data).groupBuffer);
        this.passParametersToWorkflow();
        this.getPipeline().addActiveSubWorkflow(this.getTransformName(), ((WorkflowExecutorData)this.data).executorWorkflow);
        Result result = ((WorkflowExecutorData)this.data).executorWorkflow.startExecution();
        if (((WorkflowExecutorMeta)this.meta).getExecutionResultTargetTransformMeta() != null) {
            Object[] outputRow = RowDataUtil.allocateRowData((int)((WorkflowExecutorData)this.data).executionResultsOutputRowMeta.size());
            int idx2 = 0;
            if (!Utils.isEmpty((CharSequence)((WorkflowExecutorMeta)this.meta).getExecutionTimeField())) {
                outputRow[idx2++] = System.currentTimeMillis() - ((WorkflowExecutorData)this.data).groupTimeStart;
            }
            if (!Utils.isEmpty((CharSequence)((WorkflowExecutorMeta)this.meta).getExecutionResultField())) {
                outputRow[idx2++] = result.getResult();
            }
            if (!Utils.isEmpty((CharSequence)((WorkflowExecutorMeta)this.meta).getExecutionNrErrorsField())) {
                outputRow[idx2++] = result.getNrErrors();
            }
            if (!Utils.isEmpty((CharSequence)((WorkflowExecutorMeta)this.meta).getExecutionLinesReadField())) {
                outputRow[idx2++] = result.getNrLinesRead();
            }
            if (!Utils.isEmpty((CharSequence)((WorkflowExecutorMeta)this.meta).getExecutionLinesWrittenField())) {
                outputRow[idx2++] = result.getNrLinesWritten();
            }
            if (!Utils.isEmpty((CharSequence)((WorkflowExecutorMeta)this.meta).getExecutionLinesInputField())) {
                outputRow[idx2++] = result.getNrLinesInput();
            }
            if (!Utils.isEmpty((CharSequence)((WorkflowExecutorMeta)this.meta).getExecutionLinesOutputField())) {
                outputRow[idx2++] = result.getNrLinesOutput();
            }
            if (!Utils.isEmpty((CharSequence)((WorkflowExecutorMeta)this.meta).getExecutionLinesRejectedField())) {
                outputRow[idx2++] = result.getNrLinesRejected();
            }
            if (!Utils.isEmpty((CharSequence)((WorkflowExecutorMeta)this.meta).getExecutionLinesUpdatedField())) {
                outputRow[idx2++] = result.getNrLinesUpdated();
            }
            if (!Utils.isEmpty((CharSequence)((WorkflowExecutorMeta)this.meta).getExecutionLinesDeletedField())) {
                outputRow[idx2++] = result.getNrLinesDeleted();
            }
            if (!Utils.isEmpty((CharSequence)((WorkflowExecutorMeta)this.meta).getExecutionFilesRetrievedField())) {
                outputRow[idx2++] = result.getNrFilesRetrieved();
            }
            if (!Utils.isEmpty((CharSequence)((WorkflowExecutorMeta)this.meta).getExecutionExitStatusField())) {
                outputRow[idx2++] = (long)result.getExitStatus();
            }
            if (!Utils.isEmpty((CharSequence)((WorkflowExecutorMeta)this.meta).getExecutionLogTextField())) {
                String channelId = ((WorkflowExecutorData)this.data).executorWorkflow.getLogChannelId();
                String logText = HopLogStore.getAppender().getBuffer(channelId, false).toString();
                outputRow[idx2++] = logText;
            }
            if (!Utils.isEmpty((CharSequence)((WorkflowExecutorMeta)this.meta).getExecutionLogChannelIdField())) {
                outputRow[idx2++] = ((WorkflowExecutorData)this.data).executorWorkflow.getLogChannelId();
            }
            this.putRowTo(((WorkflowExecutorData)this.data).executionResultsOutputRowMeta, outputRow, ((WorkflowExecutorData)this.data).executionResultRowSet);
        }
        boolean rowConsistencyChecked = false;
        Object missingFields = "";
        Object expectedTypes = "";
        Object currentTypes = "";
        if (((WorkflowExecutorMeta)this.meta).getResultRowsTargetTransformMeta() != null && result.getRows() != null) {
            for (RowMetaAndData row : result.getRows()) {
                if (!rowConsistencyChecked) {
                    for (int i = 0; i < ((WorkflowExecutorMeta)this.meta).getResultRowsField().size(); ++i) {
                        IValueMeta valueMeta;
                        idx = row.getRowMeta().indexOfValue(((WorkflowExecutorMeta)this.meta).getResultRowsField().get(i).getName());
                        if (idx == -1) {
                            missingFields = (String)missingFields + (((String)missingFields).length() > 0 ? "," : "") + ((WorkflowExecutorMeta)this.meta).getResultRowsField().get(i).getName();
                        }
                        if ((valueMeta = row.getRowMeta().getValueMeta(i)) == null || valueMeta.getType() == ValueMetaFactory.getIdForValueMeta((String)((WorkflowExecutorMeta)this.meta).getResultRowsField().get(i).getType())) continue;
                        expectedTypes = (String)expectedTypes + (((String)expectedTypes).length() > 0 ? "," : "") + ((WorkflowExecutorMeta)this.meta).getResultRowsField().get(i).getType();
                        currentTypes = (String)currentTypes + (((String)currentTypes).length() > 0 ? "," : "") + valueMeta.getTypeDesc();
                    }
                    rowConsistencyChecked = true;
                    if (((String)missingFields).length() > 0) {
                        this.logError("Unable to find required fields [" + (String)missingFields + "] in result row!");
                    }
                    if (((String)currentTypes).length() > 0) {
                        this.logError(BaseMessages.getString(PKG, (String)"WorkflowExecutor.IncorrectDataTypePassed", (String[])new String[]{currentTypes, expectedTypes}));
                        throw new HopException("We got into troubles while performing a consistency check on incoming result rows!");
                    }
                }
                targetRow = RowDataUtil.allocateRowData((int)((WorkflowExecutorData)this.data).resultRowsOutputRowMeta.size());
                for (int i = 0; i < ((WorkflowExecutorMeta)this.meta).getResultRowsField().size(); ++i) {
                    targetRow[i] = row.getData()[i];
                }
                this.putRowTo(((WorkflowExecutorData)this.data).resultRowsOutputRowMeta, targetRow, ((WorkflowExecutorData)this.data).resultRowsRowSet);
            }
        }
        if (((WorkflowExecutorMeta)this.meta).getResultFilesTargetTransformMeta() != null && result.getResultFilesList() != null) {
            for (ResultFile resultFile : result.getResultFilesList()) {
                targetRow = RowDataUtil.allocateRowData((int)((WorkflowExecutorData)this.data).resultFilesOutputRowMeta.size());
                idx = 0;
                targetRow[idx++] = resultFile.getFile().getName().toString();
                this.putRowTo(((WorkflowExecutorData)this.data).resultFilesOutputRowMeta, targetRow, ((WorkflowExecutorData)this.data).resultFilesRowSet);
            }
        }
        ((WorkflowExecutorData)this.data).groupBuffer.clear();
    }

    @VisibleForTesting
    IWorkflowEngine<WorkflowMeta> createWorkflow(WorkflowMeta workflowMeta, ILoggingObject parentLogging) throws HopException {
        return WorkflowEngineFactory.createWorkflowEngine((IVariables)this, (String)this.resolve(((WorkflowExecutorMeta)this.meta).getRunConfigurationName()), (IHopMetadataProvider)this.metadataProvider, (WorkflowMeta)workflowMeta, (ILoggingObject)parentLogging);
    }

    @VisibleForTesting
    void discardLogLines(WorkflowExecutorData data) {
        if (data.executorWorkflow != null) {
            HopLogStore.discardLines((String)data.executorWorkflow.getLogChannelId(), (boolean)false);
            LoggingRegistry.getInstance().removeIncludingChildren(data.executorWorkflow.getLogChannelId());
        }
    }

    private void passParametersToWorkflow() throws HopException {
        List<WorkflowExecutorParameters> parameters = ((WorkflowExecutorMeta)this.meta).getParameters();
        for (int i = 0; i < parameters.size(); ++i) {
            String variableName = parameters.get(i).getVariable();
            String variableInput = parameters.get(i).getInput();
            String fieldName = parameters.get(i).getField();
            String variableValue = null;
            if (!StringUtils.isNotEmpty((String)variableName)) continue;
            if (StringUtils.isNotEmpty((String)fieldName)) {
                int idx = this.getInputRowMeta().indexOfValue(this.resolve(fieldName));
                if (idx < 0) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"WorkflowExecutor.Exception.UnableToFindField", (String[])new String[]{this.resolve(fieldName)}));
                }
                variableValue = ((WorkflowExecutorData)this.data).groupBuffer.get(0).getString(idx, "");
            } else if (StringUtils.isNotEmpty((String)variableInput)) {
                variableValue = this.resolve(variableInput);
            }
            try {
                ((WorkflowExecutorData)this.data).executorWorkflow.setParameterValue(variableName, Const.NVL((String)variableValue, (String)""));
                continue;
            }
            catch (UnknownParamException e) {
                ((WorkflowExecutorData)this.data).executorWorkflow.setVariable(variableName, Const.NVL((String)variableValue, (String)""));
            }
        }
        ((WorkflowExecutorData)this.data).executorWorkflow.activateParameters(((WorkflowExecutorData)this.data).executorWorkflow);
    }

    public boolean init() {
        if (super.init()) {
            try {
                ((WorkflowExecutorData)this.data).executorWorkflowMeta = WorkflowExecutorMeta.loadWorkflowMeta((WorkflowExecutorMeta)this.meta, this.metadataProvider, (IVariables)this);
                if (((WorkflowExecutorData)this.data).executorWorkflowMeta != null) {
                    ((WorkflowExecutorData)this.data).groupBuffer = new ArrayList<RowMetaAndData>();
                    ((WorkflowExecutorData)this.data).groupSize = -1;
                    if (!Utils.isEmpty((CharSequence)((WorkflowExecutorMeta)this.meta).getGroupSize())) {
                        ((WorkflowExecutorData)this.data).groupSize = Const.toInt((String)this.resolve(((WorkflowExecutorMeta)this.meta).getGroupSize()), (int)-1);
                    }
                    ((WorkflowExecutorData)this.data).groupTime = -1;
                    if (!Utils.isEmpty((CharSequence)((WorkflowExecutorMeta)this.meta).getGroupTime())) {
                        ((WorkflowExecutorData)this.data).groupTime = Const.toInt((String)this.resolve(((WorkflowExecutorMeta)this.meta).getGroupTime()), (int)-1);
                    }
                    ((WorkflowExecutorData)this.data).groupTimeStart = System.currentTimeMillis();
                    ((WorkflowExecutorData)this.data).groupField = null;
                    if (!Utils.isEmpty((CharSequence)((WorkflowExecutorMeta)this.meta).getGroupField())) {
                        ((WorkflowExecutorData)this.data).groupField = this.resolve(((WorkflowExecutorMeta)this.meta).getGroupField());
                    }
                    return true;
                }
                this.logError("No valid workflow was specified nor loaded!");
                return false;
            }
            catch (Exception e) {
                this.logError("Unable to load the executor workflow because of an error : ", e);
            }
        }
        return false;
    }

    public void dispose() {
        ((WorkflowExecutorData)this.data).groupBuffer = null;
        super.dispose();
    }

    public void stopRunning() throws HopException {
        if (((WorkflowExecutorData)this.data).executorWorkflow != null) {
            ((WorkflowExecutorData)this.data).executorWorkflow.stopExecution();
        }
    }

    public void stopAll() {
        if (((WorkflowExecutorData)this.data).executorWorkflow != null) {
            ((WorkflowExecutorData)this.data).executorWorkflow.stopExecution();
        }
        super.stopAll();
    }
}

