/*
 * Decompiled with CFR 0.152.
 */
package com.sforce.ws.wsdl;

import com.sforce.ws.parser.XmlInputStream;
import com.sforce.ws.wsdl.Definitions;
import com.sforce.ws.wsdl.WsdlParseException;
import com.sforce.ws.wsdl.WsdlParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class WsdlFactory {
    public static Definitions create(URL url) throws WsdlParseException, IOException {
        InputStream in = url.openStream();
        try {
            Definitions definitions = WsdlFactory.createFromInputStream(in);
            return definitions;
        }
        finally {
            WsdlFactory.closeQuietly(in);
        }
    }

    public static Definitions createFromString(String wsdl) throws WsdlParseException {
        ByteArrayInputStream in = new ByteArrayInputStream(wsdl.getBytes());
        try {
            Definitions definitions = WsdlFactory.createFromInputStream(in);
            return definitions;
        }
        finally {
            WsdlFactory.closeQuietly(in);
        }
    }

    private static Definitions createFromInputStream(InputStream in) throws WsdlParseException {
        XmlInputStream parser = new XmlInputStream();
        WsdlParser wsdlParser = new WsdlParser(parser);
        Definitions definitions = new Definitions();
        wsdlParser.setInput(in, "UTF-8");
        definitions.read(wsdlParser);
        return definitions;
    }

    private static void closeQuietly(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

