/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.parser.jstack;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gridkit.jvmtool.codec.stacktrace.ThreadSnapshotEvent;
import org.gridkit.jvmtool.codec.stacktrace.ThreadSnapshotEventPojo;
import org.gridkit.jvmtool.stacktrace.StackFrame;
import org.gridkit.jvmtool.stacktrace.StackFrameArray;
import org.gridkit.jvmtool.stacktrace.StackFrameList;

public class JStackDumpParser {
    private TimeZone timeZone;
    private boolean valid;
    private long dumpTimestamp;
    private String jvmVersion;
    private List<ThreadSnapshotEvent> traces = new ArrayList<ThreadSnapshotEvent>();
    private List<String> unparsed = new ArrayList<String>();
    private IOException ioerror;
    private Matcher threadLine = Pattern.compile("\\\"(.*)\\\"\\s+(daemon)?.+tid=0x([0-9a-fA-F]+)\\s+nid=0x([0-9a-fA-F]+)\\s+([^\\[]*)(?:\\[0x([a-fA-F0-9]*)\\])?").matcher("");
    private Matcher threadState = Pattern.compile("\\s+ java\\.lang\\.Thread\\.State:\\s+([A-Z_]+)(?:\\s+\\((.*)\\))?").matcher("");

    public JStackDumpParser(Reader source) {
        this(TimeZone.getDefault(), source);
    }

    public JStackDumpParser(TimeZone tz, Reader source) {
        BufferedReader br = this.reader(source);
        this.timeZone = tz;
        this.loadHeader(br);
        if (this.valid) {
            this.parseThreads(br);
        }
    }

    private BufferedReader reader(Reader source) {
        return source instanceof BufferedReader ? (BufferedReader)source : new BufferedReader(source);
    }

    private void loadHeader(BufferedReader br) {
        try {
            String line1 = br.readLine();
            String line2 = br.readLine();
            if (line1 != null && line2 != null && line2.startsWith("Full thread dump ")) {
                this.jvmVersion = line2.substring("Full thread dump ".length());
                SimpleDateFormat sdm = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                sdm.setTimeZone(this.timeZone);
                Date date = sdm.parse(line1);
                this.dumpTimestamp = date.getTime();
                this.valid = true;
            }
        }
        catch (IOException e) {
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    private void parseThreads(BufferedReader br) {
        try {
            String line;
            while ((line = br.readLine()) != null) {
                if (line.trim().length() == 0) continue;
                this.threadLine.reset(line);
                if (this.threadLine.matches()) {
                    this.readThread(br);
                    continue;
                }
                this.unparsed.add(line);
            }
        }
        catch (IOException e) {
            this.ioerror = e;
            return;
        }
    }

    private void readThread(BufferedReader reader) throws IOException {
        String threadName = this.threadLine.group(1);
        boolean daemon = this.threadLine.group(2) != null;
        long tid = Long.parseLong(this.threadLine.group(3), 16);
        long nid = Long.parseLong(this.threadLine.group(4), 16);
        String threadMode = this.threadLine.group(5).trim();
        String semaphore = this.threadLine.group(6);
        ThreadSnapshotEventPojo pojo = new ThreadSnapshotEventPojo();
        pojo.timestamp(this.dumpTimestamp);
        pojo.threadName(threadName);
        pojo.threadId(tid);
        pojo.tags().put("jstack.threadState", threadMode);
        if (semaphore != null) {
            pojo.tags().put("jstack.threadSemaphore", semaphore);
        }
        pojo.counters().set("jstack.nid", nid);
        if (daemon) {
            pojo.tags().put("jstack.threadIsDaemon", "true");
        }
        this.traces.add((ThreadSnapshotEvent)pojo);
        ArrayList<StackFrame> frames = new ArrayList<StackFrame>();
        String line = reader.readLine();
        if (line == null) {
            return;
        }
        this.threadState.reset(line);
        if (this.threadState.matches()) {
            String jstate = this.threadState.group(1);
            String jstateExtra = this.threadState.group(2);
            pojo.threadState(Thread.State.valueOf(jstate));
            if (jstateExtra != null) {
                pojo.tags().put("jstack.threadStateExtra", jstateExtra);
            }
            line = reader.readLine();
        }
        while (true) {
            if (line == null || line.trim().length() == 0) {
                StackFrameArray sfa = new StackFrameArray(frames);
                pojo.stackTrace((StackFrameList)sfa);
                return;
            }
            if ((line = line.trim()).startsWith("at ")) {
                String fr = line.substring(3);
                frames.add(StackFrame.parseFrame((String)fr));
            } else if (!line.startsWith("-")) {
                this.unparsed.add(line);
            }
            line = reader.readLine();
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    public long getTimestamp() {
        return this.dumpTimestamp;
    }

    public String getJvmDetails() {
        return this.jvmVersion;
    }

    public List<ThreadSnapshotEvent> getThreads() {
        return this.traces;
    }

    public List<String> getUnparsedContent() {
        return this.unparsed;
    }

    public IOException getParseException() {
        return this.ioerror;
    }
}

