/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.variables.resolver;

import com.google.cloud.secretmanager.v1.AccessSecretVersionResponse;
import com.google.cloud.secretmanager.v1.SecretManagerServiceClient;
import com.google.cloud.secretmanager.v1.SecretManagerServiceSettings;
import com.google.cloud.secretmanager.v1.SecretVersionName;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.gui.plugin.GuiElementType;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.GuiWidgetElement;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.resolver.IVariableResolver;
import org.apache.hop.core.variables.resolver.VariableResolverPlugin;
import org.apache.hop.metadata.api.HopMetadataProperty;

@GuiPlugin
@VariableResolverPlugin(id="Variable-Resolver-GoogleSecretManager", name="Google Secret Manager Variable Resolver", description="Automatically look up values of secrets in Google Secret Manager", documentationUrl="/variables/resolvers/google-secret-manager.html")
public class GooleSecretManagerVariableResolver
implements IVariableResolver {
    @GuiWidgetElement(id="projectId", order="0!", label="i18n:org.apache.hop.core.variables.resolver:GooleSecretManagerVariableResolver.label.ProjectId", type=GuiElementType.TEXT, parentId="VariableResolver-PluginSpecific-Options")
    @HopMetadataProperty
    private String projectId;
    @GuiWidgetElement(id="locationId", order="02", label="i18n:org.apache.hop.core.variables.resolver:GooleSecretManagerVariableResolver.label.LocationId", type=GuiElementType.TEXT, parentId="VariableResolver-PluginSpecific-Options")
    @HopMetadataProperty
    private String locationId;

    public void init() {
    }

    public String resolve(String secretId, IVariables variables) throws HopException {
        String string;
        block10: {
            if (StringUtils.isEmpty((String)secretId)) {
                return null;
            }
            SecretManagerServiceSettings.Builder settingsBuilder = SecretManagerServiceSettings.newBuilder();
            if (StringUtils.isNotEmpty((String)this.locationId)) {
                String apiEndpoint = String.format("secretmanager.%s.rep.googleapis.com:443", this.locationId);
                settingsBuilder.setEndpoint(apiEndpoint);
            }
            SecretManagerServiceSettings settings = settingsBuilder.build();
            SecretManagerServiceClient client = SecretManagerServiceClient.create((SecretManagerServiceSettings)settings);
            try {
                String actualLocationId = variables.resolve(this.locationId);
                String actualProjectId = variables.resolve(this.projectId);
                SecretVersionName secretName = StringUtils.isEmpty((String)actualLocationId) ? SecretVersionName.ofProjectSecretSecretVersionName((String)actualProjectId, (String)secretId, (String)"latest") : SecretVersionName.ofProjectLocationSecretSecretVersionName((String)actualProjectId, (String)actualLocationId, (String)secretId, (String)"latest");
                AccessSecretVersionResponse response = client.accessSecretVersion(secretName);
                string = response.getPayload().getData().toStringUtf8();
                if (client == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LogChannel.GENERAL.logError("Error looking up secret key '" + secretId + "' in Google Secret Manager", (Throwable)e);
                    return null;
                }
            }
            client.close();
        }
        return string;
    }

    public void setPluginId() {
    }

    public String getPluginId() {
        return "Variable-Resolver-GoogleSecretManager";
    }

    public void setPluginName(String pluginName) {
    }

    public String getPluginName() {
        return "Google Secret Manager Variable Resolver";
    }

    @Generated
    public String getProjectId() {
        return this.projectId;
    }

    @Generated
    public String getLocationId() {
        return this.locationId;
    }

    @Generated
    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    @Generated
    public void setLocationId(String locationId) {
        this.locationId = locationId;
    }
}

