/*
 * Decompiled with CFR 0.152.
 */
package io.github.spannm.jackcess;

import io.github.spannm.jackcess.Column;
import io.github.spannm.jackcess.Cursor;
import io.github.spannm.jackcess.Index;
import io.github.spannm.jackcess.IndexCursor;
import io.github.spannm.jackcess.Row;
import io.github.spannm.jackcess.Table;
import io.github.spannm.jackcess.impl.CursorImpl;
import io.github.spannm.jackcess.impl.IndexCursorImpl;
import io.github.spannm.jackcess.impl.IndexData;
import io.github.spannm.jackcess.impl.IndexImpl;
import io.github.spannm.jackcess.impl.TableImpl;
import io.github.spannm.jackcess.util.CaseInsensitiveColumnMatcher;
import io.github.spannm.jackcess.util.ColumnMatcher;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class CursorBuilder {
    private final TableImpl _table;
    private IndexImpl _index;
    private Object[] _startRow;
    private boolean _startRowInclusive = true;
    private Object[] _endRow;
    private boolean _endRowInclusive = true;
    private boolean _beforeFirst = true;
    private Cursor.Savepoint _savepoint;
    private ColumnMatcher _columnMatcher;

    public CursorBuilder(Table table) {
        this._table = (TableImpl)table;
    }

    public CursorBuilder beforeFirst() {
        this._beforeFirst = true;
        return this;
    }

    public CursorBuilder afterLast() {
        this._beforeFirst = false;
        return this;
    }

    public CursorBuilder restoreSavepoint(Cursor.Savepoint savepoint) {
        this._savepoint = savepoint;
        return this;
    }

    public CursorBuilder withIndex(Index index) {
        this._index = (IndexImpl)index;
        return this;
    }

    public CursorBuilder withIndexByName(String indexName) {
        return this.withIndex(this._table.getIndex(indexName));
    }

    public CursorBuilder withIndexByColumnNames(String ... columnNames) {
        return this.withIndexByColumns(Arrays.asList(columnNames));
    }

    public CursorBuilder withIndexByColumns(Column ... columns) {
        ArrayList<String> colNames = new ArrayList<String>();
        for (Column col : columns) {
            colNames.add(col.getName());
        }
        return this.withIndexByColumns(colNames);
    }

    private CursorBuilder withIndexByColumns(List<String> searchColumns) {
        IndexImpl index = this._table.findIndexForColumns(searchColumns, TableImpl.IndexFeature.ANY_MATCH);
        if (index == null) {
            throw new IllegalArgumentException("Index with columns " + searchColumns + " does not exist in table " + this._table);
        }
        this._index = index;
        return this;
    }

    public CursorBuilder withSpecificRow(Object ... specificRow) {
        return this.withStartRow(specificRow).withEndRow(specificRow);
    }

    public CursorBuilder withSpecificEntry(Object ... specificEntry) {
        if (specificEntry != null) {
            this.withSpecificRow(this._index.constructIndexRowFromEntry(specificEntry));
        }
        return this;
    }

    public CursorBuilder withStartRow(Object ... startRow) {
        this._startRow = startRow;
        return this;
    }

    public CursorBuilder withStartEntry(Object ... startEntry) {
        if (startEntry != null) {
            this.withStartRow(this._index.constructPartialIndexRowFromEntry(IndexData.MIN_VALUE, startEntry));
        }
        return this;
    }

    public CursorBuilder withStartRowInclusive(boolean inclusive) {
        this._startRowInclusive = inclusive;
        return this;
    }

    public CursorBuilder withEndRow(Object ... endRow) {
        this._endRow = endRow;
        return this;
    }

    public CursorBuilder withEndEntry(Object ... endEntry) {
        if (endEntry != null) {
            this.withEndRow(this._index.constructPartialIndexRowFromEntry(IndexData.MAX_VALUE, endEntry));
        }
        return this;
    }

    public CursorBuilder withEndRowInclusive(boolean inclusive) {
        this._endRowInclusive = inclusive;
        return this;
    }

    public CursorBuilder withColumnMatcher(ColumnMatcher columnMatcher) {
        this._columnMatcher = columnMatcher;
        return this;
    }

    public CursorBuilder withCaseInsensitive() {
        return this.withColumnMatcher(CaseInsensitiveColumnMatcher.INSTANCE);
    }

    public Cursor toCursor() throws IOException {
        CursorImpl cursor = null;
        cursor = this._index == null ? CursorImpl.createCursor(this._table) : IndexCursorImpl.createCursor(this._table, this._index, this._startRow, this._startRowInclusive, this._endRow, this._endRowInclusive);
        cursor.setColumnMatcher(this._columnMatcher);
        if (this._savepoint == null) {
            if (!this._beforeFirst) {
                cursor.afterLast();
            }
        } else {
            cursor.restoreSavepoint(this._savepoint);
        }
        return cursor;
    }

    public IndexCursor toIndexCursor() throws IOException {
        return (IndexCursorImpl)this.toCursor();
    }

    public static Cursor createCursor(Table table) throws IOException {
        return table.newCursor().toCursor();
    }

    public static IndexCursor createCursor(Index index) throws IOException {
        return index.getTable().newCursor().withIndex(index).toIndexCursor();
    }

    public static IndexCursor createPrimaryKeyCursor(Table table) throws IOException {
        return CursorBuilder.createCursor(table.getPrimaryKeyIndex());
    }

    public static IndexCursor createCursor(Index index, Object[] startRow, Object[] endRow) throws IOException {
        return index.getTable().newCursor().withIndex(index).withStartRow(startRow).withEndRow(endRow).toIndexCursor();
    }

    public static IndexCursor createCursor(Index index, Object[] startRow, boolean startInclusive, Object[] endRow, boolean endInclusive) throws IOException {
        return index.getTable().newCursor().withIndex(index).withStartRow(startRow).withStartRowInclusive(startInclusive).withEndRow(endRow).withEndRowInclusive(endInclusive).toIndexCursor();
    }

    public static Row findRow(Table table, Map<String, ?> rowPattern) throws IOException {
        Cursor cursor = CursorBuilder.createCursor(table);
        if (cursor.findFirstRow(rowPattern)) {
            return cursor.getCurrentRow();
        }
        return null;
    }

    public static Row findRowByEntry(Index index, Object ... entryValues) throws IOException {
        return CursorBuilder.createCursor(index).findRowByEntry(entryValues);
    }

    public static Row findRowByPrimaryKey(Table table, Object ... entryValues) throws IOException {
        return CursorBuilder.findRowByEntry(table.getPrimaryKeyIndex(), entryValues);
    }

    public static Object findValue(Table table, Column column, Column columnPattern, Object valuePattern) throws IOException {
        Cursor cursor = CursorBuilder.createCursor(table);
        if (cursor.findFirstRow(columnPattern, valuePattern)) {
            return cursor.getCurrentRowValue(column);
        }
        return null;
    }

    public static Row findRow(Index index, Map<String, ?> rowPattern) throws IOException {
        IndexCursor cursor = CursorBuilder.createCursor(index);
        if (cursor.findFirstRow(rowPattern)) {
            return cursor.getCurrentRow();
        }
        return null;
    }

    public static Object findValue(Index index, Column column, Column columnPattern, Object valuePattern) throws IOException {
        IndexCursor cursor = CursorBuilder.createCursor(index);
        if (cursor.findFirstRow(columnPattern, valuePattern)) {
            return cursor.getCurrentRowValue(column);
        }
        return null;
    }
}

