/*
 * Decompiled with CFR 0.152.
 */
package org.python.icu.util;

import java.util.Date;
import java.util.Locale;
import java.util.MissingResourceException;
import org.python.icu.util.DateRule;
import org.python.icu.util.ULocale;
import org.python.icu.util.UResourceBundle;

public abstract class Holiday
implements DateRule {
    private String name;
    private DateRule rule;
    private static Holiday[] noHolidays = new Holiday[0];

    public static Holiday[] getHolidays() {
        return Holiday.getHolidays(ULocale.getDefault(ULocale.Category.FORMAT));
    }

    public static Holiday[] getHolidays(Locale locale2) {
        return Holiday.getHolidays(ULocale.forLocale(locale2));
    }

    public static Holiday[] getHolidays(ULocale locale2) {
        Holiday[] result2 = noHolidays;
        try {
            UResourceBundle bundle = UResourceBundle.getBundleInstance("org.python.icu.impl.data.HolidayBundle", locale2);
            result2 = (Holiday[])bundle.getObject("holidays");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return result2;
    }

    @Override
    public Date firstAfter(Date start) {
        return this.rule.firstAfter(start);
    }

    @Override
    public Date firstBetween(Date start, Date end) {
        return this.rule.firstBetween(start, end);
    }

    @Override
    public boolean isOn(Date date) {
        return this.rule.isOn(date);
    }

    @Override
    public boolean isBetween(Date start, Date end) {
        return this.rule.isBetween(start, end);
    }

    protected Holiday(String name, DateRule rule) {
        this.name = name;
        this.rule = rule;
    }

    public String getDisplayName() {
        return this.getDisplayName(ULocale.getDefault(ULocale.Category.DISPLAY));
    }

    public String getDisplayName(Locale locale2) {
        return this.getDisplayName(ULocale.forLocale(locale2));
    }

    public String getDisplayName(ULocale locale2) {
        String dispName = this.name;
        try {
            UResourceBundle bundle = UResourceBundle.getBundleInstance("org.python.icu.impl.data.HolidayBundle", locale2);
            dispName = bundle.getString(this.name);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return dispName;
    }

    public DateRule getRule() {
        return this.rule;
    }

    public void setRule(DateRule rule) {
        this.rule = rule;
    }
}

