/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators.async.queue;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.streaming.api.functions.async.ResultFuture;
import org.apache.flink.streaming.api.operators.TimestampedCollector;
import org.apache.flink.streaming.api.operators.async.queue.StreamElementQueue;
import org.apache.flink.streaming.api.operators.async.queue.StreamElementQueueEntry;
import org.apache.flink.streaming.api.operators.async.queue.StreamRecordQueueEntry;
import org.apache.flink.streaming.api.operators.async.queue.WatermarkQueueEntry;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamElement;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.util.CollectionUtil;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public final class UnorderedStreamElementQueue<OUT>
implements StreamElementQueue<OUT> {
    private static final Logger LOG = LoggerFactory.getLogger(UnorderedStreamElementQueue.class);
    private final int capacity;
    private final Deque<Segment<OUT>> segments;
    private int numberOfEntries;

    public UnorderedStreamElementQueue(int capacity) {
        Preconditions.checkArgument((capacity > 0 ? 1 : 0) != 0, (Object)"The capacity must be larger than 0.");
        this.capacity = capacity;
        this.segments = new ArrayDeque<Segment<OUT>>(4);
        this.numberOfEntries = 0;
    }

    @Override
    public Optional<ResultFuture<OUT>> tryPut(StreamElement streamElement) {
        if (this.size() < this.capacity) {
            StreamElementQueueEntry<OUT> queueEntry;
            if (streamElement.isRecord()) {
                queueEntry = this.addRecord((StreamRecord)streamElement);
            } else if (streamElement.isWatermark()) {
                queueEntry = this.addWatermark((Watermark)streamElement);
            } else {
                throw new UnsupportedOperationException("Cannot enqueue " + streamElement);
            }
            ++this.numberOfEntries;
            LOG.debug("Put element into unordered stream element queue. New filling degree ({}/{}).", (Object)this.size(), (Object)this.capacity);
            return Optional.of(queueEntry);
        }
        LOG.debug("Failed to put element into unordered stream element queue because it was full ({}/{}).", (Object)this.size(), (Object)this.capacity);
        return Optional.empty();
    }

    private StreamElementQueueEntry<OUT> addRecord(StreamRecord<?> record) {
        Segment<OUT> lastSegment = this.segments.isEmpty() ? this.addSegment(this.capacity) : this.segments.getLast();
        SegmentedStreamRecordQueueEntry<OUT> queueEntry = new SegmentedStreamRecordQueueEntry<OUT>(record, lastSegment);
        lastSegment.add(queueEntry);
        return queueEntry;
    }

    private Segment<OUT> addSegment(int capacity) {
        Segment newSegment = new Segment(capacity);
        this.segments.addLast(newSegment);
        return newSegment;
    }

    private StreamElementQueueEntry<OUT> addWatermark(Watermark watermark) {
        Segment watermarkSegment = !this.segments.isEmpty() && this.segments.getLast().isEmpty() ? this.segments.getLast() : this.addSegment(1);
        WatermarkQueueEntry watermarkEntry = new WatermarkQueueEntry(watermark);
        watermarkSegment.add(watermarkEntry);
        this.addSegment(this.capacity);
        return watermarkEntry;
    }

    @Override
    public boolean hasCompletedElements() {
        return !this.segments.isEmpty() && this.segments.getFirst().hasCompleted();
    }

    @Override
    public void emitCompletedElement(TimestampedCollector<OUT> output) {
        if (this.segments.isEmpty()) {
            return;
        }
        Segment<OUT> currentSegment = this.segments.getFirst();
        this.numberOfEntries -= currentSegment.emitCompleted(output);
        if (this.segments.size() > 1 && currentSegment.isEmpty()) {
            this.segments.pop();
        }
    }

    @Override
    public List<StreamElement> values() {
        ArrayList<StreamElement> list = new ArrayList<StreamElement>();
        for (Segment<OUT> s : this.segments) {
            s.addPendingElements(list);
        }
        return list;
    }

    @Override
    public boolean isEmpty() {
        return this.numberOfEntries == 0;
    }

    @Override
    public int size() {
        return this.numberOfEntries;
    }

    static class Segment<OUT> {
        private final Set<StreamElementQueueEntry<OUT>> incompleteElements;
        private final Queue<StreamElementQueueEntry<OUT>> completedElements;

        Segment(int initialCapacity) {
            this.incompleteElements = CollectionUtil.newHashSetWithExpectedSize((int)initialCapacity);
            this.completedElements = new ArrayDeque<StreamElementQueueEntry<OUT>>(initialCapacity);
        }

        void completed(StreamElementQueueEntry<OUT> elementQueueEntry) {
            if (this.incompleteElements.remove(elementQueueEntry)) {
                this.completedElements.add(elementQueueEntry);
            }
        }

        boolean isEmpty() {
            return this.incompleteElements.isEmpty() && this.completedElements.isEmpty();
        }

        boolean hasCompleted() {
            return !this.completedElements.isEmpty();
        }

        void addPendingElements(List<StreamElement> results) {
            for (StreamElementQueueEntry streamElementQueueEntry : this.completedElements) {
                results.add(streamElementQueueEntry.getInputElement());
            }
            for (StreamElementQueueEntry streamElementQueueEntry : this.incompleteElements) {
                results.add(streamElementQueueEntry.getInputElement());
            }
        }

        int emitCompleted(TimestampedCollector<OUT> output) {
            StreamElementQueueEntry<OUT> completedEntry = this.completedElements.poll();
            if (completedEntry == null) {
                return 0;
            }
            completedEntry.emitResult(output);
            return 1;
        }

        void add(StreamElementQueueEntry<OUT> queueEntry) {
            if (queueEntry.isDone()) {
                this.completedElements.add(queueEntry);
            } else {
                this.incompleteElements.add(queueEntry);
            }
        }
    }

    static class SegmentedStreamRecordQueueEntry<OUT>
    extends StreamRecordQueueEntry<OUT> {
        private final Segment<OUT> segment;

        SegmentedStreamRecordQueueEntry(StreamRecord<?> inputRecord, Segment<OUT> segment) {
            super(inputRecord);
            this.segment = segment;
        }

        @Override
        public void complete(Collection<OUT> result) {
            super.complete(result);
            this.segment.completed(this);
        }
    }
}

