/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.avro;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TSFBuilder;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.format.InputAccessor;
import com.fasterxml.jackson.core.format.MatchStrength;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.dataformat.avro.AvroFactoryBuilder;
import com.fasterxml.jackson.dataformat.avro.AvroGenerator;
import com.fasterxml.jackson.dataformat.avro.AvroParser;
import com.fasterxml.jackson.dataformat.avro.AvroSchema;
import com.fasterxml.jackson.dataformat.avro.PackageVersion;
import com.fasterxml.jackson.dataformat.avro.deser.JacksonAvroParserImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;

public class AvroFactory
extends JsonFactory {
    private static final long serialVersionUID = 1L;
    public static final String FORMAT_NAME_AVRO = "avro";
    static final int DEFAULT_AVRO_PARSER_FEATURE_FLAGS = AvroParser.Feature.collectDefaults();
    static final int DEFAULT_AVRO_GENERATOR_FEATURE_FLAGS = AvroGenerator.Feature.collectDefaults();
    protected int _avroParserFeatures;
    protected int _avroGeneratorFeatures;
    protected boolean _useApacheLibDecoder;

    public AvroFactory() {
        super((TSFBuilder)new AvroFactoryBuilder(), false);
        this._avroParserFeatures = DEFAULT_AVRO_PARSER_FEATURE_FLAGS;
        this._avroGeneratorFeatures = DEFAULT_AVRO_GENERATOR_FEATURE_FLAGS;
        this._useApacheLibDecoder = false;
    }

    public AvroFactory(ObjectCodec oc) {
        super(oc);
        this._avroParserFeatures = DEFAULT_AVRO_PARSER_FEATURE_FLAGS;
        this._avroGeneratorFeatures = DEFAULT_AVRO_GENERATOR_FEATURE_FLAGS;
        this._useApacheLibDecoder = false;
        this.disable(JsonGenerator.Feature.AUTO_CLOSE_JSON_CONTENT);
    }

    protected AvroFactory(AvroFactory src, ObjectCodec oc) {
        super((JsonFactory)src, oc);
        this._avroParserFeatures = src._avroParserFeatures;
        this._avroGeneratorFeatures = src._avroGeneratorFeatures;
        this._useApacheLibDecoder = src._useApacheLibDecoder;
    }

    protected AvroFactory(AvroFactoryBuilder b) {
        super((TSFBuilder)b, false);
        this._avroParserFeatures = b.formatParserFeaturesMask();
        this._avroGeneratorFeatures = b.formatGeneratorFeaturesMask();
        this._useApacheLibDecoder = b.useApacheLibDecoder();
    }

    public AvroFactoryBuilder rebuild() {
        return new AvroFactoryBuilder(this);
    }

    public static AvroFactoryBuilder builder() {
        return new AvroFactoryBuilder();
    }

    public static AvroFactoryBuilder builderWithApacheDecoder() {
        return new AvroFactoryBuilder(true);
    }

    public static AvroFactoryBuilder builderWithNativeDecoder() {
        return new AvroFactoryBuilder(false);
    }

    public AvroFactory copy() {
        this._checkInvalidCopy(AvroFactory.class);
        return new AvroFactory(this, null);
    }

    public boolean requiresPropertyOrdering() {
        return true;
    }

    public boolean canHandleBinaryNatively() {
        return true;
    }

    protected Object readResolve() {
        return new AvroFactory(this, this._objectCodec);
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public String getFormatName() {
        return FORMAT_NAME_AVRO;
    }

    public boolean canUseSchema(FormatSchema schema) {
        return schema instanceof AvroSchema;
    }

    public MatchStrength hasFormat(InputAccessor acc) throws IOException {
        return MatchStrength.INCONCLUSIVE;
    }

    public final AvroFactory configure(AvroParser.Feature f, boolean state) {
        if (state) {
            this.enable(f);
        } else {
            this.disable(f);
        }
        return this;
    }

    public AvroFactory enable(AvroParser.Feature f) {
        this._avroParserFeatures |= f.getMask();
        return this;
    }

    public AvroFactory disable(AvroParser.Feature f) {
        this._avroParserFeatures &= ~f.getMask();
        return this;
    }

    public final boolean isEnabled(AvroParser.Feature f) {
        return (this._avroParserFeatures & f.getMask()) != 0;
    }

    public int getFormatParserFeatures() {
        return this._avroParserFeatures;
    }

    public final AvroFactory configure(AvroGenerator.Feature f, boolean state) {
        if (state) {
            this.enable(f);
        } else {
            this.disable(f);
        }
        return this;
    }

    public AvroFactory enable(AvroGenerator.Feature f) {
        this._avroGeneratorFeatures |= f.getMask();
        return this;
    }

    public AvroFactory disable(AvroGenerator.Feature f) {
        this._avroGeneratorFeatures &= ~f.getMask();
        return this;
    }

    public final boolean isEnabled(AvroGenerator.Feature f) {
        return (this._avroGeneratorFeatures & f.getMask()) != 0;
    }

    public int getFormatGeneratorFeatures() {
        return this._avroGeneratorFeatures;
    }

    public AvroParser createParser(File f) throws IOException {
        IOContext ctxt = this._createContext(this._createContentReference(f), true);
        return this._createParser(this._decorate(new FileInputStream(f), ctxt), ctxt);
    }

    public AvroParser createParser(URL url) throws IOException {
        IOContext ctxt = this._createContext(this._createContentReference(url), true);
        return this._createParser(this._decorate(this._optimizedStreamFromURL(url), ctxt), ctxt);
    }

    public AvroParser createParser(InputStream in) throws IOException {
        IOContext ctxt = this._createContext(this._createContentReference(in), false);
        return this._createParser(this._decorate(in, ctxt), ctxt);
    }

    public AvroParser createParser(byte[] data) throws IOException {
        return this.createParser(data, 0, data.length);
    }

    public AvroParser createParser(byte[] data, int offset, int len) throws IOException {
        InputStream in;
        IOContext ctxt = this._createContext(this._createContentReference(data, offset, len), true);
        if (this._inputDecorator != null && (in = this._inputDecorator.decorate(ctxt, data, 0, data.length)) != null) {
            return this._createParser(in, ctxt);
        }
        return this._createParser(data, offset, len, ctxt);
    }

    public AvroGenerator createGenerator(OutputStream out, JsonEncoding enc) throws IOException {
        return this.createGenerator(out);
    }

    public AvroGenerator createGenerator(OutputStream out) throws IOException {
        IOContext ctxt = this._createContext(this._createContentReference(out), false);
        return this._createGenerator(this._decorate(out, ctxt), ctxt);
    }

    protected AvroParser _createParser(InputStream in, IOContext ctxt) throws IOException {
        return new JacksonAvroParserImpl(ctxt, this._parserFeatures, this._avroParserFeatures, this._objectCodec, in);
    }

    protected JsonParser _createParser(Reader r, IOContext ctxt) throws IOException {
        return (JsonParser)this._nonByteSource();
    }

    protected JsonParser _createParser(char[] data, int offset, int len, IOContext ctxt, boolean recyclable) throws IOException {
        return (JsonParser)this._nonByteSource();
    }

    protected AvroParser _createParser(byte[] data, int offset, int len, IOContext ctxt) throws IOException {
        return new JacksonAvroParserImpl(ctxt, this._parserFeatures, this._avroParserFeatures, this._objectCodec, data, offset, len);
    }

    protected JsonGenerator _createGenerator(Writer out, IOContext ctxt) throws IOException {
        return (JsonGenerator)this._nonByteTarget();
    }

    protected Writer _createWriter(OutputStream out, JsonEncoding enc, IOContext ctxt) throws IOException {
        return (Writer)this._nonByteTarget();
    }

    protected AvroGenerator _createGenerator(OutputStream out, IOContext ctxt) throws IOException {
        int feats = this._avroGeneratorFeatures;
        AvroGenerator gen = new AvroGenerator(ctxt, this._generatorFeatures, feats, this._objectCodec, out);
        return gen;
    }

    protected <T> T _nonByteSource() throws IOException {
        throw new UnsupportedOperationException("Can not create parser for character-based (not byte-based) source");
    }

    protected <T> T _nonByteTarget() throws IOException {
        throw new UnsupportedOperationException("Can not create generator for character-based (not byte-based) target");
    }
}

