/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.Supplier;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.WriteType;
import org.apache.cassandra.locator.ReplicaPlan;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.service.AbstractWriteResponseHandler;
import org.apache.cassandra.transport.Dispatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteResponseHandler<T>
extends AbstractWriteResponseHandler<T> {
    protected static final Logger logger = LoggerFactory.getLogger(WriteResponseHandler.class);
    protected volatile int responses = this.blockFor();
    private static final AtomicIntegerFieldUpdater<WriteResponseHandler> responsesUpdater = AtomicIntegerFieldUpdater.newUpdater(WriteResponseHandler.class, "responses");

    public WriteResponseHandler(ReplicaPlan.ForWrite replicaPlan, Runnable callback, WriteType writeType, Supplier<Mutation> hintOnFailure, Dispatcher.RequestTime requestTime) {
        super(replicaPlan, callback, writeType, hintOnFailure, requestTime);
    }

    public WriteResponseHandler(ReplicaPlan.ForWrite replicaPlan, WriteType writeType, Supplier<Mutation> hintOnFailure, Dispatcher.RequestTime requestTime) {
        this(replicaPlan, null, writeType, hintOnFailure, requestTime);
    }

    @Override
    public void onResponse(Message<T> m) {
        if (responsesUpdater.decrementAndGet(this) == 0) {
            this.signal();
        }
        this.logResponseToIdealCLDelegate(m);
    }

    @Override
    protected int ackCount() {
        return this.blockFor() - this.responses;
    }
}

