/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.execution.elastic;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.gui.plugin.GuiElementType;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.GuiWidgetElement;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.execution.IExecutionInfoLocation;
import org.apache.hop.execution.caching.BaseCachingExecutionInfoLocation;
import org.apache.hop.execution.caching.CacheEntry;
import org.apache.hop.execution.caching.DatedId;
import org.apache.hop.execution.plugin.ExecutionInfoLocationPlugin;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.hopgui.HopGui;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

@GuiPlugin(description="Elastic execution information location GUI elements")
@ExecutionInfoLocationPlugin(id="elastic-location", name="Elastic location", description="Aggregates and caches execution information before storing in Elastic")
public class ElasticExecutionInfoLocation
extends BaseCachingExecutionInfoLocation
implements IExecutionInfoLocation {
    public static final Class<?> PKG = ElasticExecutionInfoLocation.class;
    @GuiWidgetElement(id="url", order="010", parentId="ExecutionInfoLocation-PluginSpecific-Options", type=GuiElementType.TEXT, toolTip="i18n:org.apache.hop.execution.elastic:ElasticExecutionInfoLocation.Url.Tooltip", label="i18n:org.apache.hop.execution.elastic:ElasticExecutionInfoLocation.Url.Label")
    @HopMetadataProperty
    protected String url;
    @GuiWidgetElement(id="apiKey", order="020", parentId="ExecutionInfoLocation-PluginSpecific-Options", type=GuiElementType.TEXT, password=true, toolTip="i18n:org.apache.hop.execution.elastic:ElasticExecutionInfoLocation.ApiKey.Tooltip", label="i18n:org.apache.hop.execution.elastic:ElasticExecutionInfoLocation.ApiKey.Label")
    @HopMetadataProperty
    protected String apiKey;
    @GuiWidgetElement(id="indexName", order="030", parentId="ExecutionInfoLocation-PluginSpecific-Options", type=GuiElementType.TEXT, toolTip="i18n:org.apache.hop.execution.elastic:ElasticExecutionInfoLocation.IndexName.Tooltip", label="i18n:org.apache.hop.execution.elastic:ElasticExecutionInfoLocation.IndexName.Label")
    @HopMetadataProperty
    protected String indexName;
    protected String actualUrl;
    protected String actualApiKey;
    protected String actualIndexName;

    public ElasticExecutionInfoLocation() {
    }

    public ElasticExecutionInfoLocation(ElasticExecutionInfoLocation location) {
        super((BaseCachingExecutionInfoLocation)location);
        this.apiKey = location.apiKey;
        this.actualApiKey = location.actualApiKey;
        this.indexName = location.indexName;
        this.actualIndexName = location.actualIndexName;
        this.url = location.url;
        this.actualUrl = location.actualUrl;
    }

    public ElasticExecutionInfoLocation clone() {
        return new ElasticExecutionInfoLocation(this);
    }

    public void initialize(IVariables variables, IHopMetadataProvider metadataProvider) throws HopException {
        this.actualUrl = variables.resolve(this.url);
        this.actualApiKey = variables.resolve(this.apiKey);
        this.actualIndexName = variables.resolve(this.indexName);
        super.initialize(variables, metadataProvider);
    }

    protected void persistCacheEntry(CacheEntry cacheEntry) throws HopException {
        try {
            cacheEntry.calculateSummary();
            HttpClient client = HttpClient.newHttpClient();
            URI uri = URI.create(this.actualUrl);
            URI postUri = StringUtils.isEmpty((String)cacheEntry.getInternalId()) ? uri.resolve(this.actualIndexName + "/_doc") : uri.resolve(this.actualIndexName + "/_doc/" + cacheEntry.getInternalId());
            ObjectMapper mapper = new ObjectMapper();
            String body = mapper.writeValueAsString((Object)cacheEntry);
            HttpRequest request = HttpRequest.newBuilder().uri(postUri).header("Content-Type", "application/json").header("Accept", "application/json").header("Authorization", "ApiKey " + this.actualApiKey).POST(HttpRequest.BodyPublishers.ofByteArray(body.getBytes(StandardCharsets.UTF_8))).build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 201 && response.statusCode() != 200) {
                throw new HopException("Status code " + response.statusCode() + " received from Elastic with response: " + response.body());
            }
            JSONParser parser = new JSONParser();
            JSONObject bodyJs = (JSONObject)parser.parse(response.body());
            String elasticId = (String)bodyJs.get((Object)"_id");
            cacheEntry.setInternalId(elasticId);
            cacheEntry.setLastWritten(new Date());
        }
        catch (Exception e) {
            throw new HopException("Error writing caching file entry to Elastic", (Throwable)e);
        }
    }

    public void deleteCacheEntry(CacheEntry cacheEntry) throws HopException {
        try {
            HttpClient client = HttpClient.newHttpClient();
            URI uri = URI.create(this.actualUrl);
            URI postUri = uri.resolve(this.actualIndexName + "/_search");
            String body = "        {\n          \"query\": {\n            \"query_string\": {\n              \"query\": \"executionId\"\n            }\n          }, \"_source\": false\n        }\n";
            body = body.replace("executionId", cacheEntry.getId());
            HttpRequest request = HttpRequest.newBuilder().uri(postUri).header("Content-Type", "application/json").header("Accept", "application/json").header("Authorization", "ApiKey " + this.actualApiKey).POST(HttpRequest.BodyPublishers.ofString(body)).build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            JSONParser parser = new JSONParser();
            JSONObject j = (JSONObject)parser.parse(response.body());
            JSONObject jHitsTop = (JSONObject)j.get((Object)"hits");
            if (jHitsTop == null) {
                return;
            }
            JSONArray jHits = (JSONArray)jHitsTop.get((Object)"hits");
            if (jHits == null || jHits.isEmpty()) {
                return;
            }
            for (int i = 0; i < jHits.size(); ++i) {
                JSONObject jHit = (JSONObject)jHits.get(i);
                String elasticId = (String)jHit.get((Object)"_id");
                URI deleteUri = uri.resolve(this.actualIndexName + "/_doc/" + elasticId);
                HttpRequest deleteRequest = HttpRequest.newBuilder().uri(deleteUri).header("Content-Type", "application/json").header("Accept", "application/json").header("Authorization", "ApiKey " + this.actualApiKey).DELETE().build();
                HttpResponse<String> deleteResponse = client.send(deleteRequest, HttpResponse.BodyHandlers.ofString());
                if (deleteResponse.statusCode() == 200) continue;
                throw new HopException("Unable to delete Elastic document with _id : '" + elasticId + "', status code : " + deleteResponse.statusCode());
            }
        }
        catch (Exception e) {
            throw new HopException("Error deleting caching file entry from Elastic", (Throwable)e);
        }
    }

    protected synchronized CacheEntry loadCacheEntry(String executionId) throws HopException {
        try {
            HttpClient client = HttpClient.newHttpClient();
            URI uri = URI.create(this.actualUrl);
            URI postUri = uri.resolve(this.actualIndexName + "/_search");
            String body = "    {\n       \"query\": {\n         \"match\": {\n           \"id\": \"executionId\"\n         }\n       }\n     }\n";
            body = body.replace("executionId", executionId);
            HttpRequest request = HttpRequest.newBuilder().uri(postUri).header("Content-Type", "application/json").header("Accept", "application/json").header("Authorization", "ApiKey " + this.actualApiKey).POST(HttpRequest.BodyPublishers.ofString(body)).build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            JSONParser parser = new JSONParser();
            JSONObject j = (JSONObject)parser.parse(response.body());
            JSONObject jHitsTop = (JSONObject)j.get((Object)"hits");
            if (jHitsTop == null) {
                return null;
            }
            JSONArray jHits = (JSONArray)jHitsTop.get((Object)"hits");
            if (jHits == null || jHits.isEmpty()) {
                return null;
            }
            JSONObject jHit = (JSONObject)jHits.get(0);
            JSONObject jSource = (JSONObject)jHit.get((Object)"_source");
            if (jSource == null) {
                return null;
            }
            String json = jSource.toJSONString();
            ObjectMapper objectMapper = new ObjectMapper();
            return (CacheEntry)objectMapper.readValue(json, CacheEntry.class);
        }
        catch (Exception e) {
            throw new HopException("Error loading execution information location from Elastic using executionId '" + executionId + "'", (Throwable)e);
        }
    }

    protected void retrieveIds(boolean includeChildren, Set<DatedId> ids, int limit) throws HopException {
        try {
            HttpClient client = HttpClient.newHttpClient();
            URI uri = URI.create(this.actualUrl);
            URI postUri = uri.resolve(this.actualIndexName + "/_search");
            String body = "  {\n    __LIMIT_CLAUSE__\n    \"from\": 0,\n    \"query\" : { \"match_all\" : {} },\n    \"fields\": [ \"id\", \"execution.executionStartDate\" ],\n    \"sort\" : [ { \"execution.executionStartDate\" : {\"order\" : \"desc\" }} ],\n    \"_source\": false\n  }\n";
            Object limitClause = "";
            if (limit > 0) {
                limitClause = "\"size\": " + limit + ",";
            }
            body = body.replace("__LIMIT_CLAUSE__", (CharSequence)limitClause);
            HttpRequest request = HttpRequest.newBuilder().uri(postUri).header("Content-Type", "application/json").header("Accept", "application/json").header("Authorization", "ApiKey " + this.actualApiKey).POST(HttpRequest.BodyPublishers.ofString(body)).build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                throw new HopException("Status code " + response.statusCode() + " received from Elastic with response: " + response.body());
            }
            JSONParser parser = new JSONParser();
            JSONObject j = (JSONObject)parser.parse(response.body());
            JSONObject jHitsTop = (JSONObject)j.get((Object)"hits");
            if (jHitsTop == null) {
                return;
            }
            JSONArray jHits = (JSONArray)jHitsTop.get((Object)"hits");
            if (jHits == null || jHits.isEmpty()) {
                return;
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            for (Object hit : jHits) {
                JSONObject jHit = (JSONObject)hit;
                JSONObject jHitsFields = (JSONObject)jHit.get((Object)"fields");
                JSONArray jHitsFieldsIds = (JSONArray)jHitsFields.get((Object)"id");
                if (jHitsFieldsIds == null || jHitsFieldsIds.isEmpty()) continue;
                String id = (String)jHitsFieldsIds.get(0);
                JSONArray jHitsFieldsStart = (JSONArray)jHitsFields.get((Object)"execution.executionStartDate");
                if (jHitsFieldsStart == null || jHitsFieldsStart.isEmpty()) continue;
                String startDate = (String)jHitsFieldsStart.get(0);
                ids.add(new DatedId(id, sdf.parse(startDate)));
            }
        }
        catch (Exception e) {
            throw new HopException("Error finding execution ids from Elastic", (Throwable)e);
        }
    }

    @GuiWidgetElement(id="createIndexButton", order="035", parentId="ExecutionInfoLocation-PluginSpecific-Options", type=GuiElementType.BUTTON, label="i18n::ElasticExecutionInfoLocation.CreateIndex.Label", toolTip="i18n::ElasticExecutionInfoLocation.CreateIndex.Tooltip")
    public void createIndexButton(Object object) {
        HopGui hopGui = HopGui.getInstance();
        ElasticExecutionInfoLocation location = (ElasticExecutionInfoLocation)((Object)object);
        try {
            location.initialize(hopGui.getVariables(), (IHopMetadataProvider)hopGui.getMetadataProvider());
            HttpClient client = HttpClient.newHttpClient();
            URI uri = URI.create(location.actualUrl);
            URI createUri = uri.resolve(location.actualIndexName);
            String createBody = "  {\n    \"mappings\" : {\n      \"properties\": {\n        \"id\": { \"type\" : \"text\"},\n        \"name\": { \"type\" : \"text\"},\n        \"execution.id\": { \"type\" : \"text\"},\n        \"execution.name\": { \"type\" : \"text\"},\n        \"execution.filename\": { \"type\" : \"text\"},\n        \"execution.executionType\": { \"type\" : \"text\"},\n        \"execution.parentId\": { \"type\" : \"text\"},\n        \"execution.registrationDate\": { \"type\": \"date\" },\n        \"execution.executionStartDate\": { \"type\": \"date\" },\n        \"executionState.updateTime\": { \"type\": \"date\" },\n        \"executionState.executionEndDate\": { \"type\": \"date\" },\n        \"childExecutions\": { \"type\": \"object\", \"enabled\" : false },\n        \"childExecutionStates\": { \"type\": \"object\", \"enabled\" : false },\n        \"childExecutionData\": { \"type\": \"object\", \"enabled\" : false }\n      }\n    }, \"settings\": {\n      \"index.mapping.total_fields.limit\": 500\n    }\n  }\n";
            HttpRequest createRequest = HttpRequest.newBuilder().uri(createUri).header("Content-Type", "application/json").header("Accept", "application/json").header("Authorization", "ApiKey " + location.actualApiKey).PUT(HttpRequest.BodyPublishers.ofString(createBody)).build();
            HttpResponse<String> createResponse = client.send(createRequest, HttpResponse.BodyHandlers.ofString());
            if (createResponse.statusCode() != 200) {
                throw new HopException("Status code " + createResponse.statusCode() + " received from Elastic with response: " + createResponse.body());
            }
            MessageBox box = new MessageBox(hopGui.getShell(), 32);
            box.setText("Index ready");
            box.setMessage(BaseMessages.getString(PKG, (String)"ElasticExecutionInfoLocation.IndexCreatedAndConfigured", (String[])new String[]{location.actualIndexName}));
            box.open();
        }
        catch (Exception e) {
            new ErrorDialog(hopGui.getShell(), "Error", "Error creating Elastic index " + location.indexName, e);
        }
    }

    public String getPluginId() {
        return "elastic-location";
    }

    public void setPluginId(String pluginId) {
    }

    public String getPluginName() {
        return "Elastic location";
    }

    public void setPluginName(String pluginName) {
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public String getApiKey() {
        return this.apiKey;
    }

    @Generated
    public String getIndexName() {
        return this.indexName;
    }

    @Generated
    public String getActualUrl() {
        return this.actualUrl;
    }

    @Generated
    public String getActualApiKey() {
        return this.actualApiKey;
    }

    @Generated
    public String getActualIndexName() {
        return this.actualIndexName;
    }

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @Generated
    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    @Generated
    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    @Generated
    public void setActualUrl(String actualUrl) {
        this.actualUrl = actualUrl;
    }

    @Generated
    public void setActualApiKey(String actualApiKey) {
        this.actualApiKey = actualApiKey;
    }

    @Generated
    public void setActualIndexName(String actualIndexName) {
        this.actualIndexName = actualIndexName;
    }
}

