/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventhubs.impl;

import com.microsoft.azure.eventhubs.EventHubException;
import com.microsoft.azure.eventhubs.impl.AmqpReceiver;
import com.microsoft.azure.eventhubs.impl.BaseLinkHandler;
import com.microsoft.azure.eventhubs.impl.ExceptionUtil;
import java.util.Locale;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.engine.Receiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReceiveLinkHandler
extends BaseLinkHandler {
    private static final Logger TRACE_LOGGER = LoggerFactory.getLogger(ReceiveLinkHandler.class);
    private final AmqpReceiver amqpReceiver;
    private final String receiverName;
    private final ScheduledExecutorService executor;
    private final Object firstResponse;
    private boolean isFirstResponse;

    public ReceiveLinkHandler(AmqpReceiver receiver, String receiverName, ScheduledExecutorService executor) {
        super(receiver, receiverName);
        this.amqpReceiver = receiver;
        this.receiverName = receiverName;
        this.executor = executor;
        this.firstResponse = new Object();
        this.isFirstResponse = true;
    }

    public void onLinkLocalOpen(Event evt) {
        Link link = evt.getLink();
        if (link instanceof Receiver && TRACE_LOGGER.isInfoEnabled()) {
            TRACE_LOGGER.info(String.format(Locale.US, "onLinkLocalOpen receiverName[%s], linkName[%s], localSource[%s]", this.receiverName, link.getName(), link.getSource()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onLinkRemoteOpen(Event event) {
        Link link = event.getLink();
        if (link instanceof Receiver) {
            if (link.getRemoteSource() != null) {
                if (TRACE_LOGGER.isInfoEnabled()) {
                    TRACE_LOGGER.info(String.format(Locale.US, "onLinkRemoteOpen receiverName[%s], linkName[%s], remoteSource[%s]", this.receiverName, link.getName(), link.getRemoteSource()));
                }
                Object object = this.firstResponse;
                synchronized (object) {
                    this.isFirstResponse = false;
                    this.amqpReceiver.onOpenComplete(null);
                }
            } else if (TRACE_LOGGER.isInfoEnabled()) {
                TRACE_LOGGER.info(String.format(Locale.US, "onLinkRemoteOpen receiverName[%s], linkName[%s], action[waitingForError]", this.receiverName, link.getName()));
            }
        }
    }

    public void onLinkFinal(Event event) {
        if (this.isFirstResponse) {
            ErrorCondition condition;
            Link link = event.getLink();
            if (TRACE_LOGGER.isWarnEnabled()) {
                TRACE_LOGGER.warn(String.format(Locale.US, "onLinkFinal receiverName[%s], linkName[%s] - link never opened", this.receiverName, link.getName()));
            }
            final Exception finalOpenError = (condition = link.getCondition()) != null ? ExceptionUtil.toException(condition) : new EventHubException(true, "Link open failed, cause not available");
            this.executor.schedule(new Runnable(){

                @Override
                public void run() {
                    ReceiveLinkHandler.this.amqpReceiver.onOpenComplete(finalOpenError);
                }
            }, 5000L, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDelivery(Event event) {
        Object object = this.firstResponse;
        synchronized (object) {
            if (this.isFirstResponse) {
                this.isFirstResponse = false;
                this.amqpReceiver.onOpenComplete(null);
            }
        }
        Delivery delivery = event.getDelivery();
        Receiver receiveLink = (Receiver)delivery.getLink();
        if (!delivery.isPartial()) {
            if (delivery.isSettled()) {
                if (TRACE_LOGGER.isWarnEnabled()) {
                    TRACE_LOGGER.warn(receiveLink != null ? String.format(Locale.US, "onDelivery receiverName[%s], linkName[%s], updatedLinkCredit[%s], remoteCredit[%s], remoteCondition[%s], delivery.isSettled[%s]", this.receiverName, receiveLink.getName(), receiveLink.getCredit(), receiveLink.getRemoteCredit(), receiveLink.getRemoteCondition(), delivery.isSettled()) : String.format(Locale.US, "delivery.isSettled[%s]", delivery.isSettled()));
                }
            } else {
                this.amqpReceiver.onReceiveComplete(delivery);
            }
        }
        if (TRACE_LOGGER.isTraceEnabled() && receiveLink != null) {
            TRACE_LOGGER.trace(String.format(Locale.US, "onDelivery receiverName[%s], linkName[%s], updatedLinkCredit[%s], remoteCredit[%s], remoteCondition[%s], delivery.isPartial[%s]", this.receiverName, receiveLink.getName(), receiveLink.getCredit(), receiveLink.getRemoteCredit(), receiveLink.getRemoteCondition(), delivery.isPartial()));
        }
    }
}

