/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.graph;

import com.datastax.oss.driver.shaded.guava.common.base.Objects;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import java.io.Serializable;
import net.jcip.annotations.Immutable;

@Immutable
public class EditDistance
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_EDIT_DISTANCE = 0;
    public final String query;
    public final int distance;

    public EditDistance(String query) {
        this(query, 0);
    }

    public EditDistance(String query, int distance) {
        Preconditions.checkNotNull((Object)query, (Object)"Query cannot be null.");
        Preconditions.checkArgument((distance >= 0 ? 1 : 0) != 0, (Object)"Edit distance cannot be negative.");
        this.query = query;
        this.distance = distance;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EditDistance)) {
            return false;
        }
        EditDistance that = (EditDistance)o;
        return this.distance == that.distance && Objects.equal((Object)this.query, (Object)that.query);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.query, this.distance});
    }

    public String toString() {
        return "EditDistance{query='" + this.query + '\'' + ", distance=" + this.distance + '}';
    }
}

