/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.vfs.s3.s3.vfs;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.AbstractMap;
import java.util.List;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.vfs.s3.s3.vfs.S3FileSystem;
import org.apache.hop.vfs.s3.s3common.S3CommonFileObject;
import org.apache.hop.vfs.s3.s3common.S3CommonPipedOutputStream;

public class S3FileObject
extends S3CommonFileObject {
    public S3FileObject(AbstractFileName name, S3FileSystem fileSystem) {
        super(name, fileSystem);
        this.bucketName = this.getS3BucketName();
    }

    @Override
    public String getS3BucketName() {
        String s3BucketName = this.getName().getPath();
        s3BucketName = s3BucketName.indexOf("/", 1) > 1 ? s3BucketName.substring(0, s3BucketName.indexOf("/", 1)) : s3BucketName.replaceAll("/", "");
        if (s3BucketName.startsWith("/")) {
            s3BucketName = s3BucketName.substring(1);
        }
        return s3BucketName;
    }

    @Override
    protected List<String> getS3ObjectsFromVirtualFolder(String key, String bucket) {
        AbstractMap.SimpleEntry<String, String> newPath = this.fixFilePath(key, bucket);
        return super.getS3ObjectsFromVirtualFolder(newPath.getKey(), newPath.getValue());
    }

    @Override
    protected S3Object getS3Object(String key, String bucket) {
        if (this.s3Object != null && this.s3Object.getObjectContent() != null) {
            LogChannel.GENERAL.logDebug("Returning existing object {0}", new Object[]{this.getQualifiedName()});
            return this.s3Object;
        }
        LogChannel.GENERAL.logDebug("Getting object {0}", new Object[]{this.getQualifiedName()});
        AbstractMap.SimpleEntry<String, String> newPath = this.fixFilePath(key, bucket);
        return this.fileSystem.getS3Client().getObject(newPath.getValue(), newPath.getKey());
    }

    private boolean bucketExists(String bucket) {
        boolean bucketExists = false;
        try {
            bucketExists = this.fileSystem.getS3Client().doesBucketExistV2(bucket);
        }
        catch (SdkClientException e) {
            LogChannel.GENERAL.logError("Exception checking if bucket exists", (Throwable)e);
        }
        return bucketExists;
    }

    @Override
    protected boolean isRootBucket() {
        AbstractMap.SimpleEntry<String, String> newPath = this.fixFilePath(this.key, this.bucketName);
        return newPath.getKey().equals("");
    }

    @Override
    public void doDelete() throws FileSystemException {
        AbstractMap.SimpleEntry<String, String> newPath = this.fixFilePath(this.key, this.bucketName);
        this.doDelete(newPath.getKey(), newPath.getValue());
    }

    @Override
    public OutputStream doGetOutputStream(boolean bAppend) throws Exception {
        AbstractMap.SimpleEntry<String, String> newPath = this.fixFilePath(this.key, this.bucketName);
        return new S3CommonPipedOutputStream(this.fileSystem, newPath.getValue(), newPath.getKey(), ((S3FileSystem)this.fileSystem).getPartSize());
    }

    @Override
    protected PutObjectRequest createPutObjectRequest(String bucketName, String key, InputStream inputStream, ObjectMetadata objectMetadata) {
        AbstractMap.SimpleEntry<String, String> newPath = this.fixFilePath(key, bucketName);
        return new PutObjectRequest(newPath.getValue(), newPath.getKey(), inputStream, objectMetadata);
    }

    @Override
    protected CopyObjectRequest createCopyObjectRequest(String sourceBucket, String sourceKey, String destBucket, String destKey) {
        AbstractMap.SimpleEntry<String, String> sourcePath = this.fixFilePath(sourceKey, sourceBucket);
        AbstractMap.SimpleEntry<String, String> destPath = this.fixFilePath(destKey, destBucket);
        return new CopyObjectRequest(sourcePath.getValue(), sourcePath.getKey(), destPath.getValue(), destPath.getKey());
    }

    @Override
    public void handleAttachException(String key, String bucket) throws FileSystemException {
        block3: {
            AbstractMap.SimpleEntry<String, String> newPath = this.fixFilePath(key, bucket);
            String keyWithDelimiter = newPath.getKey() + "/";
            try {
                this.s3Object = this.getS3Object(keyWithDelimiter, newPath.getValue());
                this.s3ObjectMetadata = this.s3Object.getObjectMetadata();
                this.injectType(FileType.FOLDER);
            }
            catch (AmazonS3Exception e2) {
                ListObjectsRequest listObjectsRequest = new ListObjectsRequest().withBucketName(newPath.getValue()).withPrefix(keyWithDelimiter).withDelimiter("/");
                ObjectListing ol = this.fileSystem.getS3Client().listObjects(listObjectsRequest);
                if (!ol.getCommonPrefixes().isEmpty() || !ol.getObjectSummaries().isEmpty()) {
                    this.injectType(FileType.FOLDER);
                }
                String errorCode = e2.getErrorCode();
                if (errorCode.equals("NoSuchKey")) break block3;
                LogChannel.GENERAL.logError("Could not get information on " + this.getQualifiedName(), (Throwable)e2);
                throw new FileSystemException("vfs.provider/get-type.error", (Object)this.getQualifiedName(), (Throwable)e2);
            }
        }
    }

    public AbstractMap.SimpleEntry<String, String> fixFilePath(String key, String bucket) {
        String newBucket = bucket;
        String newKey = key;
        if (!this.bucketExists(bucket)) {
            LogChannel.GENERAL.logDebug("Bucket {} from original path not found, might be an old path from the old driver", new Object[]{bucket});
            if (key.split("/").length > 1) {
                newBucket = key.split("/")[0];
                newKey = key.replaceFirst(newBucket + "/", "");
            } else {
                newBucket = key;
                newKey = "";
            }
        }
        return new AbstractMap.SimpleEntry<String, String>(newKey, newBucket);
    }
}

