<!--
SPDX-License-Identifier: Apache-2.0

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    https://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
-->

# Grails Repackaging

As part of the move to the Apache Software Foundation, the grails artifacts must adhere to the apache namespace.

## Package Rules

The Grails developers have decided on several rules regarding packaging. These rules are enumerated here:

1. For Grails applications, the group used should always be `org.apache.grails`.
2. Any group that is further nested is an implementation detail of Grails. While users can choose to override them, they
   are typically not meant to be included in a Grails app directly.
3. Testing artifacts for Grails applications / plugins, will have the prefix `grails-testing-support-` to remind
   developers these artifacts should not typically be included in the `implementation` scope of their application.
4. As part of the gradle plugin consolidation, we adopt consistent names and remove `views-` from the views gradle
   plugins. Instead they will match the existing gradle plugin naming pattern - i.e. `grails-gsp`, `grails-markup`, etc.
5. There will be one artifact published that can be included in either a `buildSrc/build.gradle` or a `buildScript` to
   import all Grails gradle plugins. That plugin will be `org.apache.grails:grails-gradle-plugins`.
6. Grails artifacts should be prefixed with `grails-` with the exception of profiles.
7. Profiles will not use a `grails-` prefix because they are not distributed with an application.
8. Because there are many modern JSON implementations, and Grails may choose to implement them in the future, we will
   refer to our existing `.gson` implementation as `gson` instead of `json`.
9. We have appended `-cli` where a CLI is being provided.
10. Several artifacts have been renamed for clarity. In general we use the suffix `-core` to signify a base project and
    drop the suffix on the package that the end user will use.
11. Package names, artifact ids, and group ids will use the plural form. Implementing classes will use the singular
    form.
    * For example: `org.apache.grails.events:grails-events` with the `EventBusPlugin`

## Reference Table

Below is a reference of all migrated artifacts - both their old and new name.

| old group id                      | old artifact id                                 | new group id                                    | new artifact id                                               | old gradle plugin name | new gradle plugin name | repository             |
|-----------------------------------|-------------------------------------------------|-------------------------------------------------|---------------------------------------------------------------|------------------------|------------------------|------------------------|
| org.grails.plugins                | async                                           | org.apache.grails                               | grails-async                                                  |                        |                        | grails-core            |
| org.grails                        | grails-async                                    | org.apache.grails.async                         | grails-async-core                                             |                        |                        | grails-core            |
| org.grails                        | grails-async-gpars                              | org.apache.grails.async                         | grails-async-gpars                                            |                        |                        | grails-core            |
| org.grails                        | grails-async-rxjava                             | org.apache.grails.async                         | grails-async-rxjava                                           |                        |                        | grails-core            |
| org.grails                        | grails-async-rxjava2                            | org.apache.grails.async                         | grails-async-rxjava2                                          |                        |                        | grails-core            |
| org.grails                        | grails-async-rxjava3                            | org.apache.grails.async                         | grails-async-rxjava3                                          |                        |                        | grails-core            |
| org.grails                        | grails-bom                                      | org.apache.grails                               | grails-bom                                                    |                        |                        | grails-core            |
| org.grails                        | grails-bootstrap                                | org.apache.grails.bootstrap                     | grails-bootstrap                                              |                        |                        | grails-core            |
| org.grails.plugins                | cache                                           | org.apache.grails                               | grails-cache                                                  |                        |                        | grails-cache           |
| org.grails                        | grails-plugin-codecs                            | org.apache.grails                               | grails-codecs                                                 |                        |                        | grails-core            |
| org.grails                        | grails-codecs                                   | org.apache.grails.codecs                        | grails-codecs-core                                            |                        |                        | grails-core            |
| org.grails                        | grails-console                                  | org.apache.grails                               | grails-console                                                |                        |                        | grails-core            |
| org.grails                        | grails-plugin-controllers                       | org.apache.grails                               | grails-controllers                                            |                        |                        | grails-core            |
| org.grails.plugins                | converters                                      | org.apache.grails                               | grails-converters                                             |                        |                        | grails-core            |
| org.grails                        | grails-core                                     | org.apache.grails                               | grails-core                                                   |                        |                        | grails-core            |
| org.grails.plugins                | hibernate5                                      | org.apache.grails                               | grails-data-hibernate5                                        |                        |                        | grails-data-mapping    |
| org.grails.plugins                | database-migration                              | org.apache.grails                               | grails-data-hibernate5-dbmigration                            |                        |                        | grails-data-mapping    |
| org.grails                        | gorm-hibernate5-spring-boot                     | org.apache.grails                               | grails-data-hibernate5-spring-boot                            |                        |                        | grails-data-mapping    |
| org.grails.plugins                | hibernate6                                      | org.apache.grails                               | grails-data-hibernate6                                        |                        |                        | grails-data-hibernate6 |
| org.grails.plugins                | database-migration                              | org.apache.grails                               | grails-data-hibernate6-dbmigration                            |                        |                        | grails-data-hibernate6 |
| org.grails                        | gorm-hibernate6-spring-boot                     | org.apache.grails                               | grails-data-hibernate6-spring-boot                            |                        |                        | grails-data-hibernate6 |
| org.grails                        | grails-datastore-gorm-async                     | org.apache.grails.data                          | grails-datamapping-async                                      |                        |                        | grails-data-mapping    |
| org.grails                        | grails-datastore-gorm                           | org.apache.grails.data                          | grails-datamapping-core                                       |                        |                        | grails-data-mapping    |
| org.grails                        | grails-datastore-gorm-test                      | org.apache.grails.data                          | grails-datamapping-core-test                                  |                        |                        | grails-data-mapping    |
| org.grails                        | grails-datastore-gorm-hibernate5                | org.apache.grails.data                          | grails-data-hibernate5-core                                   |                        |                        | grails-data-mapping    |
| org.grails                        | grails-datastore-gorm-hibernate6                | org.apache.grails.data                          | grails-data-hibernate6-core                                   |                        |                        | grails-data-hibernate6 |
| org.grails                        | grails-datastore-gorm-mongodb                   | org.apache.grails.data                          | grails-data-mongodb-core                                      |                        |                        | grails-data-mapping    |
| org.grails                        | grails-datastore-gorm-mongodb-ext               | org.apache.grails.data                          | grails-data-mongodb-ext                                       |                        |                        | grails-data-mapping    |
| org.grails                        | grails-datastore-gorm-mongodb-bson              | org.apache.grails.data                          | grails-data-mongodb-bson                                      |                        |                        | grails-data-mapping    |
| org.grails                        | grails-datastore-gorm-support                   | org.apache.grails.data                          | grails-datamapping-support                                    |                        |                        | grails-data-mapping    |
| org.grails.tck.base               | tck-base                                        | org.apache.grails.data                          | grails-datamapping-tck-base                                   |                        |                        | grails-data-mapping    |
| org.grails.tck.base               | tck-domains                                     | org.apache.grails.data                          | grails-datamapping-tck-domains                                |                        |                        | grails-data-mapping    |
| org.grails.tck.base               | tck-tests                                       | org.apache.grails.data                          | grails-datamapping-tck-tests                                  |                        |                        | grails-data-mapping    |
| org.grails                        | grails-gorm-testing-support                     | org.apache.grails                               | grails-testing-support-datamapping                            |                        |                        | grails-data-mapping    |
| org.grails                        | grails-datastore-gorm-validation                | org.apache.grails.data                          | grails-datamapping-validation                                 |                        |                        | grails-data-mapping    |
| org.grails.plugins                | mongodb                                         | org.apache.grails                               | grails-data-mongodb                                           |                        |                        | grails-data-mapping    |
| org.grails.plugins                | views-json-templates                            | org.apache.grails                               | grails-data-mongodb-gson-templates                            |                        |                        | grails-data-mapping    |
| org.grails                        | gorm-mongodb-spring-boot                        | org.apache.grails                               | grails-data-mongodb-spring-boot                               |                        |                        | grails-data-mapping    |
| org.grails                        | grails-datastore-gorm-simple                    | org.apache.grails.data                          | grails-data-simple                                            |                        |                        | grails-data-mapping    |
| org.grails                        | grails-plugin-databinding                       | org.apache.grails                               | grails-databinding                                            |                        |                        | grails-core            |
| org.grails                        | grails-databinding                              | org.apache.grails.databinding                   | grails-databinding-core                                       |                        |                        | grails-core            |
| org.grails                        | grails-plugin-datasource                        | org.apache.grails                               | grails-datasource                                             |                        |                        | grails-core            |
| org.grails                        | grails-datastore-async                          | org.apache.grails.data                          | grails-datastore-async                                        |                        |                        | grails-data-mapping    |
| org.grails                        | grails-datastore-core                           | org.apache.grails.data                          | grails-datastore-core                                         |                        |                        | grails-data-mapping    |
| org.grails                        | grails-datastore-web                            | org.apache.grails.data                          | grails-datastore-web                                          |                        |                        | grails-data-mapping    |
| org.grails                        | grails-dependencies                             | org.apache.grails                               | grails-dependencies-starter-web                               |                        |                        | grails-core            |
| org.grails                        | grails-docs                                     | org.apache.grails                               | grails-docs-core                                              |                        |                        | grails-core            |
| org.grails                        | grails-plugin-domain-class                      | org.apache.grails                               | grails-domain-class                                           |                        |                        | grails-core            |
| org.grails                        | grails-encoder                                  | org.apache.grails.web                           | grails-encoder                                                |                        |                        | grails-core            |
| org.grails.plugins                | events                                          | org.apache.grails                               | grails-events                                                 |                        |                        | grails-core            |
| org.grails                        | grails-events                                   | org.apache.grails.events                        | grails-events-core                                            |                        |                        | grails-core            |
| org.grails                        | grails-events-compat                            | org.apache.grails.events                        | grails-events-compat                                          |                        |                        | grails-core            |
| org.grails                        | grails-events-gpars                             | org.apache.grails.events                        | grails-events-gpars                                           |                        |                        | grails-core            |
| org.grails                        | grails-events-rxjava                            | org.apache.grails.events                        | grails-events-rxjava                                          |                        |                        | grails-core            |
| org.grails                        | grails-events-rxjava2                           | org.apache.grails.events                        | grails-events-rxjava2                                         |                        |                        | grails-core            |
| org.grails                        | grails-events-rxjava3                           | org.apache.grails.events                        | grails-events-rxjava3                                         |                        |                        | grails-core            |
| org.grails                        | grails-events-spring                            | org.apache.grails.events                        | grails-events-spring                                          |                        |                        | grails-core            |
| org.grails                        | grails-events-transform                         | org.apache.grails.events                        | grails-events-transforms                                      |                        |                        | grails-core            |
| org.grails.plugins                | fields                                          | org.apache.grails                               | grails-fields                                                 |                        |                        | grails-views           |
| org.grails.plugins                | geb                                             | org.apache.grails                               | grails-geb                                                    |                        |                        | grails-geb             |
| org.grails                        | grails-gradle-model                             | org.apache.grails.gradle                        | grails-gradle-model                                           |                        |                        | grails-core            |
| org.grails.plugins                | gsp                                             | org.apache.grails                               | grails-gsp                                                    |                        |                        | grails-views           |
| org.grails                        | grails-gsp                                      | org.apache.grails.views                         | grails-gsp-core                                               |                        |                        | grails-views           |
| org.grails                        | grails-logging                                  | org.apache.grails                               | grails-logging                                                |                        |                        | grails-core            |
| org.grails                        | grails-plugin-i18n                              | org.apache.grails                               | grails-i18n                                                   |                        |                        | grails-core            |
| org.grails                        | grails-plugin-interceptors                      | org.apache.grails                               | grails-interceptors                                           |                        |                        | grails-core            |
| org.grails                        | grails-plugin-mimetypes                         | org.apache.grails                               | grails-mimetypes                                              |                        |                        | grails-core            |
| org.grails.plugins                | quartz                                          | org.apache.grails                               | grails-quartz                                                 |                        |                        | grails-quartz          |
| org.grails.plugins                | grails-redis                                    | org.apache.grails                               | grails-redis                                                  |                        |                        | grails-redis           |
| org.grails                        | grails-plugin-rest                              | org.apache.grails                               | grails-rest-transforms                                        |                        |                        | grails-core            |
| org.grails.plugins                | scaffolding                                     | org.apache.grails                               | grails-scaffolding                                            |                        |                        | grails-views           |
| org.grails                        | grails-plugin-services                          | org.apache.grails                               | grails-services                                               |                        |                        | grails-core            |
| org.grails                        | grails-shell                                    | org.apache.grails                               | grails-shell-cli                                              |                        |                        | grails-core            |
| org.grails.plugins                | sitemesh2                                       | org.apache.grails                               | grails-layout                                                 |                        |                        | grails-gsp             |
| org.grails                        | grails-plugin-sitemesh3                         | org.apache.grails                               | grails-sitemesh3                                              |                        |                        | grails-views           |
| org.grails                        | grails-spring                                   | org.apache.grails                               | grails-spring                                                 |                        |                        | grails-core            |
| org.grails.plugins                | spring-security-acl                             | org.apache.grails                               | grails-spring-security-acl                                    |                        |                        | grails-spring-security |
| org.grails.plugins                | spring-security-cas                             | org.apache.grails                               | grails-spring-security-cas                                    |                        |                        | grails-spring-security |
| org.grails.plugins                | spring-security-core                            | org.apache.grails                               | grails-spring-security                                        |                        |                        | grails-spring-security |
| org.grails.plugins                | spring-security-ldap                            | org.apache.grails                               | grails-spring-security-ldap                                   |                        |                        | grails-spring-security |
| org.grails.plugins                | spring-security-oauth2                          | org.apache.grails                               | grails-spring-security-oauth2                                 |                        |                        | grails-spring-security |
| org.grails.plugins                | spring-security-rest                            | org.apache.grails                               | grails-spring-security-rest                                   |                        |                        | grails-spring-security |
| org.grails.plugins                | spring-security-rest-gorm                       | org.apache.grails                               | grails-spring-security-rest-datamapping                       |                        |                        | grails-spring-security |
| org.grails.plugins                | spring-security-rest-grailscache                | org.apache.grails                               | grails-spring-security-grails-cache                           |                        |                        | grails-spring-security |
| org.grails.plugins                | spring-security-rest-memcached                  | org.apache.grails                               | grails-spring-security-rest-memcached                         |                        |                        | grails-spring-security |
| org.grails.plugins                | spring-security-rest-redis                      | org.apache.grails                               | grails-spring-security-rest-redis                             |                        |                        | grails-spring-security |
| org.grails.plugins                | spring-security-ui                              | org.apache.grails                               | grails-spring-security-ui                                     |                        |                        | grails-spring-security |
| org.grails                        | grails-taglib                                   | org.apache.grails.views                         | grails-taglib                                                 |                        |                        | grails-views           |
| org.grails                        | grails-test                                     | org.apache.grails.testing                       | grails-test-core                                              |                        |                        | grails-core            |
| org.grails                        | grails-testing-support                          | org.apache.grails.testing                       | grails-testing-support-core                                   |                        |                        | grails-core            |
| org.grails                        | grails-plugin-url-mappings                      | org.apache.grails                               | grails-url-mappings                                           |                        |                        | grails-core            |
| org.grails                        | grails-plugin-validation                        | org.apache.grails                               | grails-validation                                             |                        |                        | grails-core            |
| org.grails                        | views-core                                      | org.apache.grails.views                         | grails-views-core                                             |                        |                        | grails-views           |
| org.grails.plugins                | views-json                                      | org.apache.grails                               | grails-views-gson                                             |                        |                        | grails-views           |
| org.grails                        | views-json-testing-support                      | org.apache.grails                               | grails-testing-support-views-gson                             |                        |                        | grails-views           |
| org.grails                        | views-markup                                    | org.apache.grails                               | grails-views-markup                                           |                        |                        | grails-views           |
| org.grails.plugins                | views-gradle                                    | org.apache.grails                               | grails-gradle-plugins                                         |                        |                        | grails-views           |
| org.grails                        | grails-web                                      | org.apache.grails.web                           | grails-web-core                                               |                        |                        | grails-core            |
| org.grails                        | grails-web-boot                                 | org.apache.grails                               | grails-web-boot                                               |                        |                        | grails-core            |
| org.grails                        | grails-web-common                               | org.apache.grails.web                           | grails-web-common                                             |                        |                        | grails-core            |
| org.grails                        | grails-web-databinding                          | org.apache.grails.web                           | grails-web-databinding                                        |                        |                        | grails-core            |
| org.grails                        | grails-web-gsp                                  | org.apache.grails.views                         | grails-web-gsp                                                |                        |                        | grails-views           |
| org.grails                        | grails-web-gsp-taglib                           | org.apache.grails.views                         | grails-web-gsp-taglib                                         |                        |                        | grails-views           |
| org.grails                        | grails-web-jsp                                  | org.apache.grails.views                         | grails-web-jsp                                                |                        |                        | grails-views           |
| org.grails                        | grails-web-mvc                                  | org.apache.grails.web                           | grails-web-mvc                                                |                        |                        | grails-core            |
| org.grails                        | grails-web-taglib                               | org.apache.grails.views                         | grails-web-taglib                                             |                        |                        | grails-views           |
| org.grails                        | grails-web-testing-support                      | org.apache.grails                               | grails-testing-support-web                                    |                        |                        | grails-views           |
| org.grails                        | grails-web-url-mappings                         | org.apache.grails.web                           | grails-web-url-mappings                                       |                        |                        | grails-core            |
| PROFILES                          |                                                 |                                                 |                                                               |                        |                        |                        |
| org.grails.profiles               | angular                                         | org.apache.grails.profiles                      | angular                                                       |                        |                        | grails-profiles        |
| org.grails.profiles               | base                                            | org.apache.grails.profiles                      | base                                                          |                        |                        | grails-profiles        |
| org.grails.profiles               | plugin                                          | org.apache.grails.profiles                      | plugin                                                        |                        |                        | grails-profiles        |
| org.grails.profiles               | profile                                         | org.apache.grails.profiles                      | profile                                                       |                        |                        | grails-profiles        |
| org.grails.profiles               | react                                           | org.apache.grails.profiles                      | react                                                         |                        |                        | grails-profiles        |
| org.grails.profiles               | rest-api                                        | org.apache.grails.profiles                      | rest-api                                                      |                        |                        | grails-profiles        |
| org.grails.profiles               | rest-api-plugin                                 | org.apache.grails.profiles                      | rest-api-plugin                                               |                        |                        | grails-profiles        |
| org.grails.plugins                | spring-security-rest-testapp-profile            | org.apache.grails.profiles                      | spring-security-rest-testapp                                  |                        |                        | grails-spring-security |
| org.grails.profiles               | vue                                             | org.apache.grails.profiles                      | vue                                                           |                        |                        | grails-profiles        |
| org.grails.profiles               | web                                             | org.apache.grails.profiles                      | web                                                           |                        |                        | grails-profiles        |
| org.grails.profiles               | web-plugin                                      | org.apache.grails.profiles                      | web-plugin                                                    |                        |                        | grails-profiles        |
| GRADLE                            |                                                 |                                                 |                                                               |                        |                        |                        |
| org.grails                        | grails-gradle-plugin                            | org.apache.grails                               | grails-gradle-plugins                                         |                        |                        | grails-gradle-plugin   |
| org.grails.grails-core            | org.grails.grails-core.gradle.plugin            | org.apache.grails.gradle.grails-app             | org.apache.grails.gradle.grails-app.gradle.plugin             | grails                 | grails-app             | grails-gradle-plugin   |
| org.grails.grails-gsp             | org.grails.grails-gsp.gradle.plugin             | org.apache.grails.gradle.grails-gsp             | org.apache.grails.gradle.grails-gsp.gradle.plugin             | grails-gsp             | grails-gsp             | grails-gradle-plugin   |
| org.grails.grails-plugin          | org.grails.grails-plugin.gradle.plugin          | org.apache.grails.gradle.grails-plugin          | org.apache.grails.gradle.grails-plugin.gradle.plugin          | grails-plugin          | grails-plugin          | grails-gradle-plugin   |
| org.grails.grails-profile         | org.grails.grails-profile.gradle.plugin         | org.apache.grails.gradle.grails-profile         | org.apache.grails.gradle.grails-profile.gradle.plugin         | grails-profile         | grails-profile         | grails-gradle-plugin   |
| org.grails.grails-profile-publish | org.grails.grails-profile-publish.gradle.plugin | org.apache.grails.gradle.grails-publish-profile | org.apache.grails.gradle.grails-publish-profile.gradle.plugin | grails-profile-publish | grails-publish-profile | grails-gradle-plugin   |
| org.grails.grails-publish         | org.grails.grails-publish.gradle.plugin         | org.apache.grails.gradle.grails-publish         | org.apache.grails.gradle.grails-publish.gradle.plugin         | grails-publish         | grails-publish         | grails-gradle-plugin   |
| org.grails.plugins.views-json     | org.grails.plugins.views-json.gradle.plugin     | org.apache.grails.gradle.grails-gson            | org.apache.grails.gradle.grails-gson.gradle.plugin            | views-json             | grails-gson            | grails-gradle-plugin   |
| org.grails.plugins.views-markup   | org.grails.plugins.views-markup.gradle.plugin   | org.apache.grails.gradle.grails-markup          | org.apache.grails.gradle.grails-markup.gradle.plugin          | views-markup           | grails-markup          | grails-gradle-plugin   |
| org.grails.grails-web             | org.grails.grails-web.gradle.plugin             | org.apache.grails.gradle.grails-web             | org.apache.grails.gradle.grails-web.gradle.plugin             | grails-web             | grails-web             | grails-gradle-plugin   |
| FORGE                             |                                                 |                                                 |                                                               |                        |                        |                        |
| org.grails.forge                  | grails-forge-api                                | org.apache.grails.forge                         | grails-forge-api                                              |                        |                        | grails-forge           |
| org.grails.forge                  | grails-cli                                      | org.apache.grails.forge                         | grails-forge-cli                                              |                        |                        | grails-forge           |
| org.grails.forge                  | grails-forge-core                               | org.apache.grails.forge                         | grails-forge-core                                             |                        |                        | grails-forge           |

## Gradle Plugin Marker Artifacts

https://docs.gradle.org/current/userguide/plugins.html#sec:plugin_markers

Since the `plugins{}` DSL block only allows for declaring plugins by their globally unique plugin id and version
properties, Gradle needs a way to look up the coordinates of the plugin implementation artifact.

To do so, Gradle will look for a Plugin Marker Artifact with the coordinates
`plugin.id:plugin.id.gradle.plugin:plugin.version`. This marker needs to have a dependency on the actual plugin
implementation.
