/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.client.async;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.client.ClientManager;
import org.apache.iotdb.commons.client.ThriftClient;
import org.apache.iotdb.commons.client.factory.AsyncThriftClientFactory;
import org.apache.iotdb.commons.client.property.ThriftClientProperty;
import org.apache.iotdb.consensus.pipe.thrift.PipeConsensusIService;
import org.apache.iotdb.rpc.TNonblockingSocketWrapper;
import org.apache.thrift.async.TAsyncClientManager;
import org.apache.thrift.transport.TNonblockingTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncPipeConsensusServiceClient
extends PipeConsensusIService.AsyncClient
implements ThriftClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncPipeConsensusServiceClient.class);
    private static final AtomicInteger idGenerator = new AtomicInteger(0);
    private final int id = idGenerator.incrementAndGet();
    private final boolean printLogWhenEncounterException;
    private final TEndPoint endpoint;
    private final ClientManager<TEndPoint, AsyncPipeConsensusServiceClient> clientManager;
    private final AtomicBoolean shouldReturnSelf = new AtomicBoolean(true);

    public AsyncPipeConsensusServiceClient(ThriftClientProperty property, TEndPoint endpoint, TAsyncClientManager tAsyncClientManager, ClientManager<TEndPoint, AsyncPipeConsensusServiceClient> clientManager) throws IOException {
        super(property.getProtocolFactory(), tAsyncClientManager, (TNonblockingTransport)TNonblockingSocketWrapper.wrap((String)endpoint.getIp(), (int)endpoint.getPort(), (int)property.getConnectionTimeoutMs()));
        this.setTimeout(property.getConnectionTimeoutMs());
        this.printLogWhenEncounterException = property.isPrintLogWhenEncounterException();
        this.endpoint = endpoint;
        this.clientManager = clientManager;
    }

    public void onComplete() {
        super.onComplete();
        this.returnSelf();
    }

    public void onError(Exception e) {
        super.onError(e);
        ThriftClient.resolveException(e, this);
        this.returnSelf();
    }

    @Override
    public void invalidate() {
        if (!this.hasError()) {
            super.onError(new Exception(String.format("This client %d has been invalidated", this.id)));
        }
    }

    @Override
    public void invalidateAll() {
        this.clientManager.clear(this.endpoint);
    }

    @Override
    public boolean printLogWhenEncounterException() {
        return this.printLogWhenEncounterException;
    }

    public void returnSelf() {
        if (this.shouldReturnSelf.get()) {
            this.clientManager.returnClient(this.endpoint, this);
        }
    }

    public void setShouldReturnSelf(boolean shouldReturnSelf) {
        this.shouldReturnSelf.set(shouldReturnSelf);
    }

    private void close() {
        this.___transport.close();
        this.___currentMethod = null;
    }

    public boolean isReady() {
        try {
            this.checkReady();
            return true;
        }
        catch (Exception e) {
            LOGGER.info("Unexpected exception occurs in {}, error msg is {}", (Object)this, (Object)ExceptionUtils.getRootCause((Throwable)e).toString());
            return false;
        }
    }

    public String toString() {
        return String.format("AsyncPipeDataTransferServiceClient{%s}, id = {%d}", this.endpoint, this.id);
    }

    public TEndPoint getTEndpoint() {
        return this.endpoint;
    }

    public static class Factory
    extends AsyncThriftClientFactory<TEndPoint, AsyncPipeConsensusServiceClient> {
        public Factory(ClientManager<TEndPoint, AsyncPipeConsensusServiceClient> clientManager, ThriftClientProperty thriftClientProperty, String threadName) {
            super(clientManager, thriftClientProperty, threadName);
        }

        public void destroyObject(TEndPoint endPoint, PooledObject<AsyncPipeConsensusServiceClient> pooledObject) {
            ((AsyncPipeConsensusServiceClient)pooledObject.getObject()).close();
        }

        public PooledObject<AsyncPipeConsensusServiceClient> makeObject(TEndPoint endPoint) throws Exception {
            return new DefaultPooledObject((Object)new AsyncPipeConsensusServiceClient(this.thriftClientProperty, endPoint, this.tManagers[this.clientCnt.incrementAndGet() % this.tManagers.length], this.clientManager));
        }

        public boolean validateObject(TEndPoint endPoint, PooledObject<AsyncPipeConsensusServiceClient> pooledObject) {
            return ((AsyncPipeConsensusServiceClient)pooledObject.getObject()).isReady();
        }
    }
}

