/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.read;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathDeserializeUtil;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeUtil;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.read.SchemaFetchScanNode;
import org.apache.iotdb.db.schemaengine.template.Template;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class SeriesSchemaFetchScanNode
extends SchemaFetchScanNode {
    private final Map<Integer, Template> templateMap;
    private final boolean withTags;
    private final boolean withAttributes;
    private final boolean withTemplate;
    private final boolean withAliasForce;

    public SeriesSchemaFetchScanNode(PlanNodeId id, PartialPath storageGroup, PathPatternTree patternTree, Map<Integer, Template> templateMap, boolean withTags, boolean withAttributes, boolean withTemplate, boolean withAliasForce) {
        super(id, storageGroup, patternTree);
        this.templateMap = templateMap;
        this.withTags = withTags;
        this.withAttributes = withAttributes;
        this.withTemplate = withTemplate;
        this.withAliasForce = withAliasForce;
    }

    public Map<Integer, Template> getTemplateMap() {
        return this.templateMap;
    }

    @Override
    public PlanNodeType getType() {
        return PlanNodeType.SERIES_SCHEMA_FETCH_SCAN;
    }

    @Override
    public PlanNode clone() {
        return new SeriesSchemaFetchScanNode(this.getPlanNodeId(), this.storageGroup, this.patternTree, this.templateMap, this.withTags, this.withAttributes, this.withTemplate, this.withAliasForce);
    }

    public String toString() {
        return String.format("SeriesSchemaFetchScanNode-%s:[StorageGroup: %s, DataRegion: %s]", this.getPlanNodeId(), this.storageGroup, PlanNodeUtil.printRegionReplicaSet(this.getRegionReplicaSet()));
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.SERIES_SCHEMA_FETCH_SCAN.serialize(byteBuffer);
        this.storageGroup.serialize(byteBuffer);
        this.patternTree.serialize(byteBuffer);
        ReadWriteIOUtils.write((int)this.templateMap.size(), (ByteBuffer)byteBuffer);
        for (Template template : this.templateMap.values()) {
            template.serialize(byteBuffer);
        }
        ReadWriteIOUtils.write((Boolean)this.withTags, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((Boolean)this.withAttributes, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((Boolean)this.withTemplate, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((Boolean)this.withAliasForce, (ByteBuffer)byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.SERIES_SCHEMA_FETCH_SCAN.serialize(stream);
        this.storageGroup.serialize((OutputStream)stream);
        this.patternTree.serialize(stream);
        ReadWriteIOUtils.write((int)this.templateMap.size(), (OutputStream)stream);
        for (Template template : this.templateMap.values()) {
            template.serialize(stream);
        }
        ReadWriteIOUtils.write((Boolean)this.withTags, (OutputStream)stream);
        ReadWriteIOUtils.write((Boolean)this.withAttributes, (OutputStream)stream);
        ReadWriteIOUtils.write((Boolean)this.withTemplate, (OutputStream)stream);
        ReadWriteIOUtils.write((Boolean)this.withAliasForce, (OutputStream)stream);
    }

    public static SeriesSchemaFetchScanNode deserialize(ByteBuffer byteBuffer) {
        PartialPath storageGroup = (PartialPath)PathDeserializeUtil.deserialize((ByteBuffer)byteBuffer);
        PathPatternTree patternTree = PathPatternTree.deserialize((ByteBuffer)byteBuffer);
        int templateNum = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        HashMap<Integer, Template> templateMap = new HashMap<Integer, Template>();
        for (int i = 0; i < templateNum; ++i) {
            Template template = new Template();
            template.deserialize(byteBuffer);
            templateMap.put(template.getId(), template);
        }
        boolean withTags = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        boolean withAttributes = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        boolean withTemplate = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        boolean withAliasForce = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new SeriesSchemaFetchScanNode(planNodeId, storageGroup, patternTree, templateMap, withTags, withAttributes, withTemplate, withAliasForce);
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitSeriesSchemaFetchScan(this, context);
    }

    public boolean isWithTags() {
        return this.withTags;
    }

    public boolean isWithTemplate() {
        return this.withTemplate;
    }

    public boolean isWithAttributes() {
        return this.withAttributes;
    }

    public boolean isWithAliasForce() {
        return this.withAliasForce;
    }
}

