/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.tool;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.iotdb.db.storageengine.dataregion.compaction.tool.ITimeRange;
import org.apache.iotdb.db.storageengine.dataregion.compaction.tool.Interval;

public class ListTimeRangeImpl
implements ITimeRange {
    List<Interval> intervalList = new LinkedList<Interval>();

    @Override
    public void addInterval(Interval interval) {
        int index;
        ArrayList<Interval> mergedIntervals = new ArrayList<Interval>();
        for (index = 0; index < this.intervalList.size() && this.intervalList.get(index).getEnd() < interval.getStart(); ++index) {
            mergedIntervals.add(this.intervalList.get(index));
        }
        while (index < this.intervalList.size() && this.intervalList.get(index).getStart() <= interval.getEnd()) {
            interval.setStart(Math.min(this.intervalList.get(index).getStart(), interval.getStart()));
            interval.setEnd(Math.max(this.intervalList.get(index).getEnd(), interval.getEnd()));
            ++index;
        }
        mergedIntervals.add(interval);
        while (index < this.intervalList.size()) {
            mergedIntervals.add(this.intervalList.get(index));
            ++index;
        }
        this.intervalList.clear();
        this.intervalList.addAll(mergedIntervals);
    }

    public List<Interval> getIntervalList() {
        return this.intervalList;
    }

    @Override
    public boolean isOverlapped(Interval interval) {
        for (Interval currentInterval : this.intervalList) {
            boolean isOverlap = interval.getStart() <= currentInterval.getEnd() && interval.getEnd() >= currentInterval.getStart();
            if (!isOverlap) continue;
            return true;
        }
        return false;
    }
}

