<?xml version="1.0" encoding="ISO-8859-1" ?> 
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" >
	<xsl:output method="html" omit-xml-declaration="no" />

	<xsl:template match="module">
      <html:html xmlns:html="http://www.w3.org/1999/xhtml">
          <head>
              <style type="text/css">
                     @import url("./hivestyle.css");
                     th {text-align:left;}
              </style>
          </head><body>
          <h2>Modul &#160; <xsl:value-of select="@id"/>, 
                 &#160; Version:&#160;<xsl:value-of select="@version"/>,&#160; 
                 Package:&#160;<xsl:value-of select="@package"/>&#160; </h2>
    		 <xsl:apply-templates/>
          </body>
      </html:html>
	</xsl:template>
	
     
	<xsl:template match="service-point">
		<h3>Service-Point&#160;<xsl:value-of select="@id"/>&#160;&#160;<xsl:value-of select="@interface"/></h3>
        <xsl:if test="@parameters-schema-id">
           <p>Factory-Paramers: <a href="#{@parameters-schema-id}"><xsl:value-of select="@parameters-schema-id"/></a>
              (occurs: <xsl:value-of select="@parameters-occurs"/>)
           </p> 
        </xsl:if>
		  <p><xsl:apply-templates/></p>
	</xsl:template>
	
    <xsl:template match="schema">
		<h3><a name="{@id}">Schema</a>&#160;<xsl:value-of select="@id"/></h3>
        Elements:
         <table>
             <tbody>
        		  <xsl:apply-templates/>
             </tbody>
         </table>
	</xsl:template>
	
    <xsl:template match="element">
		<tr> <td><b><xsl:value-of select="@name"/></b> </td>
            <td>
                <table>
                    <thead><tr><th>Attribut</th><th>required</th><th>translator</th><th>description</th></tr></thead>
                    <tbody>
            		  <xsl:apply-templates/>
                    </tbody>
                </table>
            </td>
         </tr>
	</xsl:template>
    <xsl:template match="attribute">
		<tr><td><xsl:value-of select="@name"/></td>
            <td><xsl:value-of select="@required"/></td>
            <td><xsl:value-of select="@translator"/></td>
            <td><xsl:value-of select="."/></td>
		</tr>
	</xsl:template>
</xsl:stylesheet>
