/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.netbeans.modules.java.source.parsing;
import java.io.File;
import java.util.jar.JarFile;
import org.netbeans.junit.NbTestCase;
import org.netbeans.modules.java.source.StopWatch;
import org.netbeans.modules.java.source.TestUtil;

/** Tests what is slow on working with Jar/Zip files
 *
 * @author Petr Hrebejk
 */
public class PerfZipJarOpenTest extends NbTestCase {

    private File workDir;
    private File rtJar;

    public PerfZipJarOpenTest(String testName) {
        super(testName);
    }

    protected void setUp() throws Exception {
        workDir = getWorkDir();
        rtJar = TestUtil.createRT_JAR(workDir);
    }

    public void testOpenCloseJar() throws Exception {
        
        StopWatch swatch = new StopWatch();
        JarFile jf;        
        
        for( int i = 0; i < 10; i++ ) {
            
            swatch.start();
            jf = new JarFile( rtJar );
            swatch.stop( "Create done" );
            
            swatch.start();
            jf.close();
            swatch.stop( "Close done" );

            /*
            swatch.start();        
            CompilationUnitTree cu = ji.parse( fileName, source ); 
            swatch.stop( "Close done" );
            */
        }
        
    }

}
