/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.invocation;

import com.netflix.config.DynamicPropertyFactory;
import java.util.Map;
import org.apache.servicecomb.core.Endpoint;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.SCBEngine;
import org.apache.servicecomb.core.definition.InvocationRuntimeType;
import org.apache.servicecomb.core.definition.OperationMeta;
import org.apache.servicecomb.core.provider.consumer.ReferenceConfig;
import org.apache.servicecomb.registry.RegistrationManager;
import org.apache.servicecomb.registry.api.registry.Microservice;

public final class InvocationFactory {
    private InvocationFactory() {
    }

    public static Invocation forConsumer(ReferenceConfig referenceConfig, OperationMeta operationMeta, InvocationRuntimeType invocationRuntimeType, Map<String, Object> swaggerArguments) {
        Invocation invocation = new Invocation(referenceConfig, operationMeta, invocationRuntimeType, swaggerArguments);
        return InvocationFactory.setSrcMicroservice(invocation);
    }

    public static Invocation setSrcMicroservice(Invocation invocation) {
        Microservice microservice = RegistrationManager.INSTANCE.getMicroservice();
        invocation.addContext("x-cse-src-microservice", microservice.getServiceName());
        if (InvocationFactory.addSourceServiceId()) {
            invocation.addContext("x-src-serviceId", microservice.getServiceId());
        }
        if (InvocationFactory.addSourceInstanceId()) {
            invocation.addContext("x-src-instanceId", microservice.getInstance().getInstanceId());
        }
        return invocation;
    }

    public static boolean addSourceServiceId() {
        return DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.context.source.serviceId", true).get();
    }

    public static boolean addSourceInstanceId() {
        return DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.context.source.instanceId", true).get();
    }

    public static Invocation forProvider(Endpoint endpoint, OperationMeta operationMeta, Map<String, Object> swaggerArguments) {
        SCBEngine.getInstance().ensureStatusUp();
        return new Invocation(endpoint, operationMeta, swaggerArguments);
    }
}

