/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0;

import com.mchange.v2.async.ThreadPoolReportingAsynchronousRunner;
import com.mchange.v2.c3p0.TaskRunnerFactory;
import com.mchange.v2.c3p0.TaskRunnerInit;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import com.mchange.v2.util.ResourceClosedException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.sql.ConnectionPoolDataSource;

public abstract class AbstractExecutorTaskRunnerFactory
implements TaskRunnerFactory {
    private static final MLogger logger = MLog.getLogger(AbstractExecutorTaskRunnerFactory.class);
    private static final String SEP = System.lineSeparator();
    private static final StackTraceElement[] EMPTY_STACK_TRACES = new StackTraceElement[0];

    protected abstract Executor findCreateExecutor(TaskRunnerInit var1);

    protected abstract boolean taskRunnerOwnsExecutor();

    protected abstract ThreadPoolReportingAsynchronousRunner createTaskRunner(TaskRunnerInit var1, Timer var2);

    protected HashMap otherPropertiesFromConnectionPoolDataSource(ConnectionPoolDataSource connectionPoolDataSource) {
        return new HashMap();
    }

    @Override
    public ThreadPoolReportingAsynchronousRunner createTaskRunner(int n, int n2, String string, boolean bl, String string2, ConnectionPoolDataSource connectionPoolDataSource, Timer timer) {
        HashMap hashMap = this.otherPropertiesFromConnectionPoolDataSource(connectionPoolDataSource);
        TaskRunnerInit taskRunnerInit = new TaskRunnerInit(n, n2, string, bl, string2, hashMap);
        return this.createTaskRunner(taskRunnerInit, timer);
    }

    public boolean equals(Object object) {
        return this.getClass().equals(object.getClass());
    }

    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    protected abstract class AbstractExecutorAsynchronousRunner
    implements ThreadPoolReportingAsynchronousRunner {
        protected final TaskRunnerInit init;
        protected final Timer timer;
        private final int matt_ms;
        private Object xlock = new Object();
        private Executor x = null;
        private HashSet activeWrapperRunnables = new HashSet();
        private boolean is_closed = false;

        protected synchronized void registerActive(WrapperRunnable wrapperRunnable) {
            this.activeWrapperRunnables.add(wrapperRunnable);
        }

        protected synchronized void unregisterActive(WrapperRunnable wrapperRunnable) {
            this.activeWrapperRunnables.remove(wrapperRunnable);
        }

        protected synchronized int activeCount() {
            return this.activeWrapperRunnables.size();
        }

        protected synchronized HashSet snapshotActives() {
            return (HashSet)this.activeWrapperRunnables.clone();
        }

        protected synchronized boolean isClosed() {
            return this.is_closed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Executor executor() {
            Object object = this.xlock;
            synchronized (object) {
                if (this.x == null) {
                    this.x = AbstractExecutorTaskRunnerFactory.this.findCreateExecutor(this.init);
                }
                return this.x;
            }
        }

        protected AbstractExecutorAsynchronousRunner(TaskRunnerInit taskRunnerInit, Timer timer) {
            this.init = taskRunnerInit;
            this.timer = timer;
            this.matt_ms = taskRunnerInit.max_administrative_task_time_if_supported * 1000;
        }

        @Override
        public synchronized void postRunnable(Runnable runnable) {
            if (this.isClosed()) {
                throw new ResourceClosedException("Attempted to use " + this + " after it has been closed.");
            }
            final WrapperRunnable wrapperRunnable = new WrapperRunnable(runnable);
            this.executor().execute(wrapperRunnable);
            if (this.matt_ms > 0) {
                TimerTask timerTask = new TimerTask(){

                    @Override
                    public void run() {
                        wrapperRunnable.interrupt();
                    }
                };
                this.timer.schedule(timerTask, this.matt_ms);
            }
        }

        @Override
        public synchronized void close(boolean bl) {
            if (!this.is_closed) {
                block11: {
                    Object object;
                    Object object2;
                    if (bl) {
                        object2 = this.snapshotActives();
                        object = ((HashSet)object2).iterator();
                        while (object.hasNext()) {
                            Object e = object.next();
                            ((WrapperRunnable)e).interrupt();
                        }
                    }
                    if (AbstractExecutorTaskRunnerFactory.this.taskRunnerOwnsExecutor()) {
                        object2 = this.executor();
                        if (object2 instanceof ExecutorService) {
                            object = (ExecutorService)object2;
                            if (bl) {
                                object.shutdownNow();
                            } else {
                                object.shutdown();
                            }
                        } else if (object2 instanceof AutoCloseable) {
                            try {
                                ((AutoCloseable)object2).close();
                            }
                            catch (Exception exception) {
                                if (!logger.isLoggable(MLevel.WARNING)) break block11;
                                logger.log(MLevel.WARNING, "An Exception occurred while calling close() on an AutoCloaseable Executor.", exception);
                            }
                        }
                    }
                }
                this.is_closed = true;
            }
        }

        @Override
        public void close() {
            this.close(true);
        }

        @Override
        public int getThreadCount() {
            return -1;
        }

        @Override
        public int getActiveCount() {
            return this.activeCount();
        }

        @Override
        public int getIdleCount() {
            return -1;
        }

        @Override
        public int getPendingTaskCount() {
            return -1;
        }

        @Override
        public String getStatus() {
            int n = this.getThreadCount();
            int n2 = this.getActiveCount();
            int n3 = this.getIdleCount();
            int n4 = this.getPendingTaskCount();
            StringBuilder stringBuilder = new StringBuilder(1024);
            stringBuilder.append(this.getClass().getName());
            stringBuilder.append(" [ ");
            if (n >= 0) {
                stringBuilder.append("thread-count: " + n + "; ");
            }
            if (n2 >= 0) {
                stringBuilder.append("active-count: " + n2 + "; ");
            }
            if (n3 >= 0) {
                stringBuilder.append("idle-count: " + n3 + "; ");
            }
            if (n4 >= 0) {
                stringBuilder.append("pending-task-count: " + n4 + "; ");
            }
            stringBuilder.append(" ]");
            return stringBuilder.toString();
        }

        @Override
        public String getStackTraces() {
            StringBuilder stringBuilder = new StringBuilder(4096);
            HashSet hashSet = this.snapshotActives();
            int n = hashSet.size();
            stringBuilder.append("Threads found: " + n + SEP);
            for (Object e : hashSet) {
                WrapperRunnable wrapperRunnable = (WrapperRunnable)e;
                String string = wrapperRunnable.getCarrierName();
                StackTraceElement[] stackTraceElementArray = wrapperRunnable.getStackTrace();
                stringBuilder.append("Thread " + string + ":" + SEP);
                if (stackTraceElementArray.length == 0) {
                    stringBuilder.append("\t<unavailable>");
                    stringBuilder.append(SEP);
                    continue;
                }
                for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                    stringBuilder.append("\t");
                    stringBuilder.append(stackTraceElement.toString());
                    stringBuilder.append(SEP);
                }
            }
            return stringBuilder.toString();
        }

        private final class WrapperRunnable
        implements Runnable {
            Runnable inner;
            Thread carrier;

            private synchronized void setCarrier(Thread thread) {
                this.carrier = thread;
            }

            WrapperRunnable(Runnable runnable) {
                this.inner = runnable;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    boolean bl = Thread.interrupted();
                    AbstractExecutorAsynchronousRunner abstractExecutorAsynchronousRunner = AbstractExecutorAsynchronousRunner.this;
                    synchronized (abstractExecutorAsynchronousRunner) {
                        block18: {
                            if (!AbstractExecutorAsynchronousRunner.this.isClosed()) break block18;
                            return;
                        }
                        if (bl && logger.isLoggable(MLevel.WARNING)) {
                            logger.log(MLevel.WARNING, "Cleared an interrupt set on executor thread prior to task start.");
                        }
                        this.setCarrier(Thread.currentThread());
                        AbstractExecutorAsynchronousRunner.this.registerActive(this);
                    }
                    this.inner.run();
                }
                finally {
                    AbstractExecutorAsynchronousRunner abstractExecutorAsynchronousRunner = AbstractExecutorAsynchronousRunner.this;
                    synchronized (abstractExecutorAsynchronousRunner) {
                        AbstractExecutorAsynchronousRunner.this.unregisterActive(this);
                        this.setCarrier(null);
                    }
                }
            }

            public synchronized void interrupt() {
                if (this.carrier != null) {
                    this.carrier.interrupt();
                }
            }

            public synchronized StackTraceElement[] getStackTrace() {
                if (this.carrier != null) {
                    return this.carrier.getStackTrace();
                }
                return EMPTY_STACK_TRACES;
            }

            public synchronized String getCarrierName() {
                return this.carrier.getName();
            }
        }
    }
}

