/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.coverage.j2d;

import java.awt.image.RenderedImage;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;

public final class DeferredProperty {
    private Object value;
    private Function<RenderedImage, ?> provider;

    public DeferredProperty(Function<RenderedImage, ?> function) {
        this.provider = function;
    }

    final synchronized Object compute(RenderedImage renderedImage) {
        Function<RenderedImage, ?> function;
        if (this.value == null && (function = this.provider) != null) {
            this.provider = null;
            this.value = function.apply(renderedImage);
        }
        return this.value;
    }

    public static Map<String, Object> forGridGeometry(GridGeometry gridGeometry, int[] nArray) {
        return Collections.singletonMap("org.apache.sis.GridGeometry", new DeferredProperty(new ImageGeometry(gridGeometry, nArray)));
    }

    private static final class ImageGeometry
    implements Function<RenderedImage, GridGeometry> {
        private final GridGeometry grid;
        private final int dimX;
        private final int dimY;

        public ImageGeometry(GridGeometry gridGeometry, int[] nArray) {
            this.grid = gridGeometry;
            this.dimX = nArray[0];
            this.dimY = nArray[1];
        }

        @Override
        public GridGeometry apply(RenderedImage renderedImage) {
            GridExtent gridExtent = this.grid.getExtent();
            return this.grid.selectDimensions(this.dimX, this.dimY).shiftGrid(Math.subtractExact((long)renderedImage.getMinX(), gridExtent.getLow(this.dimX)), Math.subtractExact((long)renderedImage.getMinY(), gridExtent.getLow(this.dimY)));
        }
    }
}

