/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.feature.j2d;

import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.util.Collections;
import java.util.Iterator;
import org.apache.sis.internal.feature.j2d.FlatShape;
import org.apache.sis.internal.feature.j2d.Polygon;
import org.apache.sis.util.Classes;

class Polyline
extends FlatShape {
    private final float[] coordinates;
    private final AffineTransform inflate;

    Polyline(double[] dArray, int n) {
        super(dArray, n);
        this.coordinates = new float[n];
        double d = Polyline.round(this.bounds.getCenterX(), this.bounds.xmin, this.bounds.xmax);
        double d2 = Polyline.round(this.bounds.getCenterY(), this.bounds.ymin, this.bounds.ymax);
        this.inflate = AffineTransform.getTranslateInstance(d, d2);
        AffineTransform.getTranslateInstance(-d, -d2).transform(dArray, 0, this.coordinates, 0, n / 2);
    }

    private static double round(double d, double d2, double d3) {
        int n = Math.getExponent(Math.max(Math.abs(d2), Math.abs(d3))) - 20;
        return Math.scalb(Math.round(Math.scalb(d, -n)), n);
    }

    @Override
    public boolean contains(double d, double d2) {
        return this.bounds.contains(d, d2) && Path2D.contains(this.iterator(), d, d2);
    }

    @Override
    public boolean intersects(double d, double d2, double d3, double d4) {
        return this.bounds.intersects(d, d2, d3, d4) && Path2D.intersects(this.iterator(), d, d2, d3, d4);
    }

    @Override
    public boolean intersects(Rectangle2D rectangle2D) {
        return this.bounds.intersects(rectangle2D) && Path2D.intersects(this.iterator(), rectangle2D);
    }

    @Override
    public boolean contains(double d, double d2, double d3, double d4) {
        return this.bounds.contains(d, d2, d3, d4) && Path2D.contains(this.iterator(), d, d2, d3, d4);
    }

    @Override
    public boolean contains(Rectangle2D rectangle2D) {
        return this.bounds.contains(rectangle2D) && Path2D.contains(this.iterator(), rectangle2D);
    }

    private PathIterator iterator() {
        return this.getPathIterator(null);
    }

    @Override
    public final PathIterator getPathIterator(AffineTransform affineTransform) {
        return new Iter(affineTransform, this, Collections.emptyIterator());
    }

    public String toString() {
        return Classes.getShortClassName(this) + '[' + this.coordinates.length / 2 + " points]";
    }

    static final class Iter
    implements PathIterator {
        private final AffineTransform toUserSpace;
        private AffineTransform inflate;
        private final Iterator<Polyline> polylines;
        private float[] coordinates;
        private int position;
        private boolean closing;
        private boolean isPolygon;
        private boolean isDone;

        Iter() {
            this.toUserSpace = null;
            this.polylines = null;
            this.isDone = true;
        }

        Iter(AffineTransform affineTransform, Polyline polyline, Iterator<Polyline> iterator) {
            if (affineTransform != null) {
                this.inflate = new AffineTransform();
            }
            this.toUserSpace = affineTransform;
            this.polylines = iterator;
            this.setSource(polyline);
        }

        private void setSource(Polyline polyline) {
            this.isPolygon = polyline instanceof Polygon;
            this.coordinates = polyline.coordinates;
            if (this.toUserSpace != null) {
                this.inflate.setTransform(this.toUserSpace);
                this.inflate.concatenate(polyline.inflate);
            } else {
                this.inflate = polyline.inflate;
            }
        }

        @Override
        public int getWindingRule() {
            return 1;
        }

        @Override
        public boolean isDone() {
            return this.isDone;
        }

        @Override
        public void next() {
            if ((this.position += 2) >= this.coordinates.length) {
                if (this.isPolygon) {
                    boolean bl = this.closing = !this.closing;
                    if (this.closing) {
                        return;
                    }
                }
                if (this.polylines.hasNext()) {
                    this.setSource(this.polylines.next());
                    this.position = 0;
                } else {
                    this.isDone = true;
                }
            }
        }

        @Override
        public int currentSegment(float[] fArray) {
            if (this.closing) {
                return 4;
            }
            this.inflate.transform(this.coordinates, this.position, fArray, 0, 1);
            return this.position == 0 ? 0 : 1;
        }

        @Override
        public int currentSegment(double[] dArray) {
            if (this.closing) {
                return 4;
            }
            this.inflate.transform(this.coordinates, this.position, dArray, 0, 1);
            return this.position == 0 ? 0 : 1;
        }
    }
}

