/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.measure.IncommensurableException;
import javax.measure.UnitConverter;
import org.apache.sis.internal.jdk9.JDK9;
import org.apache.sis.internal.metadata.NameToIdentifier;
import org.apache.sis.internal.referencing.AxisDirections;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.internal.system.SystemListener;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.referencing.operation.AbstractCoordinateOperation;
import org.apache.sis.referencing.operation.DefaultCoordinateOperationFactory;
import org.apache.sis.referencing.operation.transform.DefaultMathTransformFactory;
import org.apache.sis.util.Deprecable;
import org.apache.sis.util.collection.Containers;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.RangeMeaning;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.OperationMethod;

public final class CoordinateOperations
extends SystemListener {
    public static final String BURSA_WOLF_KEY = "bursaWolf";
    public static final String PARAMETERS_KEY = "parameters";
    public static final String OPERATION_TYPE_KEY = "operationType";
    public static final ThreadLocal<Supplier<double[]>> CONSTANT_COORDINATES = new ThreadLocal();
    private static final Set<Integer>[] CACHE = new Set[11];
    private static volatile DefaultCoordinateOperationFactory factory;

    private CoordinateOperations() {
        super("org.apache.sis.referencing");
    }

    @Override
    protected void classpathChanged() {
        factory = null;
    }

    public static DefaultCoordinateOperationFactory factory() {
        DefaultCoordinateOperationFactory defaultCoordinateOperationFactory = factory;
        if (defaultCoordinateOperationFactory == null) {
            factory = defaultCoordinateOperationFactory = DefaultFactories.forBuildin(CoordinateOperationFactory.class, DefaultCoordinateOperationFactory.class);
        }
        return defaultCoordinateOperationFactory;
    }

    public static DefaultMathTransformFactory factoryMT() {
        return DefaultFactories.forBuildin(MathTransformFactory.class, DefaultMathTransformFactory.class);
    }

    public static CoordinateOperationFactory getCoordinateOperationFactory(Map<String, ?> map, MathTransformFactory mathTransformFactory, CRSFactory cRSFactory, CSFactory cSFactory) {
        if (Containers.isNullOrEmpty(map)) {
            if (DefaultFactories.isDefaultInstance(MathTransformFactory.class, mathTransformFactory) && DefaultFactories.isDefaultInstance(CRSFactory.class, cRSFactory) && DefaultFactories.isDefaultInstance(CSFactory.class, cSFactory)) {
                return CoordinateOperations.factory();
            }
            map = Collections.emptyMap();
        }
        HashMap hashMap = new HashMap(map);
        hashMap.putIfAbsent("crsFactory", cRSFactory);
        hashMap.putIfAbsent("csFactory", cSFactory);
        map = hashMap;
        return new DefaultCoordinateOperationFactory(map, mathTransformFactory);
    }

    public static OperationMethod getOperationMethod(Iterable<? extends OperationMethod> iterable, String string) {
        OperationMethod operationMethod = null;
        for (OperationMethod operationMethod2 : iterable) {
            if (!NameToIdentifier.isHeuristicMatchForName(operationMethod2, string) && !NameToIdentifier.isHeuristicMatchForIdentifier(operationMethod2.getIdentifiers(), string)) continue;
            if (!(operationMethod2 instanceof Deprecable) || !((Deprecable)((Object)operationMethod2)).isDeprecated()) {
                return operationMethod2;
            }
            if (operationMethod != null) continue;
            operationMethod = operationMethod2;
        }
        return operationMethod;
    }

    public static boolean isWrapAround(CoordinateSystemAxis coordinateSystemAxis) {
        return RangeMeaning.WRAPAROUND.equals(coordinateSystemAxis.getRangeMeaning());
    }

    public static Set<Integer> wrapAroundChanges(CoordinateOperation coordinateOperation) {
        CoordinateReferenceSystem coordinateReferenceSystem;
        CoordinateReferenceSystem coordinateReferenceSystem2;
        if (coordinateOperation instanceof AbstractCoordinateOperation) {
            return ((AbstractCoordinateOperation)coordinateOperation).getWrapAroundChanges();
        }
        if (coordinateOperation != null && (coordinateReferenceSystem2 = coordinateOperation.getSourceCRS()) != null && (coordinateReferenceSystem = coordinateOperation.getTargetCRS()) != null) {
            return CoordinateOperations.wrapAroundChanges(coordinateReferenceSystem2, coordinateReferenceSystem.getCoordinateSystem());
        }
        return Collections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Set<Integer> wrapAroundChanges(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateSystem coordinateSystem) {
        Set<Integer> set;
        boolean bl;
        long l = CoordinateOperations.changes(coordinateReferenceSystem.getCoordinateSystem(), coordinateSystem);
        while (coordinateReferenceSystem instanceof GeneralDerivedCRS) {
            coordinateReferenceSystem = ((GeneralDerivedCRS)coordinateReferenceSystem).getBaseCRS();
            l |= CoordinateOperations.changes(coordinateReferenceSystem.getCoordinateSystem(), coordinateSystem);
        }
        boolean bl2 = bl = l >= 0L && l < (long)CACHE.length;
        if (bl && (set = CACHE[(int)l]) != null) {
            return set;
        }
        long l2 = l;
        Integer[] integerArray = new Integer[Long.bitCount(l2)];
        for (int i = 0; i < integerArray.length; ++i) {
            int n = Long.numberOfTrailingZeros(l2);
            integerArray[i] = n;
            l2 &= 1L << n ^ 0xFFFFFFFFFFFFFFFFL;
        }
        Set<Integer> set2 = JDK9.setOf(integerArray);
        if (!bl) return set2;
        Set<Integer>[] setArray = CACHE;
        synchronized (CACHE) {
            Set<Integer> set3 = CACHE[(int)l];
            if (set3 != null) {
                // ** MonitorExit[var9_10] (shouldn't be in output)
                return set3;
            }
            CoordinateOperations.CACHE[(int)l] = set2;
            // ** MonitorExit[var9_10] (shouldn't be in output)
            return set2;
        }
    }

    private static long changes(CoordinateSystem coordinateSystem, CoordinateSystem coordinateSystem2) {
        long l = 0L;
        if (coordinateSystem != coordinateSystem2) {
            long l2 = (1 << coordinateSystem.getDimension()) - 1;
            int n = Math.min(64, coordinateSystem2.getDimension());
            block2: for (int i = 0; i < n; ++i) {
                long l3;
                CoordinateSystemAxis coordinateSystemAxis = coordinateSystem2.getAxis(i);
                if (!CoordinateOperations.isWrapAround(coordinateSystemAxis)) continue;
                long l4 = l2;
                do {
                    CoordinateSystemAxis coordinateSystemAxis2;
                    if (!AxisDirections.isColinear((coordinateSystemAxis2 = coordinateSystem.getAxis(Long.numberOfTrailingZeros(l3 = Long.lowestOneBit(l4)))).getDirection(), coordinateSystemAxis.getDirection())) continue;
                    try {
                        UnitConverter unitConverter = coordinateSystemAxis2.getUnit().getConverterToAny(coordinateSystemAxis.getUnit());
                        double d = coordinateSystemAxis.getMinimumValue();
                        double d2 = coordinateSystemAxis.getMaximumValue();
                        double d3 = (d2 - d) * 1.0E-13;
                        if (!Numerics.epsilonEqual(unitConverter.convert(coordinateSystemAxis2.getMinimumValue()), d, d3) || !Numerics.epsilonEqual(unitConverter.convert(coordinateSystemAxis2.getMaximumValue()), d2, d3)) {
                            l |= (long)(1 << i);
                        }
                        if ((l2 &= l3 ^ 0xFFFFFFFFFFFFFFFFL) != 0L) continue block2;
                        break block2;
                    }
                    catch (IncommensurableException incommensurableException) {
                        // empty catch block
                    }
                } while ((l4 &= l3 ^ 0xFFFFFFFFFFFFFFFFL) != 0L);
            }
        }
        return l;
    }

    static {
        CoordinateOperations.add(new CoordinateOperations());
    }
}

