/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.image;

import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriter;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.FileImageOutputStream;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import org.apache.sis.internal.storage.image.FormatFilter;
import org.apache.sis.internal.storage.image.WorldFileStoreProvider;
import org.apache.sis.internal.storage.io.IOUtilities;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.StorageConnector;

final class FormatFinder
implements AutoCloseable {
    final WorldFileStoreProvider provider;
    final StorageConnector connector;
    Object keepOpen;
    final Object storage;
    private ImageReader reader;
    private ImageWriter writer;
    private boolean readerLookupDone;
    private boolean writerLookupDone;
    final boolean isWritable;
    final boolean openAsWriter;
    final boolean fileIsEmpty;
    final String suffix;

    FormatFinder(WorldFileStoreProvider worldFileStoreProvider, StorageConnector storageConnector) throws DataStoreException, IOException {
        this.provider = worldFileStoreProvider;
        this.connector = storageConnector;
        Object object = storageConnector.getStorage();
        if (object instanceof ImageReader) {
            this.reader = (ImageReader)object;
            object = this.reader.getInput();
            this.readerLookupDone = true;
        } else if (object instanceof ImageWriter) {
            this.writer = (ImageWriter)object;
            object = this.writer.getOutput();
            this.writerLookupDone = true;
        }
        this.storage = object;
        this.suffix = IOUtilities.extension(object);
        if (this.writer != null) {
            this.isWritable = true;
            this.openAsWriter = true;
            this.fileIsEmpty = false;
        } else if (this.reader != null) {
            this.isWritable = this.reader.getInput() instanceof DataOutput;
            this.openAsWriter = false;
            this.fileIsEmpty = false;
        } else {
            Path path;
            this.isWritable = WorldFileStoreProvider.isWritable(storageConnector);
            if (this.isWritable && (path = storageConnector.getStorageAs(Path.class)) != null) {
                this.openAsWriter = this.fileIsEmpty = !Files.exists(path, new LinkOption[0]) || Files.size(path) == 0L;
                return;
            }
            this.openAsWriter = false;
            this.fileIsEmpty = false;
        }
    }

    final String[] getFormatName() throws DataStoreException, IOException {
        if (this.openAsWriter) {
            ImageWriterSpi imageWriterSpi;
            ImageWriter imageWriter = this.getOrCreateWriter();
            if (imageWriter != null && (imageWriterSpi = imageWriter.getOriginatingProvider()) != null) {
                return imageWriterSpi.getFormatNames();
            }
        } else {
            ImageReaderSpi imageReaderSpi;
            ImageReader imageReader = this.getOrCreateReader();
            if (imageReader != null && (imageReaderSpi = imageReader.getOriginatingProvider()) != null) {
                return imageReaderSpi.getFormatNames();
            }
        }
        return null;
    }

    final ImageReader getOrCreateReader() throws DataStoreException, IOException {
        if (!this.readerLookupDone) {
            this.readerLookupDone = true;
            LinkedHashMap<ImageReaderSpi, Boolean> linkedHashMap = new LinkedHashMap<ImageReaderSpi, Boolean>();
            if (this.suffix != null) {
                this.reader = FormatFilter.SUFFIX.createReader(this.suffix, this, linkedHashMap);
            }
            if (this.reader == null) {
                this.reader = FormatFilter.SUFFIX.createReader(null, this, linkedHashMap);
                if (this.reader == null) {
                    ImageInputStream imageInputStream = null;
                    for (Map.Entry entry : linkedHashMap.entrySet()) {
                        ImageReaderSpi imageReaderSpi;
                        if (!((Boolean)entry.getValue()).booleanValue()) continue;
                        if (imageInputStream == null) {
                            try {
                                if (this.isWritable) {
                                    imageInputStream = ImageIO.createImageOutputStream(this.storage);
                                }
                                if (imageInputStream == null && (imageInputStream = ImageIO.createImageInputStream(this.storage)) == null) {
                                    break;
                                }
                            }
                            catch (IIOException iIOException) {
                                throw FormatFinder.unwrap(iIOException);
                            }
                        }
                        if (!(imageReaderSpi = (ImageReaderSpi)entry.getKey()).canDecodeInput(imageInputStream)) continue;
                        this.reader = imageReaderSpi.createReaderInstance();
                        this.reader.setInput(imageInputStream);
                        this.keepOpen = this.storage;
                        break;
                    }
                }
            }
        }
        return this.reader;
    }

    final ImageWriter getOrCreateWriter() throws DataStoreException, IOException {
        if (!this.writerLookupDone) {
            this.writerLookupDone = true;
            LinkedHashMap<ImageWriterSpi, Boolean> linkedHashMap = new LinkedHashMap<ImageWriterSpi, Boolean>();
            if (this.suffix != null) {
                this.writer = FormatFilter.SUFFIX.createWriter(this.suffix, this, null, linkedHashMap);
            }
            if (this.writer == null) {
                this.writer = FormatFilter.SUFFIX.createWriter(null, this, null, linkedHashMap);
                if (this.writer == null) {
                    ImageOutputStream imageOutputStream = null;
                    for (Map.Entry entry : linkedHashMap.entrySet()) {
                        Object object;
                        if (!((Boolean)entry.getValue()).booleanValue()) continue;
                        if (imageOutputStream == null) {
                            object = this.connector.getStorageAs(File.class);
                            if (object != null) {
                                imageOutputStream = new FileImageOutputStream((File)object);
                            } else {
                                try {
                                    imageOutputStream = ImageIO.createImageOutputStream(this.storage);
                                    if (imageOutputStream == null) {
                                        break;
                                    }
                                }
                                catch (IIOException iIOException) {
                                    throw FormatFinder.unwrap(iIOException);
                                }
                            }
                        }
                        object = (ImageWriterSpi)entry.getKey();
                        this.writer = ((ImageWriterSpi)object).createWriterInstance();
                        this.writer.setOutput(imageOutputStream);
                        this.keepOpen = this.storage;
                        break;
                    }
                }
            }
        }
        return this.writer;
    }

    private static IOException unwrap(IIOException iIOException) {
        Throwable throwable = iIOException.getCause();
        return throwable instanceof IOException ? (IOException)throwable : iIOException;
    }

    @Override
    public final void close() throws DataStoreException {
        this.connector.closeAllExcept(this.keepOpen);
    }
}

