/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.measure;

import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.measure.Dimension;
import org.apache.sis.internal.converter.FractionConverter;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.math.Fraction;
import org.apache.sis.measure.UnitFormat;
import org.apache.sis.measure.UnitRegistry;
import org.apache.sis.measure.Units;
import org.apache.sis.util.ObjectConverters;
import org.apache.sis.util.UnsupportedImplementationException;
import org.apache.sis.util.resources.Errors;

final class UnitDimension
implements Dimension,
Serializable {
    private static final long serialVersionUID = 2568769237612674235L;
    static final UnitDimension NONE = new UnitDimension(Collections.emptyMap());
    final Map<UnitDimension, Fraction> components;
    final char symbol;

    UnitDimension(char c) {
        this.symbol = c;
        this.components = Collections.singletonMap(this, new Fraction(1, 1).unique());
        UnitRegistry.init(this.components, this);
    }

    private UnitDimension(Map<UnitDimension, Fraction> map) {
        this.components = map;
        this.symbol = '\u0000';
    }

    private static UnitDimension create(Map<UnitDimension, Fraction> map) {
        Serializable serializable;
        Object object;
        switch (map.size()) {
            case 0: {
                return NONE;
            }
            case 1: {
                object = map.entrySet().iterator().next();
                serializable = (Fraction)object.getValue();
                if (serializable.numerator != 1 || serializable.denominator != 1) break;
                return (UnitDimension)object.getKey();
            }
        }
        object = (UnitDimension)UnitRegistry.get(map);
        if (object == null) {
            map.replaceAll((unitDimension, fraction) -> fraction.unique());
            map = CollectionsExt.unmodifiableOrCopy(map);
            object = new UnitDimension(map);
            if (!Units.initialized) {
                UnitRegistry.init(map, (UnitDimension)object);
            } else {
                serializable = (UnitDimension)UnitRegistry.putIfAbsent(map, object);
                if (serializable != null) {
                    return serializable;
                }
            }
        }
        return object;
    }

    Object readResolve() throws ObjectStreamException {
        UnitDimension unitDimension;
        if (this.isDimensionless()) {
            return NONE;
        }
        if (Units.initialized && (unitDimension = (UnitDimension)UnitRegistry.putIfAbsent(this.components, this)) != null) {
            return unitDimension;
        }
        return this;
    }

    final boolean isDimensionless() {
        return this.components.isEmpty();
    }

    static boolean isDimensionless(Dimension dimension) {
        Map<? extends Dimension, Integer> map;
        if (dimension instanceof UnitDimension) {
            return ((UnitDimension)dimension).isDimensionless();
        }
        if (dimension != null && (map = dimension.getBaseDimensions()) != null) {
            return map.isEmpty();
        }
        return false;
    }

    final boolean numeratorIs(char c) {
        if (this.symbol == c) {
            assert (this.components.keySet().equals(Collections.singleton(this)));
            return true;
        }
        boolean bl = false;
        for (Map.Entry<UnitDimension, Fraction> entry : this.components.entrySet()) {
            Fraction fraction = entry.getValue();
            if (entry.getKey().symbol == c) {
                if (fraction.numerator != fraction.denominator) {
                    return false;
                }
                bl = true;
                continue;
            }
            if (fraction.signum() < 0) continue;
            return false;
        }
        return bl;
    }

    public Map<UnitDimension, Integer> getBaseDimensions() {
        if (this.symbol != '\u0000') {
            return null;
        }
        return ObjectConverters.derivedValues(this.components, UnitDimension.class, FractionConverter.INSTANCE);
    }

    private static Map<? extends Dimension, Fraction> getBaseDimensions(Dimension dimension) {
        if (dimension instanceof UnitDimension) {
            return ((UnitDimension)dimension).components;
        }
        Map<? extends Dimension, Integer> map = dimension.getBaseDimensions();
        if (map == null) {
            return Collections.singletonMap(dimension, new Fraction(1, 1));
        }
        return ObjectConverters.derivedValues(map, Dimension.class, FractionConverter.FromInteger.INSTANCE);
    }

    @Override
    public UnitDimension multiply(Dimension dimension) {
        return this.combine(dimension, false);
    }

    @Override
    public UnitDimension divide(Dimension dimension) {
        return this.combine(dimension, true);
    }

    private UnitDimension combine(Dimension dimension, boolean bl) {
        LinkedHashMap<UnitDimension, Fraction> linkedHashMap = new LinkedHashMap<UnitDimension, Fraction>(this.components);
        for (Map.Entry<? extends Dimension, Fraction> entry : UnitDimension.getBaseDimensions(dimension).entrySet()) {
            Dimension dimension2 = entry.getKey();
            Fraction fraction3 = entry.getValue();
            if (bl) {
                fraction3 = fraction3.negate();
            }
            if (dimension2 instanceof UnitDimension) {
                linkedHashMap.merge((UnitDimension)dimension2, fraction3, (fraction, fraction2) -> {
                    fraction = fraction.add((Fraction)fraction2);
                    return fraction.numerator != 0 ? fraction : null;
                });
                continue;
            }
            if (fraction3.numerator == 0) continue;
            throw new UnsupportedImplementationException(Errors.format((short)160, dimension2.getClass()));
        }
        return UnitDimension.create(linkedHashMap);
    }

    private UnitDimension pow(Fraction fraction) {
        LinkedHashMap<UnitDimension, Fraction> linkedHashMap = new LinkedHashMap<UnitDimension, Fraction>(this.components);
        linkedHashMap.replaceAll((unitDimension, fraction2) -> fraction2.multiply(fraction));
        return UnitDimension.create(linkedHashMap);
    }

    @Override
    public UnitDimension pow(int n) {
        switch (n) {
            case 0: {
                return NONE;
            }
            case 1: {
                return this;
            }
        }
        return this.pow(new Fraction(n, 1));
    }

    @Override
    public UnitDimension root(int n) {
        switch (n) {
            case 0: {
                throw new ArithmeticException(Errors.format((short)45, "n", 0));
            }
            case 1: {
                return this;
            }
        }
        return this.pow(new Fraction(1, n));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof UnitDimension) {
            UnitDimension unitDimension = (UnitDimension)object;
            if (this.symbol == unitDimension.symbol) {
                return this.symbol != '\u0000' || this.components.equals(unitDimension.components);
            }
        }
        return false;
    }

    public int hashCode() {
        return this.symbol != '\u0000' ? this.symbol ^ 0xFDDABCBB : this.components.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(8);
        try {
            UnitFormat.formatComponents(this.components, UnitFormat.Style.SYMBOL, stringBuilder);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return stringBuilder.toString();
    }
}

