/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.distribution;

import java.net.URI;
import java.util.Collection;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.sis.internal.jaxb.FilterByVersion;
import org.apache.sis.internal.jaxb.gcx.MimeFileTypeAdapter;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.metadata.distribution.DataFile;
import org.opengis.metadata.distribution.Format;
import org.opengis.util.InternationalString;
import org.opengis.util.LocalName;

@XmlType(name="MX_DataFile_Type", namespace="http://standards.iso.org/iso/19115/-3/mdt/1.0", propOrder={"fileName", "fileDescription", "fileType", "featureTypes", "fileFormat"})
@XmlRootElement(name="MX_DataFile", namespace="http://standards.iso.org/iso/19115/-3/mdt/1.0")
public class DefaultDataFile
extends ISOMetadata
implements DataFile {
    private static final long serialVersionUID = -4556006719009557349L;
    private URI fileName;
    private InternationalString fileDescription;
    private String fileType;
    private Collection<LocalName> featureTypes;
    @Deprecated
    private Format fileFormat;

    public DefaultDataFile() {
    }

    public DefaultDataFile(DataFile dataFile) {
        super(dataFile);
        if (dataFile != null) {
            if (dataFile instanceof DefaultDataFile) {
                DefaultDataFile defaultDataFile = (DefaultDataFile)dataFile;
                this.fileName = defaultDataFile.getFileName();
                this.fileDescription = defaultDataFile.getFileDescription();
                this.fileType = defaultDataFile.getFileType();
            }
            this.featureTypes = this.copyCollection(dataFile.getFeatureTypes(), LocalName.class);
            this.fileFormat = dataFile.getFileFormat();
        }
    }

    public static DefaultDataFile castOrCopy(DataFile dataFile) {
        if (dataFile == null || dataFile instanceof DefaultDataFile) {
            return (DefaultDataFile)dataFile;
        }
        return new DefaultDataFile(dataFile);
    }

    @XmlElement(name="fileName", required=true)
    public URI getFileName() {
        return this.fileName;
    }

    public void setFileName(URI uRI) {
        this.checkWritePermission(this.fileName);
        this.fileName = uRI;
    }

    @XmlElement(name="fileDescription", required=true)
    public InternationalString getFileDescription() {
        return this.fileDescription;
    }

    public void setFileDescription(InternationalString internationalString) {
        this.checkWritePermission(this.fileDescription);
        this.fileDescription = internationalString;
    }

    @XmlElement(name="fileType", required=true)
    @XmlJavaTypeAdapter(value=MimeFileTypeAdapter.class)
    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String string) {
        this.checkWritePermission(this.fileType);
        this.fileType = string;
    }

    @XmlElement(name="featureTypes")
    public Collection<LocalName> getFeatureTypes() {
        this.featureTypes = this.nonNullCollection(this.featureTypes, LocalName.class);
        return this.featureTypes;
    }

    public void setFeatureTypes(Collection<? extends LocalName> collection) {
        this.featureTypes = this.writeCollection(collection, this.featureTypes, LocalName.class);
    }

    @Override
    @Deprecated
    @XmlElement(name="fileFormat", namespace="http://www.isotc211.org/2005/gmx")
    public Format getFileFormat() {
        return FilterByVersion.LEGACY_METADATA.accept() ? this.fileFormat : null;
    }

    @Deprecated
    public void setFileFormat(Format format) {
        this.checkWritePermission(this.fileFormat);
        this.fileFormat = format;
    }
}

