/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.maintenance;

import java.util.Collection;
import java.util.Set;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.metadata.ExcludedSet;
import org.apache.sis.internal.system.Semaphores;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.metadata.iso.maintenance.LegacyFeatureType;
import org.apache.sis.util.collection.CheckedContainer;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.resources.Messages;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.FeatureType;
import org.opengis.metadata.maintenance.ScopeCode;
import org.opengis.metadata.maintenance.ScopeDescription;

@XmlType(name="MD_ScopeDescription_Type", namespace="http://standards.iso.org/iso/19115/-3/mcc/1.0")
@XmlRootElement(name="MD_ScopeDescription", namespace="http://standards.iso.org/iso/19115/-3/mcc/1.0")
public class DefaultScopeDescription
extends ISOMetadata
implements ScopeDescription {
    private static final long serialVersionUID = -2029119689389845656L;
    private static final byte DATASET = 1;
    private static final byte FEATURES = 2;
    private static final byte ATTRIBUTES = 3;
    private static final byte FEATURE_INSTANCES = 4;
    private static final byte ATTRIBUTE_INSTANCES = 5;
    private static final byte OTHER = 6;
    private static final String[] NAMES = new String[]{"dataset", "features", "attributes", "featureInstances", "attributeInstances", "other"};
    private static final String[] SETTERS = new String[]{"setDataset", "setFeatures", "setAttributes", "setFeatureInstances", "setAttributeInstances", "setOther"};
    private byte property;
    private Object value;

    public DefaultScopeDescription() {
    }

    public DefaultScopeDescription(ScopeDescription scopeDescription) {
        super(scopeDescription);
        if (scopeDescription != null) {
            for (int n = 1; n <= 6; n = (int)((byte)(n + 1))) {
                Set<Object> set;
                switch (n) {
                    case 1: {
                        set = scopeDescription.getDataset();
                        break;
                    }
                    case 2: {
                        set = scopeDescription.getFeatures();
                        break;
                    }
                    case 3: {
                        set = scopeDescription.getAttributes();
                        break;
                    }
                    case 4: {
                        set = scopeDescription.getFeatureInstances();
                        break;
                    }
                    case 5: {
                        set = scopeDescription.getAttributeInstances();
                        break;
                    }
                    case 6: {
                        set = scopeDescription.getOther();
                        break;
                    }
                    default: {
                        throw new AssertionError(n);
                    }
                }
                if (set == null) continue;
                switch (n) {
                    case 3: 
                    case 5: {
                        set = this.copySet((Collection)set, AttributeType.class);
                        break;
                    }
                    case 2: 
                    case 4: {
                        set = this.copySet((Collection)set, FeatureType.class);
                    }
                }
                this.value = set;
                this.property = (byte)n;
                break;
            }
        }
    }

    public static DefaultScopeDescription castOrCopy(ScopeDescription scopeDescription) {
        if (scopeDescription == null || scopeDescription instanceof DefaultScopeDescription) {
            return (DefaultScopeDescription)scopeDescription;
        }
        return new DefaultScopeDescription(scopeDescription);
    }

    private static <E> Set<E> cast(Object object, Class<E> clazz) {
        assert (!(object instanceof CheckedContainer) || ((CheckedContainer)object).getElementType() == clazz);
        return (Set)object;
    }

    private <E> Set<E> getProperty(Class<E> clazz, byte by) {
        Object object = this.value;
        if (object != null) {
            if (this.property == by) {
                return DefaultScopeDescription.cast(object, clazz);
            }
            if (!(object instanceof Set) || !((Set)object).isEmpty()) {
                return Semaphores.query(1) ? null : new ExcludedSet(NAMES[by - 1], NAMES[this.property - 1]);
            }
        }
        Set<E> set = this.nonNullSet(null, clazz);
        this.property = by;
        this.value = set;
        return set;
    }

    private <E> void setProperty(Set<? extends E> set, Class<E> clazz, byte by) {
        Set<E> set2 = null;
        if (this.property == by) {
            set2 = DefaultScopeDescription.cast(this.value, clazz);
        } else {
            if (Containers.isNullOrEmpty(set)) {
                return;
            }
            this.warningOnOverwrite(by);
            this.property = by;
        }
        this.value = this.writeSet(set, set2, clazz);
    }

    private void warningOnOverwrite(byte by) {
        if (this.value != null && this.property != by) {
            Context.warningOccured(Context.current(), DefaultScopeDescription.class, SETTERS[by - 1], Messages.class, (short)19, NAMES[this.property - 1], NAMES[by - 1]);
        }
    }

    public ScopeCode getLevel() {
        switch (this.property) {
            case 1: {
                return ScopeCode.DATASET;
            }
            case 2: {
                return ScopeCode.FEATURE_TYPE;
            }
            case 3: {
                return ScopeCode.ATTRIBUTE_TYPE;
            }
            case 4: {
                return ScopeCode.FEATURE;
            }
            case 5: {
                return ScopeCode.ATTRIBUTE;
            }
        }
        return null;
    }

    @Override
    @XmlElement(name="dataset")
    public String getDataset() {
        return this.property == 1 ? (String)this.value : null;
    }

    public void setDataset(String string) {
        this.checkWritePermission(this.value);
        if (string != null || this.property == 1) {
            this.warningOnOverwrite((byte)1);
            this.property = 1;
            this.value = string;
        }
    }

    @XmlElement(name="features")
    public Set<FeatureType> getFeatures() {
        return this.getProperty(FeatureType.class, (byte)2);
    }

    public void setFeatures(Set<? extends FeatureType> set) {
        this.setProperty(set, FeatureType.class, (byte)2);
    }

    @XmlElement(name="attributes")
    public Set<AttributeType> getAttributes() {
        return this.getProperty(AttributeType.class, (byte)3);
    }

    public void setAttributes(Set<? extends AttributeType> set) {
        this.setProperty(set, AttributeType.class, (byte)3);
    }

    @XmlElement(name="featureInstances")
    public Set<FeatureType> getFeatureInstances() {
        return this.getProperty(FeatureType.class, (byte)4);
    }

    public void setFeatureInstances(Set<? extends FeatureType> set) {
        this.setProperty(set, FeatureType.class, (byte)4);
    }

    @XmlElement(name="attributeInstances")
    public Set<AttributeType> getAttributeInstances() {
        return this.getProperty(AttributeType.class, (byte)5);
    }

    public void setAttributeInstances(Set<? extends AttributeType> set) {
        this.setProperty(set, AttributeType.class, (byte)5);
    }

    @Override
    @XmlElement(name="other")
    public String getOther() {
        return this.property == 6 ? (String)this.value : null;
    }

    public void setOther(String string) {
        this.checkWritePermission(this.value);
        if (string != null || this.property == 6) {
            this.warningOnOverwrite((byte)6);
            this.property = (byte)6;
            this.value = string;
        }
    }

    public void setLevelDescription(ScopeCode scopeCode, Set<? extends CharSequence> set) {
        if (ScopeCode.DATASET.equals(scopeCode)) {
            String string = null;
            if (set != null) {
                for (CharSequence charSequence : set) {
                    if (charSequence == null) continue;
                    string = charSequence.toString();
                    break;
                }
            }
            this.setDataset(string);
        } else if (ScopeCode.FEATURE_TYPE.equals(scopeCode)) {
            this.setFeatures(LegacyFeatureType.wrapAll(set));
        } else if (ScopeCode.ATTRIBUTE_TYPE.equals(scopeCode)) {
            this.setAttributes(LegacyFeatureType.wrapAll(set));
        } else if (ScopeCode.FEATURE.equals(scopeCode)) {
            this.setFeatureInstances(LegacyFeatureType.wrapAll(set));
        } else if (ScopeCode.ATTRIBUTE.equals(scopeCode)) {
            this.setAttributeInstances(LegacyFeatureType.wrapAll(set));
        } else {
            String string = null;
            if (set != null) {
                for (CharSequence charSequence : set) {
                    if (charSequence == null) continue;
                    string = charSequence.toString();
                    break;
                }
            }
            this.setOther(string);
        }
    }
}

