/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.ServiceLoader;
import java.util.Set;
import javax.measure.Unit;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.internal.referencing.provider.TransverseMercator;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.internal.system.Fallback;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.StandardDefinitions;
import org.apache.sis.referencing.factory.GeodeticAuthorityFactory;
import org.apache.sis.setup.InstallationResources;
import org.apache.sis.util.CharSequences;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.VerticalDatum;

@Fallback
final class EPSGFactoryFallback
extends GeodeticAuthorityFactory
implements CRSAuthorityFactory,
CSAuthorityFactory,
DatumAuthorityFactory {
    static final boolean FORCE_HARDCODED = false;
    static final EPSGFactoryFallback INSTANCE = new EPSGFactoryFallback();
    private String installationURL;
    private static final int CRS = 1;
    private static final int DATUM = 2;
    private static final int ELLIPSOID = 4;
    private static final int PRIME_MERIDIAN = 8;
    private static final int UNIT = 16;
    private static final int AXIS = 32;
    private static final int CS = 64;

    private EPSGFactoryFallback() {
    }

    @Override
    public Citation getAuthority() {
        return StandardDefinitions.AUTHORITY;
    }

    private String getAuthorityTitle() {
        return this.getAuthority().getTitle().toString();
    }

    @Override
    public Set<String> getCodeSpaces() {
        return Collections.singleton("EPSG");
    }

    @Override
    public Set<String> getAuthorityCodes(Class<? extends IdentifiedObject> clazz) {
        boolean bl = clazz.isAssignableFrom(PrimeMeridian.class);
        boolean bl2 = clazz.isAssignableFrom(Ellipsoid.class);
        boolean bl3 = clazz.isAssignableFrom(GeodeticDatum.class);
        boolean bl4 = clazz.isAssignableFrom(GeographicCRS.class);
        boolean bl5 = clazz.isAssignableFrom(GeocentricCRS.class);
        boolean bl6 = clazz.isAssignableFrom(ProjectedCRS.class);
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        if (bl) {
            linkedHashSet.add("8901");
        }
        for (CommonCRS commonCRS : CommonCRS.values()) {
            if (bl2) {
                EPSGFactoryFallback.add(linkedHashSet, commonCRS.ellipsoid);
            }
            if (bl3) {
                EPSGFactoryFallback.add(linkedHashSet, commonCRS.datum);
            }
            if (bl5) {
                EPSGFactoryFallback.add(linkedHashSet, commonCRS.geocentric);
            }
            if (bl4) {
                EPSGFactoryFallback.add(linkedHashSet, commonCRS.geographic);
                EPSGFactoryFallback.add(linkedHashSet, commonCRS.geo3D);
            }
            if (!bl6) continue;
            EPSGFactoryFallback.add(linkedHashSet, commonCRS.northUPS);
            EPSGFactoryFallback.add(linkedHashSet, commonCRS.southUPS);
            if (commonCRS.northUTM == 0 && commonCRS.southUTM == 0) continue;
            for (int i = (int)commonCRS.firstZone; i <= commonCRS.lastZone; ++i) {
                if (commonCRS.northUTM != 0) {
                    linkedHashSet.add(Integer.toString(commonCRS.northUTM + i));
                }
                if (commonCRS.southUTM == 0) continue;
                linkedHashSet.add(Integer.toString(commonCRS.southUTM + i));
            }
        }
        boolean bl7 = clazz.isAssignableFrom(VerticalCRS.class);
        int n = clazz.isAssignableFrom(VerticalDatum.class) ? 1 : 0;
        if (bl7 || n != 0) {
            for (CommonCRS.Vertical vertical : CommonCRS.Vertical.values()) {
                if (!vertical.isEPSG) continue;
                if (bl7) {
                    EPSGFactoryFallback.add(linkedHashSet, vertical.crs);
                }
                if (n == 0) continue;
                EPSGFactoryFallback.add(linkedHashSet, vertical.datum);
            }
        }
        if (clazz.isAssignableFrom(EllipsoidalCS.class)) {
            EPSGFactoryFallback.add(linkedHashSet, (short)6422);
            EPSGFactoryFallback.add(linkedHashSet, (short)6423);
        }
        if (clazz.isAssignableFrom(SphericalCS.class)) {
            EPSGFactoryFallback.add(linkedHashSet, (short)6404);
        }
        if (clazz.isAssignableFrom(CartesianCS.class)) {
            EPSGFactoryFallback.add(linkedHashSet, (short)6500);
            EPSGFactoryFallback.add(linkedHashSet, (short)4400);
            EPSGFactoryFallback.add(linkedHashSet, (short)1026);
            EPSGFactoryFallback.add(linkedHashSet, (short)1027);
        }
        if (clazz.isAssignableFrom(Unit.class)) {
            EPSGFactoryFallback.add(linkedHashSet, (short)9001);
            EPSGFactoryFallback.add(linkedHashSet, (short)9122);
        }
        return linkedHashSet;
    }

    private static void add(Set<String> set, short s) {
        if (s != 0) {
            set.add(Short.toString(s));
        }
    }

    @Override
    public PrimeMeridian createPrimeMeridian(String string) throws NoSuchAuthorityCodeException {
        return (PrimeMeridian)this.predefined(string, 8);
    }

    @Override
    public Ellipsoid createEllipsoid(String string) throws NoSuchAuthorityCodeException {
        return (Ellipsoid)this.predefined(string, 4);
    }

    @Override
    public Datum createDatum(String string) throws NoSuchAuthorityCodeException {
        return (Datum)this.predefined(string, 2);
    }

    @Override
    public CoordinateReferenceSystem createCoordinateReferenceSystem(String string) throws NoSuchAuthorityCodeException {
        return (CoordinateReferenceSystem)this.predefined(string, 1);
    }

    @Override
    public CoordinateSystem createCoordinateSystem(String string) throws NoSuchAuthorityCodeException {
        return (CoordinateSystem)this.predefined(string, 64);
    }

    @Override
    public CoordinateSystemAxis createCoordinateSystemAxis(String string) throws NoSuchAuthorityCodeException {
        return (CoordinateSystemAxis)this.predefined(string, 32);
    }

    @Override
    public Unit<?> createUnit(String string) throws NoSuchAuthorityCodeException {
        return (Unit)this.predefined(string, 16);
    }

    @Override
    public IdentifiedObject createObject(String string) throws NoSuchAuthorityCodeException {
        return (IdentifiedObject)this.predefined(string, -17);
    }

    private Object predefined(String string, int n) throws NoSuchAuthorityCodeException {
        try {
            Object object;
            string = CharSequences.trimWhitespaces(string, string.lastIndexOf(58) + 1, string.length()).toString();
            short s = Short.parseShort(string);
            if ((n & 7) != 0) {
                CommonCRS commonCRS;
                int n2;
                object = CommonCRS.values();
                int n3 = ((CommonCRS[])object).length;
                for (n2 = 0; n2 < n3; ++n2) {
                    double d;
                    int n4;
                    commonCRS = object[n2];
                    if ((n & 4) != 0 && s == commonCRS.ellipsoid) {
                        return commonCRS.ellipsoid();
                    }
                    if ((n & 2) != 0 && s == commonCRS.datum) {
                        return commonCRS.datum();
                    }
                    if ((n & 1) == 0) continue;
                    if (s == commonCRS.geographic) {
                        return commonCRS.geographic();
                    }
                    if (s == commonCRS.geocentric) {
                        return commonCRS.geocentric();
                    }
                    if (s == commonCRS.geo3D) {
                        return commonCRS.geographic3D();
                    }
                    if (commonCRS.northUTM != 0 && (n4 = s - commonCRS.northUTM) >= commonCRS.firstZone && n4 <= commonCRS.lastZone) {
                        d = 1.0;
                    } else if (commonCRS.southUTM != 0 && (n4 = s - commonCRS.southUTM) >= commonCRS.firstZone && n4 <= commonCRS.lastZone) {
                        d = -1.0;
                    } else if (s == commonCRS.northUPS) {
                        d = 90.0;
                        n4 = 30;
                    } else {
                        if (s != commonCRS.southUPS) continue;
                        d = -90.0;
                        n4 = 30;
                    }
                    return commonCRS.universal(d, TransverseMercator.Zoner.UTM.centralMeridian(n4));
                }
                if ((n & 3) != 0) {
                    object = CommonCRS.Vertical.values();
                    n3 = ((CommonCRS[])object).length;
                    for (n2 = 0; n2 < n3; ++n2) {
                        commonCRS = object[n2];
                        if (!((CommonCRS.Vertical)((Object)commonCRS)).isEPSG) continue;
                        if ((n & 2) != 0 && ((CommonCRS.Vertical)((Object)commonCRS)).datum == s) {
                            return ((CommonCRS.Vertical)((Object)commonCRS)).datum();
                        }
                        if ((n & 1) == 0 || ((CommonCRS.Vertical)((Object)commonCRS)).crs != s) continue;
                        return ((CommonCRS.Vertical)((Object)commonCRS)).crs();
                    }
                }
            }
            if ((n & 8) != 0 && s == 8901) {
                return CommonCRS.WGS84.primeMeridian();
            }
            if ((n & 0x40) != 0 && (object = StandardDefinitions.createCoordinateSystem(s, false)) != null) {
                return object;
            }
            if ((n & 0x20) != 0 && (object = StandardDefinitions.createAxis(s, false)) != null) {
                return object;
            }
            if ((n & 0x10) != 0 && (object = Units.valueOfEPSG(s)) != null) {
                return object;
            }
        }
        catch (NumberFormatException numberFormatException) {
            NoSuchAuthorityCodeException noSuchAuthorityCodeException = new NoSuchAuthorityCodeException(Resources.format((short)49, "EPSG", EPSGFactoryFallback.toClass(n), string), this.getAuthorityTitle(), string);
            noSuchAuthorityCodeException.initCause(numberFormatException);
            throw noSuchAuthorityCodeException;
        }
        throw new NoSuchAuthorityCodeException(Resources.format((short)48, "EPSG", EPSGFactoryFallback.toClass(n), string, this.getInstallationURL()), this.getAuthorityTitle(), string);
    }

    private synchronized String getInstallationURL() {
        if (this.installationURL == null) {
            this.installationURL = "https://sis.apache.org/epsg.html";
            ServiceLoader<InstallationResources> serviceLoader = DefaultFactories.createServiceLoader(InstallationResources.class);
            boolean bl = false;
            do {
                String string = bl ? "Embedded" : "EPSG";
                for (InstallationResources installationResources : serviceLoader) {
                    String string2;
                    if (!installationResources.getAuthorities().contains(string) || (string2 = installationResources.getInstructionURL()) == null) continue;
                    this.installationURL = string2;
                    return string2;
                }
            } while (bl = !bl);
        }
        return this.installationURL;
    }

    private static Class<?> toClass(int n) {
        switch (n) {
            case 1: {
                return CoordinateReferenceSystem.class;
            }
            case 2: {
                return Datum.class;
            }
            case 4: {
                return Ellipsoid.class;
            }
            case 8: {
                return PrimeMeridian.class;
            }
            case 16: {
                return Unit.class;
            }
            case 32: {
                return CoordinateSystemAxis.class;
            }
            case 64: {
                return CoordinateSystem.class;
            }
        }
        return IdentifiedObject.class;
    }
}

