/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;
import javax.measure.IncommensurableException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.metadata.ImplementationHelper;
import org.apache.sis.internal.referencing.CoordinateOperations;
import org.apache.sis.internal.referencing.NilReferencingObject;
import org.apache.sis.internal.referencing.PositionalAccuracyConstant;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.internal.referencing.WKTUtilities;
import org.apache.sis.internal.system.Semaphores;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.io.wkt.Convention;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.Parameterized;
import org.apache.sis.referencing.AbstractIdentifiedObject;
import org.apache.sis.referencing.cs.CoordinateSystems;
import org.apache.sis.referencing.operation.AbstractSingleOperation;
import org.apache.sis.referencing.operation.DefaultConcatenatedOperation;
import org.apache.sis.referencing.operation.DefaultOperationMethod;
import org.apache.sis.referencing.operation.DefaultPassThroughOperation;
import org.apache.sis.referencing.operation.SubTypes;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.referencing.operation.transform.PassThroughTransform;
import org.apache.sis.util.Classes;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.UnsupportedImplementationException;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.quality.PositionalAccuracy;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.operation.ConcatenatedOperation;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.PassThroughOperation;
import org.opengis.util.InternationalString;

@XmlType(name="AbstractCoordinateOperationType", propOrder={"domainOfValidity", "scope", "operationVersion", "accuracy", "source", "target"})
@XmlRootElement(name="AbstractCoordinateOperation")
@XmlSeeAlso(value={AbstractSingleOperation.class, DefaultPassThroughOperation.class, DefaultConcatenatedOperation.class})
public class AbstractCoordinateOperation
extends AbstractIdentifiedObject
implements CoordinateOperation {
    private static final long serialVersionUID = 1237358357729193885L;
    CoordinateReferenceSystem sourceCRS;
    CoordinateReferenceSystem targetCRS;
    private CoordinateReferenceSystem interpolationCRS;
    private String operationVersion;
    Collection<PositionalAccuracy> coordinateOperationAccuracy;
    Extent domainOfValidity;
    private InternationalString scope;
    MathTransform transform;
    private transient Set<Integer> wrapAroundChanges;

    AbstractCoordinateOperation(Map<String, ?> map) {
        super(map);
        this.scope = Types.toInternationalString(map, "scope");
        this.domainOfValidity = Containers.property(map, "domainOfValidity", Extent.class);
        this.operationVersion = Containers.property(map, "operationVersion", String.class);
        Object obj = map.get("coordinateOperationAccuracy");
        if (obj != null) {
            this.coordinateOperationAccuracy = obj instanceof PositionalAccuracy[] ? CollectionsExt.nonEmptySet((PositionalAccuracy[])obj) : Collections.singleton((PositionalAccuracy)obj);
        }
    }

    public AbstractCoordinateOperation(Map<String, ?> map, CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, CoordinateReferenceSystem coordinateReferenceSystem3, MathTransform mathTransform) {
        this(map);
        this.sourceCRS = coordinateReferenceSystem;
        this.targetCRS = coordinateReferenceSystem2;
        this.interpolationCRS = coordinateReferenceSystem3;
        this.transform = mathTransform;
        this.checkDimensions(map);
    }

    final void checkDimensions(Map<String, ?> map) {
        MathTransform mathTransform = this.transform;
        if (mathTransform != null) {
            int n = ReferencingUtilities.getDimension(this.interpolationCRS);
            int n2 = 0;
            block4: while (true) {
                int n3;
                CoordinateReferenceSystem coordinateReferenceSystem;
                switch (n2) {
                    case 0: {
                        coordinateReferenceSystem = this.sourceCRS;
                        n3 = mathTransform.getSourceDimensions();
                        break;
                    }
                    case 1: {
                        coordinateReferenceSystem = this.targetCRS;
                        n3 = mathTransform.getTargetDimensions();
                        break;
                    }
                    default: {
                        break block4;
                    }
                }
                int n4 = ReferencingUtilities.getDimension(coordinateReferenceSystem);
                if (n != 0) {
                    if (n3 == n4 || n3 < n) {
                        throw new IllegalArgumentException(Resources.forProperties(map).getString((short)41));
                    }
                    n4 += n;
                }
                if (coordinateReferenceSystem != null && n3 != n4) {
                    throw new IllegalArgumentException(Errors.getResources(map).getString((short)190, super.getName().getCode(), n2, n4, n3));
                }
                ++n2;
            }
        }
        this.computeTransientFields();
    }

    final void computeTransientFields() {
        this.wrapAroundChanges = this.sourceCRS != null && this.targetCRS != null ? CoordinateOperations.wrapAroundChanges(this.sourceCRS, this.targetCRS.getCoordinateSystem()) : Collections.emptySet();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.computeTransientFields();
    }

    protected AbstractCoordinateOperation(CoordinateOperation coordinateOperation) {
        super(coordinateOperation);
        this.sourceCRS = coordinateOperation.getSourceCRS();
        this.targetCRS = coordinateOperation.getTargetCRS();
        this.interpolationCRS = AbstractCoordinateOperation.getInterpolationCRS(coordinateOperation);
        this.operationVersion = coordinateOperation.getOperationVersion();
        this.coordinateOperationAccuracy = coordinateOperation.getCoordinateOperationAccuracy();
        this.domainOfValidity = coordinateOperation.getDomainOfValidity();
        this.scope = coordinateOperation.getScope();
        this.transform = coordinateOperation.getMathTransform();
        if (coordinateOperation instanceof AbstractCoordinateOperation) {
            this.wrapAroundChanges = ((AbstractCoordinateOperation)coordinateOperation).wrapAroundChanges;
        } else {
            this.computeTransientFields();
        }
    }

    public static AbstractCoordinateOperation castOrCopy(CoordinateOperation coordinateOperation) {
        return SubTypes.castOrCopy(coordinateOperation);
    }

    public Class<? extends CoordinateOperation> getInterface() {
        return CoordinateOperation.class;
    }

    public boolean isDefiningConversion() {
        return this.sourceCRS == null && this.targetCRS == null || this.targetCRS instanceof GeneralDerivedCRS && ((GeneralDerivedCRS)this.targetCRS).getBaseCRS() == this.sourceCRS && ((GeneralDerivedCRS)this.targetCRS).getConversionFromBase() == this;
    }

    @Override
    public CoordinateReferenceSystem getSourceCRS() {
        return this.sourceCRS;
    }

    @Override
    public CoordinateReferenceSystem getTargetCRS() {
        return this.targetCRS;
    }

    public CoordinateReferenceSystem getInterpolationCRS() {
        return this.interpolationCRS;
    }

    static CoordinateReferenceSystem getInterpolationCRS(CoordinateOperation coordinateOperation) {
        return coordinateOperation instanceof AbstractCoordinateOperation ? ((AbstractCoordinateOperation)coordinateOperation).getInterpolationCRS() : null;
    }

    @Override
    @XmlElement(name="operationVersion")
    public String getOperationVersion() {
        return this.operationVersion;
    }

    @Override
    public Collection<PositionalAccuracy> getCoordinateOperationAccuracy() {
        return CollectionsExt.nonNull(this.coordinateOperationAccuracy);
    }

    public double getLinearAccuracy() {
        return PositionalAccuracyConstant.getLinearAccuracy(this);
    }

    @Override
    @XmlElement(name="domainOfValidity")
    public Extent getDomainOfValidity() {
        return this.domainOfValidity;
    }

    @Override
    @XmlElement(name="scope", required=true)
    public InternationalString getScope() {
        return this.scope;
    }

    @Override
    public MathTransform getMathTransform() {
        return this.transform;
    }

    OperationMethod getMethod() {
        return null;
    }

    ParameterDescriptorGroup getParameterDescriptors() {
        OperationMethod operationMethod;
        ParameterDescriptorGroup parameterDescriptorGroup = AbstractCoordinateOperation.getParameterDescriptors(this.transform);
        if (parameterDescriptorGroup == null && (operationMethod = this.getMethod()) != null) {
            parameterDescriptorGroup = operationMethod.getParameters();
        }
        return parameterDescriptorGroup;
    }

    static ParameterDescriptorGroup getParameterDescriptors(MathTransform mathTransform) {
        while (mathTransform != null) {
            if (mathTransform instanceof Parameterized) {
                ParameterDescriptorGroup parameterDescriptorGroup;
                if (Semaphores.queryAndSet(8)) {
                    throw new AssertionError();
                }
                try {
                    parameterDescriptorGroup = ((Parameterized)((Object)mathTransform)).getParameterDescriptors();
                }
                finally {
                    Semaphores.clear(8);
                }
                if (parameterDescriptorGroup != null) {
                    return parameterDescriptorGroup;
                }
            }
            if (!(mathTransform instanceof PassThroughTransform)) break;
            mathTransform = ((PassThroughTransform)mathTransform).getSubTransform();
        }
        return null;
    }

    ParameterValueGroup getParameterValues() throws UnsupportedOperationException {
        MathTransform mathTransform = this.transform;
        while (mathTransform != null) {
            if (mathTransform instanceof Parameterized) {
                ParameterValueGroup parameterValueGroup;
                if (Semaphores.queryAndSet(8)) {
                    throw new AssertionError();
                }
                try {
                    parameterValueGroup = ((Parameterized)((Object)mathTransform)).getParameterValues();
                }
                finally {
                    Semaphores.clear(8);
                }
                if (parameterValueGroup != null) {
                    return parameterValueGroup;
                }
            }
            if (!(mathTransform instanceof PassThroughTransform)) break;
            mathTransform = ((PassThroughTransform)mathTransform).getSubTransform();
        }
        throw new UnsupportedImplementationException(Classes.getClass(mathTransform));
    }

    public Set<Integer> getWrapAroundChanges() {
        return this.wrapAroundChanges;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (super.equals(object, comparisonMode)) {
            if (comparisonMode == ComparisonMode.STRICT) {
                AbstractCoordinateOperation abstractCoordinateOperation = (AbstractCoordinateOperation)object;
                if (Objects.equals(this.sourceCRS, abstractCoordinateOperation.sourceCRS) && Objects.equals(this.interpolationCRS, abstractCoordinateOperation.interpolationCRS) && Objects.equals(this.transform, abstractCoordinateOperation.transform) && Objects.equals(this.scope, abstractCoordinateOperation.scope) && Objects.equals(this.domainOfValidity, abstractCoordinateOperation.domainOfValidity) && Objects.equals(this.coordinateOperationAccuracy, abstractCoordinateOperation.coordinateOperationAccuracy)) {
                    if (Semaphores.queryAndSet(4)) {
                        return true;
                    }
                    try {
                        boolean bl = Objects.equals(this.targetCRS, abstractCoordinateOperation.targetCRS);
                        return bl;
                    }
                    finally {
                        Semaphores.clear(4);
                    }
                }
            } else {
                CoordinateOperation coordinateOperation = (CoordinateOperation)object;
                if ((comparisonMode.isIgnoringMetadata() || Utilities.deepEquals(this.getScope(), coordinateOperation.getScope(), comparisonMode) && Utilities.deepEquals(this.getDomainOfValidity(), coordinateOperation.getDomainOfValidity(), comparisonMode) && Utilities.deepEquals(this.getCoordinateOperationAccuracy(), coordinateOperation.getCoordinateOperationAccuracy(), comparisonMode)) && Utilities.deepEquals(this.getInterpolationCRS(), AbstractCoordinateOperation.getInterpolationCRS(coordinateOperation), comparisonMode)) {
                    CoordinateReferenceSystem coordinateReferenceSystem;
                    CoordinateReferenceSystem coordinateReferenceSystem2;
                    boolean bl = false;
                    if (Semaphores.queryAndSet(4)) {
                        if (comparisonMode.isIgnoringMetadata()) {
                            bl = comparisonMode == ComparisonMode.DEBUG;
                            comparisonMode = ComparisonMode.ALLOW_VARIANT;
                        }
                    } else {
                        try {
                            if (!Utilities.deepEquals(this.getTargetCRS(), coordinateOperation.getTargetCRS(), comparisonMode)) {
                                boolean bl2 = false;
                                return bl2;
                            }
                        }
                        finally {
                            Semaphores.clear(4);
                        }
                    }
                    if (Utilities.deepEquals(coordinateReferenceSystem2 = this.getSourceCRS(), coordinateReferenceSystem = coordinateOperation.getSourceCRS(), comparisonMode)) {
                        MathTransform mathTransform = this.getMathTransform();
                        MathTransform mathTransform2 = coordinateOperation.getMathTransform();
                        if (comparisonMode == ComparisonMode.ALLOW_VARIANT) {
                            try {
                                LinearTransform linearTransform = MathTransforms.linear(CoordinateSystems.swapAndScaleAxes(coordinateReferenceSystem2.getCoordinateSystem(), coordinateReferenceSystem.getCoordinateSystem()));
                                LinearTransform linearTransform2 = MathTransforms.linear(CoordinateSystems.swapAndScaleAxes(coordinateOperation.getTargetCRS().getCoordinateSystem(), this.getTargetCRS().getCoordinateSystem()));
                                mathTransform2 = MathTransforms.concatenate(linearTransform, mathTransform2, linearTransform2);
                            }
                            catch (RuntimeException | IncommensurableException exception) {
                                Logging.ignorableException(Logger.getLogger("org.apache.sis.referencing.operation"), AbstractCoordinateOperation.class, "equals", exception);
                            }
                        }
                        if (Utilities.deepEquals(mathTransform, mathTransform2, comparisonMode)) {
                            return true;
                        }
                        assert (!bl || Utilities.deepEquals(mathTransform, mathTransform2, ComparisonMode.DEBUG));
                    }
                }
            }
        }
        return false;
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode() + (long)Objects.hash(this.sourceCRS, this.targetCRS, this.interpolationCRS, this.transform);
    }

    @Override
    protected String formatTo(Formatter formatter) {
        OperationMethod operationMethod;
        super.formatTo(formatter);
        formatter.newLine();
        CoordinateReferenceSystem coordinateReferenceSystem = this.getSourceCRS();
        CoordinateReferenceSystem coordinateReferenceSystem2 = this.getTargetCRS();
        Convention convention = formatter.getConvention();
        boolean bl = convention.majorVersion() == 1;
        FormattableObject formattableObject = formatter.getEnclosingElement(1);
        boolean bl2 = formattableObject instanceof PassThroughOperation;
        boolean bl3 = formattableObject instanceof ConcatenatedOperation;
        boolean bl4 = false;
        if (!bl2 && !bl3) {
            boolean bl5 = bl4 = bl && coordinateReferenceSystem instanceof GeographicCRS && coordinateReferenceSystem2 instanceof GeographicCRS;
            if (bl4) {
                formatter.append(WKTUtilities.toFormattable(coordinateReferenceSystem));
                formatter.newLine();
                formatter.append(WKTUtilities.toFormattable(coordinateReferenceSystem2));
                formatter.newLine();
            } else {
                AbstractCoordinateOperation.append(formatter, coordinateReferenceSystem, "SourceCRS");
                AbstractCoordinateOperation.append(formatter, coordinateReferenceSystem2, "TargetCRS");
            }
        }
        if ((operationMethod = this.getMethod()) != null) {
            ParameterValueGroup parameterValueGroup;
            formatter.append(DefaultOperationMethod.castOrCopy(operationMethod));
            try {
                parameterValueGroup = this.getParameterValues();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                ParameterDescriptorGroup parameterDescriptorGroup = this.getParameterDescriptors();
                formatter.setInvalidWKT((IdentifiedObject)(parameterDescriptorGroup != null ? parameterDescriptorGroup : this), (Exception)unsupportedOperationException);
                parameterValueGroup = null;
            }
            if (parameterValueGroup != null) {
                boolean bl6 = bl4 || WKTUtilities.isEPSG(parameterValueGroup.getDescriptor(), false) && "EPSG".equalsIgnoreCase(Citations.toCodeSpace(formatter.getNameAuthority()));
                formatter.newLine();
                formatter.indent(1);
                for (GeneralParameterValue generalParameterValue : parameterValueGroup.values()) {
                    if (bl6 && !WKTUtilities.isEPSG(generalParameterValue.getDescriptor(), true)) continue;
                    WKTUtilities.append(generalParameterValue, formatter);
                }
                formatter.indent(-1);
            }
        }
        if (!(bl2 || bl4 || this instanceof ConcatenatedOperation)) {
            AbstractCoordinateOperation.append(formatter, this.getInterpolationCRS(), "InterpolationCRS");
            final double d = this.getLinearAccuracy();
            if (d > 0.0) {
                formatter.append(new FormattableObject(){

                    @Override
                    protected String formatTo(Formatter formatter) {
                        formatter.append(d);
                        return "OperationAccuracy";
                    }
                });
            }
        }
        if (bl4) {
            if (operationMethod == null || convention != Convention.WKT1_IGNORE_AXES) {
                formatter.setInvalidWKT(this, null);
            }
            return "GeogTran";
        }
        if (bl) {
            formatter.setInvalidWKT(this, null);
        }
        if (bl3) {
            formatter.setInvalidWKT(this, null);
            return "CoordinateOperationStep";
        }
        return "CoordinateOperation";
    }

    private static void append(Formatter formatter, final CoordinateReferenceSystem coordinateReferenceSystem, final String string) {
        if (coordinateReferenceSystem != null) {
            formatter.append(new FormattableObject(){

                @Override
                protected String formatTo(Formatter formatter) {
                    formatter.indent(-1);
                    formatter.append(WKTUtilities.toFormattable(coordinateReferenceSystem));
                    formatter.indent(1);
                    return string;
                }
            });
            formatter.newLine();
        }
    }

    AbstractCoordinateOperation() {
        super(NilReferencingObject.INSTANCE);
    }

    @XmlElement(name="sourceCRS")
    private CoordinateReferenceSystem getSource() {
        return this.isDefiningConversion() ? null : this.getSourceCRS();
    }

    private void setSource(CoordinateReferenceSystem coordinateReferenceSystem) {
        if (this.sourceCRS == null) {
            this.sourceCRS = coordinateReferenceSystem;
        } else if (!this.sourceCRS.equals(coordinateReferenceSystem)) {
            ImplementationHelper.propertyAlreadySet(AbstractCoordinateOperation.class, "setSource", "sourceCRS");
        }
    }

    @XmlElement(name="targetCRS")
    private CoordinateReferenceSystem getTarget() {
        return this.isDefiningConversion() ? null : this.getTargetCRS();
    }

    private void setTarget(CoordinateReferenceSystem coordinateReferenceSystem) {
        if (this.targetCRS == null) {
            this.targetCRS = coordinateReferenceSystem;
        } else if (!this.targetCRS.equals(coordinateReferenceSystem)) {
            ImplementationHelper.propertyAlreadySet(AbstractCoordinateOperation.class, "setTarget", "targetCRS");
        }
    }

    @XmlElement(name="coordinateOperationAccuracy")
    private PositionalAccuracy[] getAccuracy() {
        Collection<PositionalAccuracy> collection = this.getCoordinateOperationAccuracy();
        int n = collection.size();
        return n != 0 ? collection.toArray(new PositionalAccuracy[n]) : null;
    }

    private void setAccuracy(PositionalAccuracy[] positionalAccuracyArray) {
        if (this.coordinateOperationAccuracy == null) {
            this.coordinateOperationAccuracy = UnmodifiableArrayList.wrap(positionalAccuracyArray);
        } else {
            ImplementationHelper.propertyAlreadySet(AbstractCoordinateOperation.class, "setAccuracy", "coordinateOperationAccuracy");
        }
    }

    private void setOperationVersion(String string) {
        if (this.operationVersion == null) {
            this.operationVersion = string;
        } else {
            ImplementationHelper.propertyAlreadySet(AbstractCoordinateOperation.class, "setOperationVersion", "operationVersion");
        }
    }

    private void setDomainOfValidity(Extent extent) {
        if (this.domainOfValidity == null) {
            this.domainOfValidity = extent;
        } else {
            ImplementationHelper.propertyAlreadySet(AbstractCoordinateOperation.class, "setDomainOfValidity", "domainOfValidity");
        }
    }

    private void setScope(InternationalString internationalString) {
        if (this.scope == null) {
            this.scope = internationalString;
        } else {
            ImplementationHelper.propertyAlreadySet(AbstractCoordinateOperation.class, "setScope", "scope");
        }
    }

    void afterUnmarshal(Unmarshaller unmarshaller, Object object) {
        this.computeTransientFields();
    }
}

