/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.projection;

import java.io.Serializable;
import java.util.Optional;
import org.apache.sis.internal.util.DoubleDouble;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.projection.NormalizedProjection;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform2D;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.apache.sis.referencing.operation.transform.DomainDefinition;
import org.apache.sis.util.ComparisonMode;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

final class LongitudeWraparound
extends AbstractMathTransform2D
implements Serializable {
    private static final long serialVersionUID = -4658152274068444690L;
    final NormalizedProjection projection;
    final double bound;
    final boolean negative;
    private final Inverse inverse;

    LongitudeWraparound(NormalizedProjection normalizedProjection, double d, double d2) {
        this.projection = normalizedProjection;
        this.bound = d;
        this.negative = d < 0.0;
        this.inverse = new Inverse(this, d2 - d);
    }

    static double boundOfScaledLongitude(MatrixSIS matrixSIS, boolean bl) {
        DoubleDouble doubleDouble = DoubleDouble.castOrCopy(matrixSIS.getNumber(0, 0));
        doubleDouble.multiply(bl ? -180.0 : 180.0);
        return doubleDouble.doubleValue();
    }

    @Override
    public Optional<Envelope> getDomain(DomainDefinition domainDefinition) throws TransformException {
        return this.projection.getDomain(domainDefinition);
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return this.projection.getParameterDescriptors();
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        return this.projection.getParameterValues();
    }

    @Override
    protected ContextualParameters getContextualParameters() {
        return this.projection.getContextualParameters();
    }

    @Override
    public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) throws TransformException {
        double d = dArray[n];
        if (this.negative ? d < this.bound : d > this.bound) {
            if (dArray2 == null) {
                dArray2 = new double[2];
                n2 = 0;
            }
            dArray2[n2 + 1] = dArray[n + 1];
            dArray2[n2] = d - 2.0 * this.bound;
            return this.projection.transform(dArray2, n2, dArray2, n2, bl);
        }
        return this.projection.transform(dArray, n, dArray2, n2, bl);
    }

    @Override
    public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) throws TransformException {
        if (dArray != dArray2 || n != n2) {
            System.arraycopy(dArray, n, dArray2, n2, n3 * 2);
        }
        double d = 2.0 * this.bound;
        int n4 = n2 + n3 * 2;
        for (int i = n2; i < n4; i += 2) {
            double d2 = dArray2[i];
            if (!(this.negative ? d2 < this.bound : d2 > this.bound)) continue;
            dArray2[i] = d2 - d;
        }
        this.projection.transform(dArray2, n2, dArray2, n2, n3);
    }

    @Override
    public MathTransform2D inverse() throws NoninvertibleTransformException {
        return this.inverse;
    }

    @Override
    protected int computeHashCode() {
        return this.projection.hashCode() + Double.hashCode(this.bound);
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object instanceof LongitudeWraparound) {
            LongitudeWraparound longitudeWraparound = (LongitudeWraparound)object;
            return Numerics.epsilonEqual(this.bound, longitudeWraparound.bound, comparisonMode) && this.projection.equals(longitudeWraparound.projection, comparisonMode);
        }
        return false;
    }

    private static final class Inverse
    extends AbstractMathTransform2D.Inverse
    implements Serializable {
        private static final long serialVersionUID = -543869926271003589L;
        private final LongitudeWraparound forward;
        private final double bound;

        Inverse(LongitudeWraparound longitudeWraparound, double d) {
            this.forward = longitudeWraparound;
            this.bound = d;
        }

        @Override
        public MathTransform2D inverse() {
            return this.forward;
        }

        @Override
        public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) throws TransformException {
            if (bl && dArray2 == null) {
                dArray2 = new double[2];
                n2 = 0;
            }
            this.forward.projection.inverseTransform(dArray, n, dArray2, n2);
            MatrixSIS matrixSIS = bl ? Matrices.inverse(this.forward.transform(dArray2, n2, null, 0, true)) : null;
            double d = dArray2[n2];
            if (this.forward.negative ? d > this.bound : d < this.bound) {
                dArray2[n2] = d + 2.0 * this.forward.bound;
            }
            return matrixSIS;
        }

        @Override
        public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) throws TransformException {
            if (dArray == dArray2 && n < n2) {
                super.transform(dArray, n, dArray2, n2, n3);
            } else {
                double d = 2.0 * this.forward.bound;
                while (--n3 >= 0) {
                    this.forward.projection.inverseTransform(dArray, n, dArray2, n2);
                    double d2 = dArray2[n2];
                    if (this.forward.negative ? d2 > this.bound : d2 < this.bound) {
                        dArray2[n2] = d2 + d;
                    }
                    n += 2;
                    n2 += 2;
                }
            }
        }
    }
}

