/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.sis.internal.storage.Resources;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.util.resources.Errors;

final class ProbeInputStream
extends FilterInputStream {
    ProbeInputStream(StorageConnector storageConnector, InputStream inputStream) throws IOException, DataStoreException {
        super(inputStream);
        if (!inputStream.markSupported()) {
            throw new DataStoreException(Resources.format((short)62, storageConnector.getStorageName()));
        }
        inputStream.mark(8192);
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int n) {
    }

    @Override
    public void reset() throws IOException {
        throw new IOException(Errors.format((short)162, "reset"));
    }

    @Override
    public void close() throws IOException {
        InputStream inputStream = this.in;
        this.in = null;
        if (inputStream != null) {
            inputStream.reset();
        }
    }
}

