/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.iso;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.iso.AbstractName;
import org.apache.sis.util.iso.DefaultLocalName;
import org.apache.sis.util.iso.DefaultNameSpace;
import org.apache.sis.util.resources.Errors;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;
import org.opengis.util.LocalName;
import org.opengis.util.NameSpace;
import org.opengis.util.ScopedName;

@XmlTransient
public class DefaultScopedName
extends AbstractName
implements ScopedName {
    private static final long serialVersionUID = 1363103337249930577L;
    private final UnmodifiableArrayList<? extends LocalName> parsedNames;
    private transient GenericName tail;
    private transient GenericName path;

    static AbstractName create(UnmodifiableArrayList<? extends DefaultLocalName> unmodifiableArrayList) {
        ArgumentChecks.ensureNonEmpty("names", unmodifiableArrayList);
        if (unmodifiableArrayList.size() == 1) {
            return unmodifiableArrayList.get(0);
        }
        return new DefaultScopedName(unmodifiableArrayList);
    }

    private DefaultScopedName(UnmodifiableArrayList<? extends LocalName> unmodifiableArrayList) {
        this.parsedNames = unmodifiableArrayList;
    }

    protected DefaultScopedName(NameSpace nameSpace, List<? extends CharSequence> list) {
        ArgumentChecks.ensureNonNull("names", list);
        int n = list.size();
        ArgumentChecks.ensureSizeBetween("names", 2, Integer.MAX_VALUE, n);
        DefaultNameSpace defaultNameSpace = DefaultNameSpace.castOrCopy(nameSpace);
        boolean bl = defaultNameSpace.isGlobal();
        int n2 = 0;
        LocalName[] localNameArray = new LocalName[n];
        Iterator<? extends CharSequence> iterator = list.iterator();
        CharSequence charSequence = iterator.next();
        do {
            ArgumentChecks.ensureNonNullElement("names", n2, charSequence);
            localNameArray[n2++] = new DefaultLocalName(defaultNameSpace, charSequence);
            defaultNameSpace = defaultNameSpace.child(charSequence, defaultNameSpace.separator);
            charSequence = iterator.next();
        } while (iterator.hasNext());
        DefaultLocalName defaultLocalName = defaultNameSpace.local(charSequence, null);
        if (bl) {
            defaultLocalName.fullyQualified = this.fullyQualified = this;
        }
        localNameArray[n2++] = defaultLocalName;
        if (n2 != n) {
            throw new ConcurrentModificationException(Errors.format((short)134, "names"));
        }
        this.parsedNames = UnmodifiableArrayList.wrap(localNameArray);
    }

    protected DefaultScopedName(GenericName genericName, GenericName genericName2) {
        ArgumentChecks.ensureNonNull("path", genericName);
        ArgumentChecks.ensureNonNull("tail", genericName2);
        List<? extends LocalName> list = genericName.getParsedNames();
        List<? extends LocalName> list2 = genericName2.getParsedNames();
        int n = list.size();
        LocalName[] localNameArray = list.toArray(new LocalName[n + list2.size()]);
        Iterator<? extends LocalName> iterator = list2.iterator();
        LocalName localName = iterator.next();
        LocalName localName2 = localNameArray[n - 1];
        NameSpace nameSpace = localName2.scope();
        NameSpace nameSpace2 = localName.scope();
        if (nameSpace2 instanceof DefaultNameSpace && ((DefaultNameSpace)nameSpace2).parent() == nameSpace) {
            if (genericName instanceof LocalName) {
                this.tail = genericName2;
            }
            while (true) {
                localNameArray[n++] = localName;
                if (iterator.hasNext()) {
                    localName = iterator.next();
                    continue;
                }
                break;
            }
        } else {
            DefaultNameSpace defaultNameSpace = DefaultNameSpace.castOrCopy(nameSpace);
            CharSequence charSequence = DefaultScopedName.name(localName2);
            while (true) {
                defaultNameSpace = defaultNameSpace.child(charSequence, defaultNameSpace.separator);
                charSequence = DefaultScopedName.name(localName);
                localName = new DefaultLocalName(defaultNameSpace, charSequence);
                localNameArray[n++] = localName;
                if (!iterator.hasNext()) break;
                localName = iterator.next();
            }
        }
        if (n != localNameArray.length) {
            throw new ConcurrentModificationException(Errors.format((short)134, "tail"));
        }
        this.parsedNames = UnmodifiableArrayList.wrap(localNameArray);
        if (genericName2 instanceof LocalName) {
            this.path = genericName;
        }
    }

    protected DefaultScopedName(GenericName genericName, String string, CharSequence charSequence) {
        ArgumentChecks.ensureNonNull("path", genericName);
        ArgumentChecks.ensureNonNull("tail", charSequence);
        List<? extends LocalName> list = genericName.getParsedNames();
        int n = list.size();
        LocalName[] localNameArray = list.toArray(new LocalName[n + 1]);
        LocalName localName = localNameArray[n - 1];
        DefaultNameSpace defaultNameSpace = DefaultNameSpace.castOrCopy(localName.scope());
        defaultNameSpace = defaultNameSpace.child(DefaultScopedName.name(localName), string != null ? string : defaultNameSpace.separator);
        localNameArray[n] = new DefaultLocalName(defaultNameSpace, charSequence);
        this.parsedNames = UnmodifiableArrayList.wrap(localNameArray);
        this.path = genericName;
    }

    private static CharSequence name(GenericName genericName) {
        if (genericName instanceof DefaultLocalName) {
            return ((DefaultLocalName)genericName).name;
        }
        InternationalString internationalString = genericName.toInternationalString();
        return internationalString != null ? internationalString : genericName.toString();
    }

    @Override
    final int arraySize() {
        return this.parsedNames.arraySize();
    }

    @Override
    public NameSpace scope() {
        return this.head().scope();
    }

    @Override
    public synchronized GenericName tail() {
        if (this.tail == null) {
            int n = this.parsedNames.size();
            switch (n) {
                default: {
                    this.tail = new DefaultScopedName((UnmodifiableArrayList<? extends LocalName>)this.parsedNames.subList(1, n));
                    break;
                }
                case 2: {
                    this.tail = this.parsedNames.get(1);
                    break;
                }
                case 0: 
                case 1: {
                    throw new AssertionError(n);
                }
            }
        }
        return this.tail;
    }

    @Override
    public synchronized GenericName path() {
        if (this.path == null) {
            int n = this.parsedNames.size();
            switch (n) {
                default: {
                    this.path = new DefaultScopedName((UnmodifiableArrayList<? extends LocalName>)this.parsedNames.subList(0, n - 1));
                    break;
                }
                case 2: {
                    this.path = this.parsedNames.get(0);
                    break;
                }
                case 0: 
                case 1: {
                    throw new AssertionError(n);
                }
            }
        }
        return this.path;
    }

    @Override
    public List<? extends LocalName> getParsedNames() {
        return this.parsedNames;
    }
}

