/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.logging;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.LogManager;

public class Initializer {
    private static final String PROPERTY = "java.util.logging.FileHandler.pattern";
    private static final String PATTERN = "%p";

    public Initializer() throws IOException {
        String string = System.getProperty("java.util.logging.config.file");
        if (string != null) {
            Path path = Paths.get(string, new String[0]).normalize();
            StringBuilder stringBuilder = new StringBuilder(600);
            for (String string2 : Files.readAllLines(path)) {
                int n;
                if ((string2 = string2.trim()).isEmpty() || string2.charAt(0) == '#') continue;
                int n2 = stringBuilder.length();
                stringBuilder.append(string2).append('\n');
                if (!string2.startsWith(PROPERTY) || (n = stringBuilder.indexOf(PATTERN, n2 + PROPERTY.length())) < 0) continue;
                Path path2 = path;
                int n3 = Math.min(path2.getNameCount(), 2);
                while (--n3 >= 0) {
                    path2 = path2.getParent();
                }
                String string3 = path2 != null ? path2.toString() : ".";
                string3 = string3.replace(File.separatorChar, '/');
                stringBuilder.replace(n, n + PATTERN.length(), string3);
            }
            LogManager.getLogManager().readConfiguration(new ByteArrayInputStream(stringBuilder.toString().getBytes()));
        }
    }
}

